#ifndef N2_COM_256X132ASYNC_DP_CUST_ARRAY_H
#define N2_COM_256X132ASYNC_DP_CUST_ARRAY_H

#include <systemc>

SC_MODULE(n2_com_256x132async_dp_cust_array)
{
  sc_core::sc_in<bool> wr_clk;  
  /* write clk */ 
  sc_core::sc_in< sc_dt::sc_bv<8> > wr_addr_array; 	
  /* write port address in */
  sc_core::sc_in<bool> wr_en_array;
  /* write port enable */
  sc_core::sc_in< sc_dt::sc_bv<132> > din_array;
  /* data in */
  sc_core::sc_in<bool> rd_clk;	/* read clk */ 
  sc_core::sc_in< sc_dt::sc_bv<8> > rd_addr_array;
  /* read port address in */
  sc_core::sc_in<bool>	rd_en_array;
  /* read port enable */
  sc_core::sc_out< sc_dt::sc_bv<132> > dout_array;	
  /* data out */

  
  sc_dt::sc_bv<132> array_ram[256];
  sc_dt::sc_bv<132> tmp_dout;
  sc_dt::sc_bv<132> tmp; 
  bool notinitialized;
  unsigned int i;
  
  void initialize_array()
  {
    unsigned int i;
    if(notinitialized == false)
    { 
      tmp="0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
      tmp_dout="0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
      for(i = 0 ; i < 256; i++) { array_ram[i] = tmp; }
      notinitialized = true;
    }
  }

  
  void n2_com_256x132async_dp_cust_array_proc0()
  {
    while(1)
    {
      wait();
      if(rd_clk.read() == true)
      {
        if(rd_en_array.read() == true)
        {
          tmp_dout = array_ram[rd_addr_array.read().to_int()];
        }
      }
    }
  }
  
  void n2_com_256x132async_dp_cust_array_proc1()
  {
    while(1)
    {
      wait();
      if(rd_clk.read() == true)
      {
        if(rd_en_array.read() == true)
        {
          if((wr_en_array.read() == true) && 
          rd_addr_array.read() == wr_addr_array.read())
          {
            std::cout<<"Simultaneous read/write disallowed ... "<<std::endl;
          }
          else
          {
            tmp_dout = array_ram[rd_addr_array.read().to_int()];
          }
        }
      }
    }
  }
  

  void n2_com_256x132async_dp_cust_array_proc2()
  {
    while(1)
    {
      wait();
       if(wr_clk.read() == false)
       {
         if(wr_en_array.read() == true)
         {
           tmp = din_array.read();
           array_ram[wr_addr_array.read().to_int()] = tmp;
         }
       }
    }
  }

  void n2_com_256x132async_dp_cust_array_proc3()
  {
    dout_array.write(tmp_dout);
  }

  SC_CTOR(n2_com_256x132async_dp_cust_array):i(0), 
         notinitialized(false)
  {
    
    initialize_array(); 
    SC_METHOD(n2_com_256x132async_dp_cust_array_proc3);
    SC_THREAD(n2_com_256x132async_dp_cust_array_proc0);
    sensitive << rd_clk << rd_en_array << rd_addr_array;
    SC_THREAD(n2_com_256x132async_dp_cust_array_proc1);
    sensitive << rd_clk << rd_en_array <<  rd_addr_array << wr_en_array << wr_addr_array; 
    SC_THREAD(n2_com_256x132async_dp_cust_array_proc2);
    sensitive << wr_en_array << wr_addr_array << wr_clk << din_array;  
  }

  ~n2_com_256x132async_dp_cust_array(){ }

};

#endif

  
/*
module n2_com_256x132async_dp_cust_array	(

   wr_clk,
   wr_addr_array,
   wr_en_array,
   din_array, 

   rd_clk,
   rd_addr_array,
   rd_en_array, 
   dout_array    

);


input		wr_clk;				// write clk 
input	  [7:0]	wr_addr_array;			// write port address in
input		wr_en_array;			// write port enable
input	[131:0] din_array;			// data in

input 		rd_clk;				// read clk 
input	  [7:0]	rd_addr_array;			// read port address in
input		rd_en_array;			// read port enable
output	[131:0] dout_array;			// data out


// ----------------------------------------------------------------------------
// Zero In Checkers
// ----------------------------------------------------------------------------
// checker to verify on accesses's that no bits are x
// 0in kndr -var rd_addr_array
// 0in kndr -var wr_addr_array
// 0in kndr -var rd_en_array
// 0in kndr -var wr_en_array


reg	[131:0]	array_ram      [0:255];
reg	[131:0]	dout_array;

// Initialize the array
`ifndef NOINITMEM
integer i;

initial begin
  for (i=0; i<256; i=i+1) begin
    array_ram[i] = 132'b0;
  end
  dout_array[131:0] = 132'b0;			// N2+ Bug 103693
end
`endif
*/
// ----------------------------------------------------------------------------
// Read the array
// ----------------------------------------------------------------------------
/* 
always @(rd_clk or rd_en_array or  rd_addr_array ) begin
   if (rd_clk) begin
      if (rd_en_array) begin
	 dout_array[131:0] <= array_ram[rd_addr_array[7:0]];
      end
   end
end
*/
/*
always @(rd_clk or rd_en_array or  rd_addr_array or wr_en_array or
         wr_addr_array) begin
   if (rd_clk) begin
      if (rd_en_array) begin
        if (wr_en_array & (rd_addr_array == wr_addr_array))  // 0in < fire -severity 1 -message "Detected rd/wr collision in PEU I/EHB RAM, dout driven as X's" -group mbist_mode
            dout_array[131:0] <= {132{1'bx}} ;
         else
         dout_array[131:0] <= array_ram[rd_addr_array[7:0]];
      end
   end
end
*/


/*
// ----------------------------------------------------------------------------
// Write the array, note: it is written when the clock is low
// ----------------------------------------------------------------------------
always @(wr_en_array or wr_addr_array or wr_clk or din_array ) begin
   if (~wr_clk) begin
      if(wr_en_array ) begin
	  array_ram[wr_addr_array[7:0]] <= din_array[131:0];
      end
   end
end


endmodule	// n2_com_256x132async_dp_cust_array
*/

