#ifndef PRN_H
#define PRN_H

#include <systemc>

SC_MODULE(x_or)
{
  sc_core::sc_in<bool> xorin0;
  sc_core::sc_in<bool> xorin1;
  sc_core::sc_out<bool> xorout;
  bool b0;
  bool b1;
  bool b2;

  void x_or_proc0()
  {
    while(1)
    {
      wait();
      b0 = xorin0.read();
      b1 = xorin1.read();
      b2 = (((!b0) & b1) | (b0 & (!b1)));
      xorout.write(b2);
    }
  }

  SC_CTOR(x_or):b0(false), b1(false), b2(false)
  {
    SC_THREAD(x_or_proc0);
    sensitive << xorin0 << xorin1;
  }
  
  ~x_or(){}
};

SC_MODULE(dff)
{
  sc_core::sc_in<bool> clk; 
  sc_core::sc_in<bool> din;
  sc_core::sc_out<bool> dout;
  bool b0;
  bool b1;
   
  void dff_proc0()
  {
    while(1)
    {
      wait();
      b0 = din.read(); 
      dout.write(b1);
      if(b0 != b1) b1 = b0;
    }
  }

  SC_CTOR(dff)
  {
    SC_CTHREAD(dff_proc0, clk.pos());
  }
  ~dff(){ }
};

SC_MODULE(dffdualout)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> din;
  sc_core::sc_out<bool> dout;
  sc_core::sc_out<bool> dualout;
  bool b0;
  bool b1;

  void dffdualout_proc0()
  {
    while(1)
    {
      wait();
      b0 = din.read();
      dout.write(b1);
      dualout.write(b1);
      if(b0 != b1) b1 = b0;
    }
  }

  SC_CTOR(dffdualout)
  {
    SC_CTHREAD(dffdualout_proc0, clk.pos());
  }
  ~dffdualout(){ }
};


SC_MODULE(prn)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<bool> prnout;

  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;

  dff dff_0;
  dff dff_1;
  dff dff_2;
  dff dff_3;
  dff dff_4;
  dff dff_5;
  dff dff_6;
  dffdualout dff_7;
  x_or x_o_r;
 
  SC_CTOR(prn):dff_0("dff_0"), dff_1("dff_1"), dff_2("dff_2"),
               dff_3("dff_3"), dff_4("dff_4"), dff_5("dff_5"),
               dff_6("dff_6"), dff_7("dff_7"), x_o_r("x_o_r")
  {
    dff_0.clk(clk);
    dff_0.din(sig8);
    dff_0.dout(sig0);

    dff_1.clk(clk);
    dff_1.din(sig0);
    dff_1.dout(sig1);

    dff_2.clk(clk);
    dff_2.din(sig1);
    dff_2.dout(sig2);
  
    dff_3.clk(clk);
    dff_3.din(sig2);
    dff_3.dout(sig3);
    
    dff_4.clk(clk);
    dff_4.din(sig3);
    dff_4.dout(sig4);
  
    dff_5.clk(clk);
    dff_5.din(sig4);
    dff_5.dout(sig5);

    dff_6.clk(clk);
    dff_6.din(sig5);
    dff_6.dout(sig6);

    dff_7.clk(clk);
    dff_7.din(sig6);
    dff_7.dout(sig7);
    dff_7.dualout(prnout);

    x_o_r.xorin0(sig6);
    x_o_r.xorin1(sig7);
    x_o_r.xorout(sig8);

    dff_0.b1 = true;
    dff_1.b1 = false;
    dff_2.b1 = true;
    dff_3.b1 = false;
    dff_4.b1 = true;
    dff_5.b1 = false;
    dff_6.b1 = true;
    dff_7.b1 = false;
  }
    
  ~prn(){ }
};

#endif

