#ifndef QPSKMODDEMOD_H
#define QPSKMODDEMOD_H

#include <systemc-ams>

const unsigned int MAX_COUNT = 512;
const unsigned int MAX_NUM = 1500;

SCA_TDF_MODULE(bitsrc)
{
  sca_tdf::sca_out<bool> bitout;
  bool b0;
  unsigned int count;
 
  void set_attributes()
  {
    bitout.set_timestep(1.0, sc_core::SC_NS);
    bitout.set_rate(1);
  }

  void processing()
  {
    if(count == MAX_NUM)
    {
      count = 0;
      b0 = std::rand() % 2;
    }
    else
    {
      count += 1;
    }
    bitout.write(b0);
  }

  SCA_CTOR(bitsrc):b0(false),count(0) { }
  ~bitsrc() { }
};

SCA_TDF_MODULE(demultiplexer)
{
  sca_tdf::sca_in<bool> bitin;
  sca_tdf::sca_out<bool> bitout1;
  sca_tdf::sca_out<bool> bitout2;
  bool togglevalue;
  bool tmp;  

  void set_attributes()
  {
    bitout1.set_timestep(1.0, sc_core::SC_NS);
    bitout2.set_timestep(1.0, sc_core::SC_NS);
    bitin.set_rate(1);
    bitout1.set_rate(1);
    bitout2.set_rate(1);
  }

  void processing()
  {
    tmp = bitin.read();
    if(togglevalue == false)
    {
      bitout1.write(tmp);
     /* togglevalue = true; */
    }
    else if(togglevalue == true)
    {
      bitout2.write(tmp);
    /*  togglevalue = false; */
    }
    togglevalue = togglevalue == true ? false:true;
  }

  SCA_CTOR(demultiplexer) : togglevalue(false) { }
  ~demultiplexer() { }
};

SCA_TDF_MODULE(multiplexer)
{
  sca_tdf::sca_in<bool> bsigin1;
  sca_tdf::sca_in<bool> bsigin2;
  sca_tdf::sca_out<bool> bsigout;
  bool value1;
  bool value2; 
  bool togglevalue;

  void set_attributes()
  {
    bsigin1.set_rate(1);
    bsigin2.set_rate(1);
    bsigout.set_timestep(1.0, sc_core::SC_NS);
    bsigout.set_rate(1);
  }  

  void processing()
  {
    value1 = bsigin1.read();
    value2 = bsigin2.read();
    /*bsigout.write(value1);
    bsigout.write(value2); 
    cout<<value1<<" "<<value2<<" "; */
    
    if(togglevalue == false)
    {
      bsigout.write(bsigin1.read());
     /* togglevalue = true; */
    }
    else if(togglevalue == true)
    {
      bsigout.write(bsigin2.read());
     /* togglevalue = false; */
    } 
    togglevalue = togglevalue == true ? false :true;
  }
  
  SCA_CTOR(multiplexer) : togglevalue(false) { }
  ~multiplexer() { }
};

SCA_TDF_MODULE(rz)
{
  sca_tdf::sca_in<double> dsigin;
  sca_tdf::sca_out<bool> bsigout;
  bool bvalueout;

  void set_attributes()
  {
    dsigin.set_rate(1);
    bsigout.set_timestep(1.0, sc_core::SC_NS);
    bsigout.set_rate(1);
  }

  void processing()
  {
    bvalueout = (dsigin.read() > 0.0) ? true : false;
    bsigout.write(bvalueout);
  }
    
  SCA_CTOR(rz) { }
  ~rz(){ }
};


SCA_TDF_MODULE(nrz)
{
  sca_tdf::sca_in<bool> bitin;
  sca_tdf::sca_out<int> nrzout;
  bool tmpbool;
  int valueout;

  void set_attributes()
  {
    nrzout.set_timestep(1.0, sc_core::SC_NS);
    bitin.set_rate(1);
    nrzout.set_rate(1);
  }

  void processing()
  {
    tmpbool = bitin.read();
    valueout = tmpbool == true ? 1 : -1;
    nrzout.write(valueout);
  }

  SCA_CTOR(nrz){ }
  ~nrz() { }
};

SCA_TDF_MODULE(carrier)
{
  sca_tdf::sca_out<double> carrout;
  sca_tdf::sca_out<double> carroutps;
  double sampleperiod;
  double freq;
  double carrvalue;
  double carrvalueps;
  double timevalue;

  void set_attributes()
  {
  /*module time step = output port time step x output port rate */
    carrout.set_timestep(1.0, sc_core::SC_NS);
    carrout.set_rate(1);
  }

  void processing()
  {
    timevalue = carrout.get_time().to_seconds();
    carrvalue = (2.0/sampleperiod)*sin(2.0*3.14*freq*timevalue);
    carrvalueps = (2.0/sampleperiod)*cos(2.0*3.14*freq*timevalue);
    carrout.write(carrvalue);
    carroutps.write(carrvalueps);
  }
 
  SCA_CTOR(carrier) {  }
  ~carrier() { }
};

SCA_TDF_MODULE(qpsk)
{
  sca_tdf::sca_in<int> iin1;
  sca_tdf::sca_in<int> iin2;
  sca_tdf::sca_in<double> carrier;
  sca_tdf::sca_in<double> carrierps;
  sca_tdf::sca_out<double> modsig;

  double c1;
  double c2;
  double outval;
  int i1;
  int i2;

   void set_attributes()
  {
  /*module time step = output port time step x output port rate */
    iin1.set_rate(1);
    iin2.set_rate(1);
    carrier.set_rate(1);
    carrierps.set_rate(1);
    modsig.set_timestep(1.0, sc_core::SC_NS);
    modsig.set_rate(1);
  }

  void processing()
  {
    c1 = carrier.read();
    c2 = carrierps.read();
    i1 = iin1.read();
    i2 = iin2.read();
    outval = i1*c1 - i2*c2;
    modsig.write(outval);
  }

  SCA_CTOR(qpsk) { }
  ~qpsk() { }
};

SCA_TDF_MODULE(qpskdemod)
{
  sca_tdf::sca_in<double> mod_sig;
  sca_tdf::sca_in<double> carrier;
  sca_tdf::sca_in<double> carrierps;
  sca_tdf::sca_out<double> out1;
  sca_tdf::sca_out<double> out2;

  double mod_value;
  double carvalue;
  double carvalueps;
  double sigvalue1;
  double sigvalue2;

  void set_attributes()
  {
  /*module time step = output port time step x output port rate */
    mod_sig.set_rate(1);
    carrier.set_rate(1);
    carrierps.set_rate(1);
    out1.set_timestep(1.0, sc_core::SC_NS);
    out2.set_timestep(1.0, sc_core::SC_NS);
    out1.set_rate(1);
    out2.set_rate(1);
  }

  void processing()
  {
    mod_value = mod_sig.read();
    carvalue = carrier.read();
    carvalueps = carrierps.read();
    sigvalue1 = mod_value*carvalue;
    sigvalue2 = mod_value*carvalueps;
    out1.write(sigvalue1);
    out2.write(sigvalue2); 
  }

    SCA_CTOR(qpskdemod) { }
  ~qpskdemod() { }
};


SC_MODULE(lpfilt)
{
  sca_tdf::sca_in<double> insig;
  sca_tdf::sca_out<double> outsig;

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_c cap;
  sca_eln::sca_r res;
  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node_ref gnd;
  double capacitorvalue;
  double resistorvalue;

  void set_attributes()
  {
  /*module time step = output port time step x output port rate*/
     insig.set_rate(1);
    outsig.set_timestep(1.0, sc_core::SC_NS);
    outsig.set_rate(1);
  }

  SC_CTOR(lpfilt):v_in("v_in",1.0), 
                  v_out("v_out",1.0),
                  cap("cap", capacitorvalue),
                  res("res", resistorvalue) 
  {
    
    v_in.inp(insig);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outsig);
    v_out.p(n2);
    v_out.n(gnd);

    cap.p(n2);
    cap.n(gnd);
    res.p(n1);
    res.n(n2); 
  }

  ~lpfilt()
  {
  }
};

SC_MODULE(hpfilt)
{
  sca_tdf::sca_in<double> insig;
  sca_tdf::sca_out<double> outsig; 

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_c cap;
  sca_eln::sca_r res;
  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node_ref gnd;
  double capacitorvalue;
  double resistorvalue;

  void set_attributes()
  {
    insig.set_rate(1);
    outsig.set_timestep(1.0, sc_core::SC_NS);
    outsig.set_rate(1);
  }

  SC_CTOR(hpfilt):v_in("v_in",1.0),
                  v_out("v_out", 1.0),
                  cap("cap",capacitorvalue),
                  res("res", resistorvalue)
  {
   
    v_in.inp(insig);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outsig);
    v_out.p(n2);
    v_out.n(gnd);

    cap.p(n2);
    cap.n(gnd);
    res.p(n1);
    res.n(n2);
  }
  
  ~hpfilt() 
  {
  }
};

SC_MODULE(bpfilt)
{
  sca_tdf::sca_in<double> insig;
  sca_tdf::sca_out<double> outsig;

  sca_eln::sca_tdf::sca_vsource v_in;
  sca_eln::sca_tdf::sca_vsink   v_out;
  sca_eln::sca_c cap;
  sca_eln::sca_l ind;
  sca_eln::sca_r res;
  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node n3;
  sca_eln::sca_node_ref gnd;
  double capacitorvalue;
  double inductorvalue;
  double resistorvalue;

  void set_attributes()
  {
    insig.set_rate(1);
    outsig.set_timestep(1.0, sc_core::SC_NS);
    outsig.set_rate(1);
  }

  SC_CTOR(bpfilt):v_in("v_in",1.0),
                  v_out("v_out",1.0),
                  cap("cap", capacitorvalue),
                  ind("ind", inductorvalue),
                  res("res", resistorvalue)
  {

    v_in.inp(insig);
    v_in.p(n1);
    v_in.n(gnd);

    v_out.outp(outsig);
    v_out.p(n2);
    v_out.n(gnd);

    cap.p(n2);
    cap.n(n3);
    ind.p(n1);
    ind.n(n2);
    res.p(n3);
    res.n(gnd);
  }

  ~bpfilt( )
  {
  }
};

 

SCA_TDF_MODULE(quad)
{
  sca_tdf::sca_in<double> mod_sig;
  sca_tdf::sca_out<double> pow4out;
  double sig_in;
  double sig_out;

  void set_attributes()
  {
    mod_sig.set_rate(1);
    pow4out.set_timestep(1.0, sc_core::SC_NS);
    pow4out.set_rate(1);
  }

  void processing()
  {
    sig_in = mod_sig.read();
    sig_out = sig_in*sig_in*sig_in*sig_in;
    pow4out.write(sig_out);
  }

  SCA_CTOR(quad){ }
  ~quad() { }
};

   
#endif

         
