#ifndef SCOREBOARD_H
#define SCOREBOARD_H

#include <systemc>

const unsigned int MAX = 4;
const sc_dt::sc_bv<64> statusreg = "111111111111111111111111111111111111111111111111111111111111111111111111";

SC_MODULE(onecounter)
{
  sc_core::sc_in< sc_dt::sc_bv<8> > in;
  sc_core::sc_out< sc_dt::sc_bv<4> > out;

  sc_dt::sc_bv<8> inbits;
  sc_dt::sc_bv<4> outbits;
  unsigned int count;
  unsigned int i;

  void process_input()
  {
    while(1)
    {
      wait();
      inbits = in.read();
      count = 0;
      outbits = "0000";

      for(i = 0; i < 8; i++)
      {
        if(count == 4) break;
        if(inbits[i] == '1') count++;
      }

      if(count < 4)
      {
        for(i = 0; i < count; i++) outbits[MAX-1-i] = "1";
      }
      else
      {
        outbits = "1111";
      }
      out.write(outbits);
      std::cout<<"8 sort In : "<<inbits<<" Out : "<<outbits<<std::endl;
    }
    count = 0; 
  }

  SC_CTOR(onecounter) 
  { 
    SC_THREAD(process_input);
    sensitive << in; 
  }
  ~onecounter() { }
};

SC_MODULE(onehot)
{
  sc_core::sc_in< sc_dt::sc_bv<4> > in;
  sc_core::sc_out< sc_dt::sc_bv<5> > out; 

  sc_dt::sc_bv<4> input;
  sc_dt::sc_bv<5> output;
  
  unsigned int count;
  unsigned int i;

  void process_input()
  {
    count = 0;
    i = 0;
    input = "0000";
    while(1)
    {
      wait();
      count = 0;
      i = 0;
      input = in.read();
      for(; i < MAX; i++)
      {
        if(input[i] == '1') count++;
      }
    
      if(count == 0) output = "00000";
      else if(count == 1) output = "01000";
      else if(count == 2) output = "00100";
      else if(count == 3) output = "00010";
      else if(count == 4) output = "00001";
      out.write(output);
      std::cout<<"1 hot In : "<<input<<" Out : "<<output<<std::endl;
    } 
  }

  SC_CTOR(onehot) 
  { 
    SC_THREAD(process_input);
    sensitive << in;
  }
  ~onehot(){ }
};


SC_MODULE(wakeup_mux)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<4> > din;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg;
  sc_dt::sc_bv<5> tmp0;
  sc_dt::sc_bv<5> tmp1;
  sc_dt::sc_bv<5> sel_in;
  sc_dt::sc_bv<4> din_in; 
  sc_dt::sc_bv<1> tmp2;
  sc_dt::sc_bv<1> tmp3;

  void wakeup_mux_proc0()
  {
    while(1)
    {
      wait();
      din_in = din.read();
      sel_in = sel.read();
      tmp0.range(4,4) = tmp2.range(0,0);
      tmp0.range(3,0) = din_in.range(3,0);
      tmp1 = tmp0 & sel_in;
      tmp3 = tmp1.or_reduce();
    }
  }

  void wakeup_mux_proc1()
  {
    while(1)
    {
      wait();
      new_reg.write(tmp3);
    }
  } 

  void wakeup_mux_proc2()
  {
    while(1)
    {
      wait();
      tmp2 = tmp3;
    }
  }

  SC_CTOR(wakeup_mux):tmp0("00000"),tmp1("00000"),tmp2("0"),tmp3("0")
  {
    SC_THREAD(wakeup_mux_proc0);
    sensitive << din << sel;
    SC_CTHREAD(wakeup_mux_proc1, clk.pos());
    SC_CTHREAD(wakeup_mux_proc2, clk.neg());
  }

  ~wakeup_mux(){ }
};

SC_MODULE(register64cell)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_in< sc_dt::sc_bv<4> > din_63;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_63;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_62;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_62;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_61;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_61;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_60;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_60;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_59;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_59;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_58;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_58;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_57;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_57;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_56;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_56;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_55;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_55;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_54;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_54;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_53;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_53;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_52;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_52;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_51;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_51;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_50;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_50;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_49;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_49;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_48;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_48;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_47;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_47;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_46;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_46;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_45;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_45;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_44;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_44;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_43;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_43;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_42;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_42;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_41;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_41;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_40;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_40;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_39;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_39;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_38;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_38;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_37;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_37;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_36;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_36;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_35;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_35;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_34;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_34;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_33;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_33;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_32;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_32;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_31;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_31;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_30;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_30;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_29;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_29;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_28;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_28;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_27;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_27;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_26;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_26;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_25;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_25;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_24;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_24;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_23;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_23;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_22;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_22;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_21;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_21;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_20;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_20;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_19;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_19;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_18;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_18;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_17;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_17;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_16;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_16;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_15;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_15;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_14;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_14;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_13;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_13;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_12;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_12;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_11;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_11;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_10;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_10;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_9;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_9;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_8;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_8;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_7;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_7;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_6;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_6;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_5;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_5;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_4;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_4;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_3;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_3;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_2;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_2;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_1;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_1;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_0;
  sc_core::sc_out< sc_dt::sc_bv<1> > new_reg_0;

  wakeup_mux w_m_63;
  wakeup_mux w_m_62;
  wakeup_mux w_m_61;
  wakeup_mux w_m_60;
  wakeup_mux w_m_59;
  wakeup_mux w_m_58;
  wakeup_mux w_m_57;
  wakeup_mux w_m_56;
  wakeup_mux w_m_55;
  wakeup_mux w_m_54;
  wakeup_mux w_m_53;
  wakeup_mux w_m_52;
  wakeup_mux w_m_51;
  wakeup_mux w_m_50;
  wakeup_mux w_m_49;
  wakeup_mux w_m_48;
  wakeup_mux w_m_47;
  wakeup_mux w_m_46;
  wakeup_mux w_m_45;
  wakeup_mux w_m_44;
  wakeup_mux w_m_43;
  wakeup_mux w_m_42;
  wakeup_mux w_m_41;
  wakeup_mux w_m_40;
  wakeup_mux w_m_39;
  wakeup_mux w_m_38;
  wakeup_mux w_m_37;
  wakeup_mux w_m_36;
  wakeup_mux w_m_35;
  wakeup_mux w_m_34;
  wakeup_mux w_m_33;
  wakeup_mux w_m_32;
  wakeup_mux w_m_31;
  wakeup_mux w_m_30;
  wakeup_mux w_m_29;
  wakeup_mux w_m_28;
  wakeup_mux w_m_27;
  wakeup_mux w_m_26;
  wakeup_mux w_m_25;
  wakeup_mux w_m_24;
  wakeup_mux w_m_23;
  wakeup_mux w_m_22;
  wakeup_mux w_m_21;
  wakeup_mux w_m_20;
  wakeup_mux w_m_19;
  wakeup_mux w_m_18;
  wakeup_mux w_m_17;
  wakeup_mux w_m_16;
  wakeup_mux w_m_15;
  wakeup_mux w_m_14;
  wakeup_mux w_m_13;
  wakeup_mux w_m_12;
  wakeup_mux w_m_11;
  wakeup_mux w_m_10;
  wakeup_mux w_m_9;
  wakeup_mux w_m_8;
  wakeup_mux w_m_7;
  wakeup_mux w_m_6;
  wakeup_mux w_m_5;
  wakeup_mux w_m_4;
  wakeup_mux w_m_3;
  wakeup_mux w_m_2;
  wakeup_mux w_m_1;
  wakeup_mux w_m_0;
  
  SC_CTOR(register64cell):w_m_63("w_m_63"),w_m_62("w_m_62"),
                         w_m_61("w_m_61"),w_m_60("w_m_60"),
                         w_m_59("w_m_59"),w_m_58("w_m_58"),
                         w_m_57("w_m_57"),w_m_56("w_m_56"),
                         w_m_55("w_m_55"),w_m_54("w_m_54"),
                         w_m_53("w_m_53"),w_m_52("w_m_52"),
                         w_m_51("w_m_51"),w_m_50("w_m_50"),
                         w_m_49("w_m_49"),w_m_48("w_m_48"),
                         w_m_47("w_m_47"),w_m_46("w_m_46"),
                         w_m_45("w_m_45"),w_m_44("w_m_44"),
                         w_m_43("w_m_43"),w_m_42("w_m_42"),
                         w_m_41("w_m_41"),w_m_40("w_m_40"),
                         w_m_39("w_m_39"),w_m_38("w_m_38"),
                         w_m_37("w_m_37"),w_m_36("w_m_36"),
                         w_m_35("w_m_35"),w_m_34("w_m_34"),
                         w_m_33("w_m_33"),w_m_32("w_m_32"),
                         w_m_31("w_m_31"),w_m_30("w_m_30"),
                         w_m_29("w_m_29"),w_m_28("w_m_28"),
                         w_m_27("w_m_27"),w_m_26("w_m_26"),
                         w_m_25("w_m_25"),w_m_24("w_m_24"),
                         w_m_23("w_m_23"),w_m_22("w_m_22"),
                         w_m_21("w_m_21"),w_m_20("w_m_20"),
                         w_m_19("w_m_19"),w_m_18("w_m_18"),
                         w_m_17("w_m_17"),w_m_16("w_m_16"),
                         w_m_15("w_m_15"),w_m_14("w_m_14"),
                         w_m_13("w_m_13"),w_m_12("w_m_12"),
                         w_m_11("w_m_11"),w_m_10("w_m_10"),
                         w_m_9("w_m_9"),w_m_8("w_m_8"),
                         w_m_7("w_m_7"),w_m_6("w_m_6"),
                         w_m_5("w_m_5"),w_m_4("w_m_4"),
                         w_m_3("w_m_3"),w_m_2("w_m_2"),
                         w_m_1("w_m_1"),w_m_0("w_m_0")
  {
    w_m_63.clk(clk);
    w_m_63.din(din_63);
    w_m_63.sel(sel);
    w_m_63.new_reg(new_reg_63);

    w_m_62.clk(clk);
    w_m_62.din(din_62);
    w_m_62.sel(sel);
    w_m_62.new_reg(new_reg_62);

    w_m_61.clk(clk);
    w_m_61.din(din_61);
    w_m_61.sel(sel);
    w_m_61.new_reg(new_reg_61);

    w_m_60.clk(clk);
    w_m_60.din(din_60);
    w_m_60.sel(sel);
    w_m_60.new_reg(new_reg_60);

    w_m_59.clk(clk);
    w_m_59.din(din_59);
    w_m_59.sel(sel);
    w_m_59.new_reg(new_reg_59);

    w_m_58.clk(clk);
    w_m_58.din(din_58);
    w_m_58.sel(sel);
    w_m_58.new_reg(new_reg_58);

    w_m_57.clk(clk);
    w_m_57.din(din_57);
    w_m_57.sel(sel);
    w_m_57.new_reg(new_reg_57);

    w_m_56.clk(clk);
    w_m_56.din(din_56);
    w_m_56.sel(sel);
    w_m_56.new_reg(new_reg_56);

    w_m_55.clk(clk);
    w_m_55.din(din_55);
    w_m_55.sel(sel);
    w_m_55.new_reg(new_reg_55);

    w_m_54.clk(clk);
    w_m_54.din(din_54);
    w_m_54.sel(sel);
    w_m_54.new_reg(new_reg_54);

    w_m_53.clk(clk);
    w_m_53.din(din_53);
    w_m_53.sel(sel);
    w_m_53.new_reg(new_reg_53);

    w_m_52.clk(clk);
    w_m_52.din(din_52);
    w_m_52.sel(sel);
    w_m_52.new_reg(new_reg_52);

    w_m_51.clk(clk);
    w_m_51.din(din_51);
    w_m_51.sel(sel);
    w_m_51.new_reg(new_reg_51);

    w_m_50.clk(clk);
    w_m_50.din(din_50);
    w_m_50.sel(sel);
    w_m_50.new_reg(new_reg_50);

    w_m_49.clk(clk);
    w_m_49.din(din_49);
    w_m_49.sel(sel);
    w_m_49.new_reg(new_reg_49);

    w_m_48.clk(clk);
    w_m_48.din(din_48);
    w_m_48.sel(sel);
    w_m_48.new_reg(new_reg_48);
   
    w_m_47.clk(clk);
    w_m_47.din(din_47);
    w_m_47.sel(sel);
    w_m_47.new_reg(new_reg_47);

    w_m_46.clk(clk);
    w_m_46.din(din_46);
    w_m_46.sel(sel);
    w_m_46.new_reg(new_reg_46);

    w_m_45.clk(clk);
    w_m_45.din(din_45);
    w_m_45.sel(sel);
    w_m_45.new_reg(new_reg_45);

    w_m_44.clk(clk);
    w_m_44.din(din_44);
    w_m_44.sel(sel);
    w_m_44.new_reg(new_reg_44);

    w_m_43.clk(clk);
    w_m_43.din(din_43);
    w_m_43.sel(sel);
    w_m_43.new_reg(new_reg_43);

    w_m_42.clk(clk);
    w_m_42.din(din_42);
    w_m_42.sel(sel);
    w_m_42.new_reg(new_reg_42);

    w_m_41.clk(clk);
    w_m_41.din(din_41);
    w_m_41.sel(sel);
    w_m_41.new_reg(new_reg_41);

    w_m_40.clk(clk);
    w_m_40.din(din_40);
    w_m_40.sel(sel);
    w_m_40.new_reg(new_reg_40);

    w_m_39.clk(clk);
    w_m_39.din(din_39);
    w_m_39.sel(sel);
    w_m_39.new_reg(new_reg_39);

    w_m_38.clk(clk);
    w_m_38.din(din_38);
    w_m_38.sel(sel);
    w_m_38.new_reg(new_reg_38);

    w_m_37.clk(clk);
    w_m_37.din(din_37);
    w_m_37.sel(sel);
    w_m_37.new_reg(new_reg_37);

    w_m_36.clk(clk);
    w_m_36.din(din_36);
    w_m_36.sel(sel);
    w_m_36.new_reg(new_reg_36);

    w_m_35.clk(clk);
    w_m_35.din(din_35);
    w_m_35.sel(sel);
    w_m_35.new_reg(new_reg_35);

    w_m_34.clk(clk);
    w_m_34.din(din_34);
    w_m_34.sel(sel);
    w_m_34.new_reg(new_reg_34);

    w_m_33.clk(clk);
    w_m_33.din(din_33);
    w_m_33.sel(sel);
    w_m_33.new_reg(new_reg_33);

    w_m_32.clk(clk);
    w_m_32.din(din_32);
    w_m_32.sel(sel);
    w_m_32.new_reg(new_reg_32);

    w_m_31.clk(clk);
    w_m_31.din(din_31);
    w_m_31.sel(sel);
    w_m_31.new_reg(new_reg_31);

    w_m_30.clk(clk);
    w_m_30.din(din_30);
    w_m_30.sel(sel);
    w_m_30.new_reg(new_reg_30);

    w_m_29.clk(clk);
    w_m_29.din(din_29);
    w_m_29.sel(sel);
    w_m_29.new_reg(new_reg_29);

    w_m_28.clk(clk);
    w_m_28.din(din_28);
    w_m_28.sel(sel);
    w_m_28.new_reg(new_reg_28);

    w_m_27.clk(clk);
    w_m_27.din(din_27);
    w_m_27.sel(sel);
    w_m_27.new_reg(new_reg_27);

    w_m_26.clk(clk);
    w_m_26.din(din_26);
    w_m_26.sel(sel);
    w_m_26.new_reg(new_reg_26);

    w_m_25.clk(clk);
    w_m_25.din(din_25);
    w_m_25.sel(sel);
    w_m_25.new_reg(new_reg_25);

    w_m_24.clk(clk);
    w_m_24.din(din_24);
    w_m_24.sel(sel);
    w_m_24.new_reg(new_reg_24);

    w_m_23.clk(clk);
    w_m_23.din(din_23);
    w_m_23.sel(sel);
    w_m_23.new_reg(new_reg_23);

    w_m_22.clk(clk);
    w_m_22.din(din_22);
    w_m_22.sel(sel);
    w_m_22.new_reg(new_reg_22);

    w_m_21.clk(clk);
    w_m_21.din(din_21);
    w_m_21.sel(sel);
    w_m_21.new_reg(new_reg_21);

    w_m_20.clk(clk);
    w_m_20.din(din_20);
    w_m_20.sel(sel);
    w_m_20.new_reg(new_reg_20);

    w_m_19.clk(clk);
    w_m_19.din(din_19);
    w_m_19.sel(sel);
    w_m_19.new_reg(new_reg_19);

    w_m_18.clk(clk);
    w_m_18.din(din_18);
    w_m_18.sel(sel);
    w_m_18.new_reg(new_reg_18);

    w_m_17.clk(clk);
    w_m_17.din(din_17);
    w_m_17.sel(sel);
    w_m_17.new_reg(new_reg_17);

    w_m_16.clk(clk);
    w_m_16.din(din_16);
    w_m_16.sel(sel);
    w_m_16.new_reg(new_reg_16);
   
    w_m_15.clk(clk);
    w_m_15.din(din_15);
    w_m_15.sel(sel);
    w_m_15.new_reg(new_reg_15);

    w_m_14.clk(clk);
    w_m_14.din(din_14);
    w_m_14.sel(sel);
    w_m_14.new_reg(new_reg_14);

    w_m_13.clk(clk);
    w_m_13.din(din_13);
    w_m_13.sel(sel);
    w_m_13.new_reg(new_reg_13);

    w_m_12.clk(clk);
    w_m_12.din(din_12);
    w_m_12.sel(sel);
    w_m_12.new_reg(new_reg_12);

    w_m_11.clk(clk);
    w_m_11.din(din_11);
    w_m_11.sel(sel);
    w_m_11.new_reg(new_reg_11);

    w_m_10.clk(clk);
    w_m_10.din(din_10);
    w_m_10.sel(sel);
    w_m_10.new_reg(new_reg_10);

    w_m_9.clk(clk);
    w_m_9.din(din_9);
    w_m_9.sel(sel);
    w_m_9.new_reg(new_reg_9);

    w_m_8.clk(clk);
    w_m_8.din(din_8);
    w_m_8.sel(sel);
    w_m_8.new_reg(new_reg_8);

    w_m_7.clk(clk);
    w_m_7.din(din_7);
    w_m_7.sel(sel);
    w_m_7.new_reg(new_reg_7);

    w_m_6.clk(clk);
    w_m_6.din(din_6);
    w_m_6.sel(sel);
    w_m_6.new_reg(new_reg_6);

    w_m_5.clk(clk);
    w_m_5.din(din_5);
    w_m_5.sel(sel);
    w_m_5.new_reg(new_reg_5);

    w_m_4.clk(clk);
    w_m_4.din(din_4);
    w_m_4.sel(sel);
    w_m_4.new_reg(new_reg_4);

    w_m_3.clk(clk);
    w_m_3.din(din_3);
    w_m_3.sel(sel);
    w_m_3.new_reg(new_reg_3);

    w_m_2.clk(clk);
    w_m_2.din(din_2);
    w_m_2.sel(sel);
    w_m_2.new_reg(new_reg_2);

    w_m_1.clk(clk);
    w_m_1.din(din_1);
    w_m_1.sel(sel);
    w_m_1.new_reg(new_reg_1);

    w_m_0.clk(clk);
    w_m_0.din(din_0);
    w_m_0.sel(sel);
    w_m_0.new_reg(new_reg_0);

  }
  
  ~register64cell(){ }
};

SC_MODULE(register64celldriver)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in< sc_dt::sc_bv<5> > sel;
  sc_core::sc_in< sc_dt::sc_bv<1> > reg_avail;
  sc_core::sc_out< sc_dt::sc_bv<1> > rdy;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_63;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_63;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_62;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_62;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_61;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_61; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_60;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_60;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_59;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_59;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_58;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_58;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_57;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_57;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_56;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_56;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_55;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_55;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_54;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_54;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_53;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_53; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_52;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_52;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_51;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_51;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_50;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_50;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_49;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_49;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_48;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_48;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_47;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_47;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_46;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_46;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_45;
  /*sc_core::sc_signal< sc_dt::sc_bv<4> > din_45;*/
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_45; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_44;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_44;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_43;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_43;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_42;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_42;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_41;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_41;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_40;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_40;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_39;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_39;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_38;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_38;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_37;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_37; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_36;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_36;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_35;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_35;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_34;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_34;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_33;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_33;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_32;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_32;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_31;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_31;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_30;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_30;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_29;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_29; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_28;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_28;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_27;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_27;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_26;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_26;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_25;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_25;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_24;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_24;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_23;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_23;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_22;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_22;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_21;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_21; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_20;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_20;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_19;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_19;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_18;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_18;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_17;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_17;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_16;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_16;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_15;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_15;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_14;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_14;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_13;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_13; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_12;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_12;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_11;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_11;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_10;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_10;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_9;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_9;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_8;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_8;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_7;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_7;
  
  sc_core::sc_in< sc_dt::sc_bv<4> > din_6;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_6;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_5;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_5; 

  sc_core::sc_in< sc_dt::sc_bv<4> > din_4;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_4;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_3;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_3;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_2;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_2;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_1;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_1;

  sc_core::sc_in< sc_dt::sc_bv<4> > din_0;
  sc_core::sc_signal< sc_dt::sc_bv<1> > new_reg_0;
 
  
  sc_dt::sc_bv<64> rdy_bv;
  sc_dt::sc_bv<1> rdy_1_bv;
  sc_dt::sc_bv<1> rdy_2_bv;
  sc_dt::sc_bv<1> reg_avail_bv;
 
  register64cell reg_64_cell;
 
  void register64celldriver_proc0()
  {
    while(1)
    { 
     wait();
     reg_avail_bv = reg_avail.read();
     rdy_bv = (new_reg_63.read(), new_reg_62.read(), new_reg_61.read(), new_reg_60.read(), new_reg_59.read(), new_reg_58.read(), new_reg_57.read(), new_reg_56.read(), new_reg_55.read(), new_reg_54.read(), new_reg_53.read(), new_reg_52.read(), new_reg_51.read(), new_reg_50.read(), new_reg_49.read(), new_reg_48.read(), new_reg_47.read(), new_reg_46.read(), new_reg_45.read(), new_reg_44.read(), new_reg_43.read(), new_reg_42.read(), new_reg_41.read(), new_reg_40.read(), new_reg_39.read(), new_reg_38.read(), new_reg_37.read(), new_reg_36.read(), new_reg_36.read(), new_reg_35.read(), new_reg_34.read(), new_reg_33.read(), new_reg_32.read(), new_reg_31.read(), new_reg_30.read(), new_reg_29.read(), new_reg_28.read(), new_reg_27.read(), new_reg_26.read(), new_reg_25.read(), new_reg_24.read(), new_reg_23.read(), new_reg_22.read(), new_reg_21.read(), new_reg_20.read(), new_reg_19.read(), new_reg_18.read(), new_reg_17.read(), new_reg_16.read(), new_reg_15.read(), new_reg_14.read(), new_reg_13.read(), new_reg_12.read(), new_reg_11.read(), new_reg_10.read(), new_reg_9.read(), new_reg_9.read(), new_reg_7.read(), new_reg_6.read(), new_reg_5.read(), new_reg_4.read(), new_reg_3.read(), new_reg_2.read(), new_reg_1.read(), new_reg_0.read());
     rdy_bv &= statusreg;
     rdy_1_bv = rdy_bv.or_reduce();
     rdy_2_bv = rdy_1_bv[0] == "1" ? "1" : "0";
     rdy_2_bv &= reg_avail_bv;
     rdy.write(rdy_2_bv);
    } 
  }
 
  SC_CTOR(register64celldriver):reg_64_cell("reg_64_cell")
  {
    reg_64_cell.clk(clk);
    reg_64_cell.din_63(din_63);
    reg_64_cell.din_62(din_62);
    reg_64_cell.din_61(din_61);
    reg_64_cell.din_60(din_60);
    reg_64_cell.din_59(din_59);
    reg_64_cell.din_58(din_58);
    reg_64_cell.din_57(din_57);
    reg_64_cell.din_56(din_56);
    reg_64_cell.din_55(din_55);
    reg_64_cell.din_54(din_54);
    reg_64_cell.din_53(din_53);
    reg_64_cell.din_52(din_52);
    reg_64_cell.din_51(din_51);
    reg_64_cell.din_50(din_50);
    reg_64_cell.din_49(din_49);
    reg_64_cell.din_48(din_48);
    reg_64_cell.din_47(din_47);
    reg_64_cell.din_46(din_46);
    reg_64_cell.din_45(din_45);
    reg_64_cell.din_44(din_44);
    reg_64_cell.din_43(din_43);
    reg_64_cell.din_42(din_42);
    reg_64_cell.din_41(din_41);
    reg_64_cell.din_40(din_40);
    reg_64_cell.din_39(din_39);
    reg_64_cell.din_38(din_38);
    reg_64_cell.din_37(din_37);
    reg_64_cell.din_36(din_36);
    reg_64_cell.din_35(din_35);
    reg_64_cell.din_34(din_34);
    reg_64_cell.din_33(din_33);
    reg_64_cell.din_32(din_32);
    reg_64_cell.din_31(din_31);
    reg_64_cell.din_30(din_30);
    reg_64_cell.din_29(din_29);
    reg_64_cell.din_28(din_28);
    reg_64_cell.din_27(din_27);
    reg_64_cell.din_26(din_26);
    reg_64_cell.din_25(din_25);
    reg_64_cell.din_24(din_24);
    reg_64_cell.din_23(din_23);
    reg_64_cell.din_22(din_22);
    reg_64_cell.din_21(din_21);
    reg_64_cell.din_20(din_20);
    reg_64_cell.din_19(din_19);
    reg_64_cell.din_18(din_18);
    reg_64_cell.din_17(din_17);
    reg_64_cell.din_16(din_16);
    reg_64_cell.din_15(din_15);
    reg_64_cell.din_14(din_14);
    reg_64_cell.din_13(din_13);
    reg_64_cell.din_12(din_12);
    reg_64_cell.din_11(din_11);
    reg_64_cell.din_10(din_10);
    reg_64_cell.din_9(din_9);
    reg_64_cell.din_8(din_8);
    reg_64_cell.din_7(din_7);
    reg_64_cell.din_6(din_6);
    reg_64_cell.din_5(din_5);
    reg_64_cell.din_4(din_4);
    reg_64_cell.din_3(din_3);
    reg_64_cell.din_2(din_2);
    reg_64_cell.din_1(din_1);
    reg_64_cell.din_0(din_0);

    reg_64_cell.sel(sel);
   
    reg_64_cell.new_reg_63(new_reg_63);
    reg_64_cell.new_reg_62(new_reg_62);
    reg_64_cell.new_reg_61(new_reg_61);
    reg_64_cell.new_reg_60(new_reg_60);
    reg_64_cell.new_reg_59(new_reg_59);
    reg_64_cell.new_reg_58(new_reg_58);
    reg_64_cell.new_reg_57(new_reg_57);
    reg_64_cell.new_reg_56(new_reg_56);
    reg_64_cell.new_reg_55(new_reg_55);
    reg_64_cell.new_reg_54(new_reg_54);
    reg_64_cell.new_reg_53(new_reg_53);
    reg_64_cell.new_reg_52(new_reg_52);
    reg_64_cell.new_reg_51(new_reg_51);
    reg_64_cell.new_reg_50(new_reg_50);
    reg_64_cell.new_reg_49(new_reg_49);
    reg_64_cell.new_reg_48(new_reg_48);
    reg_64_cell.new_reg_47(new_reg_47);
    reg_64_cell.new_reg_46(new_reg_46);
    reg_64_cell.new_reg_45(new_reg_45);
    reg_64_cell.new_reg_44(new_reg_44);
    reg_64_cell.new_reg_43(new_reg_43);
    reg_64_cell.new_reg_42(new_reg_42);
    reg_64_cell.new_reg_41(new_reg_41);
    reg_64_cell.new_reg_40(new_reg_40);
    reg_64_cell.new_reg_39(new_reg_39);
    reg_64_cell.new_reg_38(new_reg_38);
    reg_64_cell.new_reg_37(new_reg_37);
    reg_64_cell.new_reg_36(new_reg_36);
    reg_64_cell.new_reg_35(new_reg_35);
    reg_64_cell.new_reg_34(new_reg_34);
    reg_64_cell.new_reg_33(new_reg_33);
    reg_64_cell.new_reg_32(new_reg_32);
    reg_64_cell.new_reg_31(new_reg_31);
    reg_64_cell.new_reg_30(new_reg_30);
    reg_64_cell.new_reg_29(new_reg_29);
    reg_64_cell.new_reg_28(new_reg_28);
    reg_64_cell.new_reg_27(new_reg_27);
    reg_64_cell.new_reg_26(new_reg_26);
    reg_64_cell.new_reg_25(new_reg_25);
    reg_64_cell.new_reg_24(new_reg_24);
    reg_64_cell.new_reg_23(new_reg_23);
    reg_64_cell.new_reg_22(new_reg_22);
    reg_64_cell.new_reg_21(new_reg_21);
    reg_64_cell.new_reg_20(new_reg_20);
    reg_64_cell.new_reg_19(new_reg_19);
    reg_64_cell.new_reg_18(new_reg_18);
    reg_64_cell.new_reg_17(new_reg_17);
    reg_64_cell.new_reg_16(new_reg_16);
    reg_64_cell.new_reg_15(new_reg_15);
    reg_64_cell.new_reg_14(new_reg_14);
    reg_64_cell.new_reg_13(new_reg_13);
    reg_64_cell.new_reg_12(new_reg_12);
    reg_64_cell.new_reg_11(new_reg_11);
    reg_64_cell.new_reg_10(new_reg_10);
    reg_64_cell.new_reg_9(new_reg_9);
    reg_64_cell.new_reg_8(new_reg_8);
    reg_64_cell.new_reg_7(new_reg_7);
    reg_64_cell.new_reg_6(new_reg_6);
    reg_64_cell.new_reg_5(new_reg_5);
    reg_64_cell.new_reg_4(new_reg_4);
    reg_64_cell.new_reg_3(new_reg_3);
    reg_64_cell.new_reg_2(new_reg_2);
    reg_64_cell.new_reg_1(new_reg_1);
    reg_64_cell.new_reg_0(new_reg_0);
    SC_THREAD(register64celldriver_proc0);
    sensitive << sel << din_0 << din_1 << din_2 << din_3 << din_4 << din_5 << din_6 << din_7 << din_8 << din_9 << din_10 << din_11 << din_12 << din_13 << din_14 << din_15 << din_16 << din_17 << din_18 << din_19 << din_20 << din_21 << din_22 << din_23 << din_24 << din_25 << din_26 << din_27 << din_28 << din_29 << din_30 << din_31 << din_32 << din_33 << din_34 << din_35 << din_36 << din_37 << din_38 << din_39 << din_40 << din_41 << din_42 << din_43 << din_44 << din_45 << din_46 << din_47 << din_48 << din_49 << din_50 << din_51 << din_52 << din_53 << din_54 << din_55 << din_56 << din_57 << din_58 << din_59 << din_60 << din_61 << din_62 << din_63 << clk.pos() << clk.neg();
  }
  
  ~register64celldriver() { }
};

SC_MODULE(splitter)
{
  sc_core::sc_in< sc_dt::sc_bv<64> > in0;
  sc_core::sc_in< sc_dt::sc_bv<64> > in1;
  sc_core::sc_in< sc_dt::sc_bv<64> > in2;
  sc_core::sc_in< sc_dt::sc_bv<64> > in3;

  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out0;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out1;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out2;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out3;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out4;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out5;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out6;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out7;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out8;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out9;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out10;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out11;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out12;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out13;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out14;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out15;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out16;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out17;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out18;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out19;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out20;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out21;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out22;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out23;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out24;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out25;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out26;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out27;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out28;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out29;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out30;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out31;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out32;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out33;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out34;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out35;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out36;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out37;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out38;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out39;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out40;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out41;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out42;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out43;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out44;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out45;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out46;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out47;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out48;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out49;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out50;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out51;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out52;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out53;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out54;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out55;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out56;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out57;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out58;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out59;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out60;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out61;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out62;
  sc_core::sc_out< sc_dt::sc_bv<4> > bit4out63;

  sc_dt::sc_bv<64> in0_bv;
  sc_dt::sc_bv<64> in1_bv;
  sc_dt::sc_bv<64> in2_bv;
  sc_dt::sc_bv<64> in3_bv;
  
  sc_dt::sc_bv<4> bit4out0_bv;
  sc_dt::sc_bv<4> bit4out1_bv;
  sc_dt::sc_bv<4> bit4out2_bv;
  sc_dt::sc_bv<4> bit4out3_bv;
  sc_dt::sc_bv<4> bit4out4_bv;
  sc_dt::sc_bv<4> bit4out5_bv;
  sc_dt::sc_bv<4> bit4out6_bv;
  sc_dt::sc_bv<4> bit4out7_bv;
  sc_dt::sc_bv<4> bit4out8_bv;
  sc_dt::sc_bv<4> bit4out9_bv;
  sc_dt::sc_bv<4> bit4out10_bv;
  sc_dt::sc_bv<4> bit4out11_bv;
  sc_dt::sc_bv<4> bit4out12_bv;
  sc_dt::sc_bv<4> bit4out13_bv;
  sc_dt::sc_bv<4> bit4out14_bv;
  sc_dt::sc_bv<4> bit4out15_bv;
  sc_dt::sc_bv<4> bit4out16_bv;
  sc_dt::sc_bv<4> bit4out17_bv;
  sc_dt::sc_bv<4> bit4out18_bv;
  sc_dt::sc_bv<4> bit4out19_bv;
  sc_dt::sc_bv<4> bit4out20_bv;
  sc_dt::sc_bv<4> bit4out21_bv;
  sc_dt::sc_bv<4> bit4out22_bv;
  sc_dt::sc_bv<4> bit4out23_bv;
  sc_dt::sc_bv<4> bit4out24_bv;
  sc_dt::sc_bv<4> bit4out25_bv;
  sc_dt::sc_bv<4> bit4out26_bv;
  sc_dt::sc_bv<4> bit4out27_bv;
  sc_dt::sc_bv<4> bit4out28_bv;
  sc_dt::sc_bv<4> bit4out29_bv;
  sc_dt::sc_bv<4> bit4out30_bv;
  sc_dt::sc_bv<4> bit4out31_bv;
  sc_dt::sc_bv<4> bit4out32_bv;
  sc_dt::sc_bv<4> bit4out33_bv;
  sc_dt::sc_bv<4> bit4out34_bv;
  sc_dt::sc_bv<4> bit4out35_bv;
  sc_dt::sc_bv<4> bit4out36_bv;
  sc_dt::sc_bv<4> bit4out37_bv;
  sc_dt::sc_bv<4> bit4out38_bv;
  sc_dt::sc_bv<4> bit4out39_bv;
  sc_dt::sc_bv<4> bit4out40_bv;
  sc_dt::sc_bv<4> bit4out41_bv;
  sc_dt::sc_bv<4> bit4out42_bv;
  sc_dt::sc_bv<4> bit4out43_bv;
  sc_dt::sc_bv<4> bit4out44_bv;
  sc_dt::sc_bv<4> bit4out45_bv;
  sc_dt::sc_bv<4> bit4out46_bv;
  sc_dt::sc_bv<4> bit4out47_bv;
  sc_dt::sc_bv<4> bit4out48_bv;
  sc_dt::sc_bv<4> bit4out49_bv;
  sc_dt::sc_bv<4> bit4out50_bv;
  sc_dt::sc_bv<4> bit4out51_bv;
  sc_dt::sc_bv<4> bit4out52_bv;
  sc_dt::sc_bv<4> bit4out53_bv;
  sc_dt::sc_bv<4> bit4out54_bv;
  sc_dt::sc_bv<4> bit4out55_bv;
  sc_dt::sc_bv<4> bit4out56_bv;
  sc_dt::sc_bv<4> bit4out57_bv;
  sc_dt::sc_bv<4> bit4out58_bv;
  sc_dt::sc_bv<4> bit4out59_bv;
  sc_dt::sc_bv<4> bit4out60_bv;
  sc_dt::sc_bv<4> bit4out61_bv;
  sc_dt::sc_bv<4> bit4out62_bv;
  sc_dt::sc_bv<4> bit4out63_bv;

  void splitter_proc0()
  {
    while(1)
    { 
      wait(); 
      in0_bv = in0.read();
      in1_bv = in1.read();
      in2_bv = in2.read();
      in3_bv = in3.read();

      bit4out63_bv.range(3,3) = in3_bv.range(63,63);
      bit4out63_bv.range(2,2) = in2_bv.range(63,63);
      bit4out63_bv.range(1,1) = in1_bv.range(63,63);
      bit4out63_bv.range(0,0) = in0_bv.range(63,63);

      bit4out62_bv.range(3,3) = in3_bv.range(62,62);
      bit4out62_bv.range(2,2) = in2_bv.range(62,62);
      bit4out62_bv.range(1,1) = in1_bv.range(62,62);
      bit4out62_bv.range(0,0) = in0_bv.range(62,62);
    
      bit4out61_bv.range(3,3) = in3_bv.range(61,61);
      bit4out61_bv.range(2,2) = in2_bv.range(61,61);
      bit4out61_bv.range(1,1) = in1_bv.range(61,61);
      bit4out61_bv.range(0,0) = in0_bv.range(61,61);
    
      bit4out60_bv.range(3,3) = in3_bv.range(60,60);
      bit4out60_bv.range(2,2) = in2_bv.range(60,60);
      bit4out60_bv.range(1,1) = in1_bv.range(60,60);
      bit4out60_bv.range(0,0) = in0_bv.range(60,60);

      bit4out59_bv.range(3,3) = in3_bv.range(59,59);
      bit4out59_bv.range(2,2) = in2_bv.range(59,59);
      bit4out59_bv.range(1,1) = in1_bv.range(59,59);
      bit4out59_bv.range(0,0) = in0_bv.range(59,59);

      bit4out58_bv.range(3,3) = in3_bv.range(58,58);
      bit4out58_bv.range(2,2) = in2_bv.range(58,58);
      bit4out58_bv.range(1,1) = in1_bv.range(58,58);
      bit4out58_bv.range(0,0) = in0_bv.range(58,58);

      bit4out57_bv.range(3,3) = in3_bv.range(57,57);
      bit4out57_bv.range(2,2) = in2_bv.range(57,57);
      bit4out57_bv.range(1,1) = in1_bv.range(57,57);
      bit4out57_bv.range(0,0) = in0_bv.range(57,57);

      bit4out56_bv.range(3,3) = in3_bv.range(56,56);
      bit4out56_bv.range(2,2) = in2_bv.range(56,56);
      bit4out56_bv.range(1,1) = in1_bv.range(56,56);
      bit4out56_bv.range(0,0) = in0_bv.range(56,56);

      bit4out55_bv.range(3,3) = in3_bv.range(55,55);
      bit4out55_bv.range(2,2) = in2_bv.range(55,55);
      bit4out55_bv.range(1,1) = in1_bv.range(55,55);
      bit4out55_bv.range(0,0) = in0_bv.range(55,55);

      bit4out54_bv.range(3,3) = in3_bv.range(54,54);
      bit4out54_bv.range(2,2) = in2_bv.range(54,54);
      bit4out54_bv.range(1,1) = in1_bv.range(54,54);
      bit4out54_bv.range(0,0) = in0_bv.range(54,54);

      bit4out53_bv.range(3,3) = in3_bv.range(53,53);
      bit4out53_bv.range(2,2) = in2_bv.range(53,53);
      bit4out53_bv.range(1,1) = in1_bv.range(53,53);
      bit4out53_bv.range(0,0) = in0_bv.range(53,53);
   
      bit4out52_bv.range(3,3) = in3_bv.range(52,52);
      bit4out52_bv.range(2,2) = in2_bv.range(52,52);
      bit4out52_bv.range(1,1) = in1_bv.range(52,52);
      bit4out52_bv.range(0,0) = in0_bv.range(52,52);

      bit4out51_bv.range(3,3) = in3_bv.range(51,51);
      bit4out51_bv.range(2,2) = in2_bv.range(51,51);
      bit4out51_bv.range(1,1) = in1_bv.range(51,51);
      bit4out51_bv.range(0,0) = in0_bv.range(51,51);

      bit4out50_bv.range(3,3) = in3_bv.range(50,50);
      bit4out50_bv.range(2,2) = in2_bv.range(50,50);
      bit4out50_bv.range(1,1) = in1_bv.range(50,50);
      bit4out50_bv.range(0,0) = in0_bv.range(50,50);

      bit4out49_bv.range(3,3) = in3_bv.range(49,49);
      bit4out49_bv.range(2,2) = in2_bv.range(49,49);
      bit4out49_bv.range(1,1) = in1_bv.range(49,49);
      bit4out49_bv.range(0,0) = in0_bv.range(49,49);

      bit4out48_bv.range(3,3) = in3_bv.range(48,48);
      bit4out48_bv.range(2,2) = in2_bv.range(48,48);
      bit4out48_bv.range(1,1) = in1_bv.range(48,48);
      bit4out48_bv.range(0,0) = in0_bv.range(48,48);

      bit4out47_bv.range(3,3) = in3_bv.range(47,47);
      bit4out47_bv.range(2,2) = in2_bv.range(47,47);
      bit4out47_bv.range(1,1) = in1_bv.range(47,47);
      bit4out47_bv.range(0,0) = in0_bv.range(47,47);

      bit4out46_bv.range(3,3) = in3_bv.range(46,46);
      bit4out46_bv.range(2,2) = in2_bv.range(46,46);
      bit4out46_bv.range(1,1) = in1_bv.range(46,46);
      bit4out46_bv.range(0,0) = in0_bv.range(46,46);

      bit4out45_bv.range(3,3) = in3_bv.range(45,45);
      bit4out45_bv.range(2,2) = in2_bv.range(45,45);
      bit4out45_bv.range(1,1) = in1_bv.range(45,45);
      bit4out45_bv.range(0,0) = in0_bv.range(45,45);

      bit4out44_bv.range(3,3) = in3_bv.range(44,44);
      bit4out44_bv.range(2,2) = in2_bv.range(44,44);
      bit4out44_bv.range(1,1) = in1_bv.range(44,44);
      bit4out44_bv.range(0,0) = in0_bv.range(44,44);

      bit4out43_bv.range(3,3) = in3_bv.range(43,43);
      bit4out43_bv.range(2,2) = in2_bv.range(43,43);
      bit4out43_bv.range(1,1) = in1_bv.range(43,43);
      bit4out43_bv.range(0,0) = in0_bv.range(43,43);
   
      bit4out42_bv.range(3,3) = in3_bv.range(42,42);
      bit4out42_bv.range(2,2) = in2_bv.range(42,42);
      bit4out42_bv.range(1,1) = in1_bv.range(42,42);
      bit4out42_bv.range(0,0) = in0_bv.range(42,42);

      bit4out41_bv.range(3,3) = in3_bv.range(41,41);
      bit4out41_bv.range(2,2) = in2_bv.range(41,41);
      bit4out41_bv.range(1,1) = in1_bv.range(41,41);
      bit4out41_bv.range(0,0) = in0_bv.range(41,41);

      bit4out40_bv.range(3,3) = in3_bv.range(40,40);
      bit4out40_bv.range(2,2) = in2_bv.range(40,40);
      bit4out40_bv.range(1,1) = in1_bv.range(40,40);
      bit4out40_bv.range(0,0) = in0_bv.range(40,40);
 
      bit4out39_bv.range(3,3) = in3_bv.range(39,39);
      bit4out39_bv.range(2,2) = in2_bv.range(39,39);
      bit4out39_bv.range(1,1) = in1_bv.range(39,39);
      bit4out39_bv.range(0,0) = in0_bv.range(39,39);

      bit4out38_bv.range(3,3) = in3_bv.range(38,38);
      bit4out38_bv.range(2,2) = in2_bv.range(38,38);
      bit4out38_bv.range(1,1) = in1_bv.range(38,38);
      bit4out38_bv.range(0,0) = in0_bv.range(38,38);

      bit4out37_bv.range(3,3) = in3_bv.range(37,37);
      bit4out37_bv.range(2,2) = in2_bv.range(37,37);
      bit4out37_bv.range(1,1) = in1_bv.range(37,37);
      bit4out37_bv.range(0,0) = in0_bv.range(37,37);

      bit4out36_bv.range(3,3) = in3_bv.range(36,36);
      bit4out36_bv.range(2,2) = in2_bv.range(36,36);
      bit4out36_bv.range(1,1) = in1_bv.range(36,36);
      bit4out36_bv.range(0,0) = in0_bv.range(36,36);

      bit4out35_bv.range(3,3) = in3_bv.range(35,35);
      bit4out35_bv.range(2,2) = in2_bv.range(35,35);
      bit4out35_bv.range(1,1) = in1_bv.range(35,35);
      bit4out35_bv.range(0,0) = in0_bv.range(35,35);

      bit4out34_bv.range(3,3) = in3_bv.range(34,34);
      bit4out34_bv.range(2,2) = in2_bv.range(34,34);
      bit4out34_bv.range(1,1) = in1_bv.range(34,34);
      bit4out34_bv.range(0,0) = in0_bv.range(34,34);

      bit4out33_bv.range(3,3) = in3_bv.range(33,33);
      bit4out33_bv.range(2,2) = in2_bv.range(33,33);
      bit4out33_bv.range(1,1) = in1_bv.range(33,33);
      bit4out33_bv.range(0,0) = in0_bv.range(33,33);
   
      bit4out32_bv.range(3,3) = in3_bv.range(32,32);
      bit4out32_bv.range(2,2) = in2_bv.range(32,32);
      bit4out32_bv.range(1,1) = in1_bv.range(32,32);
      bit4out32_bv.range(0,0) = in0_bv.range(32,32);

      bit4out31_bv.range(3,3) = in3_bv.range(31,31);
      bit4out31_bv.range(2,2) = in2_bv.range(31,31);
      bit4out31_bv.range(1,1) = in1_bv.range(31,31);
      bit4out31_bv.range(0,0) = in0_bv.range(31,31);

      bit4out30_bv.range(3,3) = in3_bv.range(30,30);
      bit4out30_bv.range(2,2) = in2_bv.range(30,30);
      bit4out30_bv.range(1,1) = in1_bv.range(30,30);
      bit4out30_bv.range(0,0) = in0_bv.range(30,30);

      bit4out29_bv.range(3,3) = in3_bv.range(29,29);
      bit4out29_bv.range(2,2) = in2_bv.range(29,29);
      bit4out29_bv.range(1,1) = in1_bv.range(29,29);
      bit4out29_bv.range(0,0) = in0_bv.range(29,29);

      bit4out28_bv.range(3,3) = in3_bv.range(28,28);
      bit4out28_bv.range(2,2) = in2_bv.range(28,28);
      bit4out28_bv.range(1,1) = in1_bv.range(28,28);
      bit4out28_bv.range(0,0) = in0_bv.range(28,28);

      bit4out27_bv.range(3,3) = in3_bv.range(27,27);
      bit4out27_bv.range(2,2) = in2_bv.range(27,27);
      bit4out27_bv.range(1,1) = in1_bv.range(27,27);
      bit4out27_bv.range(0,0) = in0_bv.range(27,27);

      bit4out26_bv.range(3,3) = in3_bv.range(26,26);
      bit4out26_bv.range(2,2) = in2_bv.range(26,26);
      bit4out26_bv.range(1,1) = in1_bv.range(26,26);
      bit4out26_bv.range(0,0) = in0_bv.range(26,26);

      bit4out25_bv.range(3,3) = in3_bv.range(25,25);
      bit4out25_bv.range(2,2) = in2_bv.range(25,25);
      bit4out25_bv.range(1,1) = in1_bv.range(25,25);
      bit4out25_bv.range(0,0) = in0_bv.range(25,25);

      bit4out24_bv.range(3,3) = in3_bv.range(24,24);
      bit4out24_bv.range(2,2) = in2_bv.range(24,24);
      bit4out24_bv.range(1,1) = in1_bv.range(24,24);
      bit4out24_bv.range(0,0) = in0_bv.range(24,24);

      bit4out23_bv.range(3,3) = in3_bv.range(23,23);
      bit4out23_bv.range(2,2) = in2_bv.range(23,23);
      bit4out23_bv.range(1,1) = in1_bv.range(23,23);
      bit4out23_bv.range(0,0) = in0_bv.range(23,23);
   
      bit4out22_bv.range(3,3) = in3_bv.range(22,22);
      bit4out22_bv.range(2,2) = in2_bv.range(22,22);
      bit4out22_bv.range(1,1) = in1_bv.range(22,22);
      bit4out22_bv.range(0,0) = in0_bv.range(22,22);

      bit4out21_bv.range(3,3) = in3_bv.range(21,21);
      bit4out21_bv.range(2,2) = in2_bv.range(21,21);
      bit4out21_bv.range(1,1) = in1_bv.range(21,21);
      bit4out21_bv.range(0,0) = in0_bv.range(21,21);

      bit4out20_bv.range(3,3) = in3_bv.range(20,20);
      bit4out20_bv.range(2,2) = in2_bv.range(20,20);
      bit4out20_bv.range(1,1) = in1_bv.range(20,20);
      bit4out20_bv.range(0,0) = in0_bv.range(20,20);

      bit4out19_bv.range(3,3) = in3_bv.range(19,19);
      bit4out19_bv.range(2,2) = in2_bv.range(19,19);
      bit4out19_bv.range(1,1) = in1_bv.range(19,19);
      bit4out19_bv.range(0,0) = in0_bv.range(19,19);

      bit4out18_bv.range(3,3) = in3_bv.range(18,18);
      bit4out18_bv.range(2,2) = in2_bv.range(18,18);
      bit4out18_bv.range(1,1) = in1_bv.range(18,18);
      bit4out18_bv.range(0,0) = in0_bv.range(18,18);

      bit4out17_bv.range(3,3) = in3_bv.range(17,17);
      bit4out17_bv.range(2,2) = in2_bv.range(17,17);
      bit4out17_bv.range(1,1) = in1_bv.range(17,17);
      bit4out17_bv.range(0,0) = in0_bv.range(17,17);

      bit4out16_bv.range(3,3) = in3_bv.range(16,16);
      bit4out16_bv.range(2,2) = in2_bv.range(16,16);
      bit4out16_bv.range(1,1) = in1_bv.range(16,16);
      bit4out16_bv.range(0,0) = in0_bv.range(16,16);

      bit4out15_bv.range(3,3) = in3_bv.range(15,15);
      bit4out15_bv.range(2,2) = in2_bv.range(15,15);
      bit4out15_bv.range(1,1) = in1_bv.range(15,15);
      bit4out15_bv.range(0,0) = in0_bv.range(15,15);

      bit4out14_bv.range(3,3) = in3_bv.range(14,14);
      bit4out14_bv.range(2,2) = in2_bv.range(14,14);
      bit4out14_bv.range(1,1) = in1_bv.range(14,14);
      bit4out14_bv.range(0,0) = in0_bv.range(14,14);

      bit4out13_bv.range(3,3) = in3_bv.range(13,13);
      bit4out13_bv.range(2,2) = in2_bv.range(13,13);
      bit4out13_bv.range(1,1) = in1_bv.range(13,13);
      bit4out13_bv.range(0,0) = in0_bv.range(13,13);
   
      bit4out12_bv.range(3,3) = in3_bv.range(12,12);
      bit4out12_bv.range(2,2) = in2_bv.range(12,12);
      bit4out12_bv.range(1,1) = in1_bv.range(12,12);
      bit4out12_bv.range(0,0) = in0_bv.range(12,12);

      bit4out11_bv.range(3,3) = in3_bv.range(11,11);
      bit4out11_bv.range(2,2) = in2_bv.range(11,11);
      bit4out11_bv.range(1,1) = in1_bv.range(11,11);
      bit4out11_bv.range(0,0) = in0_bv.range(11,11);

      bit4out10_bv.range(3,3) = in3_bv.range(10,10);
      bit4out10_bv.range(2,2) = in2_bv.range(10,10);
      bit4out10_bv.range(1,1) = in1_bv.range(10,10);
      bit4out10_bv.range(0,0) = in0_bv.range(10,10);

      bit4out9_bv.range(3,3) = in3_bv.range(9,9);
      bit4out9_bv.range(2,2) = in2_bv.range(9,9);
      bit4out9_bv.range(1,1) = in1_bv.range(9,9);
      bit4out9_bv.range(0,0) = in0_bv.range(9,9);

      bit4out8_bv.range(3,3) = in3_bv.range(8,8);
      bit4out8_bv.range(2,2) = in2_bv.range(8,8);
      bit4out8_bv.range(1,1) = in1_bv.range(8,8);
      bit4out8_bv.range(0,0) = in0_bv.range(8,8);

      bit4out7_bv.range(3,3) = in3_bv.range(7,7);
      bit4out7_bv.range(2,2) = in2_bv.range(7,7);
      bit4out7_bv.range(1,1) = in1_bv.range(7,7);
      bit4out7_bv.range(0,0) = in0_bv.range(7,7);

      bit4out6_bv.range(3,3) = in3_bv.range(6,6);
      bit4out6_bv.range(2,2) = in2_bv.range(6,6);
      bit4out6_bv.range(1,1) = in1_bv.range(6,6);
      bit4out6_bv.range(0,0) = in0_bv.range(6,6);

      bit4out5_bv.range(3,3) = in3_bv.range(5,5);
      bit4out5_bv.range(2,2) = in2_bv.range(5,5);
      bit4out5_bv.range(1,1) = in1_bv.range(5,5);
      bit4out5_bv.range(0,0) = in0_bv.range(5,5);

      bit4out4_bv.range(3,3) = in3_bv.range(4,4);
      bit4out4_bv.range(2,2) = in2_bv.range(4,4);
      bit4out4_bv.range(1,1) = in1_bv.range(4,4);
      bit4out4_bv.range(0,0) = in0_bv.range(4,4);

      bit4out3_bv.range(3,3) = in3_bv.range(3,3);
      bit4out3_bv.range(2,2) = in2_bv.range(3,3);
      bit4out3_bv.range(1,1) = in1_bv.range(3,3);
      bit4out3_bv.range(0,0) = in0_bv.range(3,3);
   
      bit4out2_bv.range(3,3) = in3_bv.range(2,2);
      bit4out2_bv.range(2,2) = in2_bv.range(2,2);
      bit4out2_bv.range(1,1) = in1_bv.range(2,2);
      bit4out2_bv.range(0,0) = in0_bv.range(2,2);

      bit4out1_bv.range(3,3) = in3_bv.range(1,1);
      bit4out1_bv.range(2,2) = in2_bv.range(1,1);
      bit4out1_bv.range(1,1) = in1_bv.range(1,1);
      bit4out1_bv.range(0,0) = in0_bv.range(1,1);

      bit4out0_bv.range(3,3) = in3_bv.range(0,0);
      bit4out0_bv.range(2,2) = in2_bv.range(0,0);
      bit4out0_bv.range(1,1) = in1_bv.range(0,0);
      bit4out0_bv.range(0,0) = in0_bv.range(0,0);
      
      bit4out0.write(bit4out0_bv);
      bit4out1.write(bit4out1_bv);
      bit4out2.write(bit4out2_bv);
      bit4out3.write(bit4out3_bv);
      bit4out4.write(bit4out4_bv);
      bit4out5.write(bit4out5_bv);
      bit4out6.write(bit4out6_bv);
      bit4out7.write(bit4out7_bv);
      bit4out8.write(bit4out8_bv);
      bit4out9.write(bit4out9_bv);
      bit4out10.write(bit4out10_bv);
      bit4out11.write(bit4out11_bv);
      bit4out12.write(bit4out12_bv);
      bit4out13.write(bit4out13_bv);
      bit4out14.write(bit4out14_bv);
      bit4out15.write(bit4out15_bv);
      bit4out16.write(bit4out16_bv);
      bit4out17.write(bit4out17_bv);
      bit4out18.write(bit4out18_bv);
      bit4out19.write(bit4out19_bv);
      bit4out20.write(bit4out20_bv);
      bit4out21.write(bit4out21_bv);
      bit4out22.write(bit4out22_bv);
      bit4out23.write(bit4out23_bv);
      bit4out24.write(bit4out24_bv);
      bit4out25.write(bit4out25_bv);
      bit4out26.write(bit4out26_bv);
      bit4out27.write(bit4out27_bv);
      bit4out28.write(bit4out28_bv);
      bit4out29.write(bit4out29_bv);
      bit4out30.write(bit4out30_bv);
      bit4out31.write(bit4out31_bv);
      bit4out32.write(bit4out32_bv);
      bit4out33.write(bit4out33_bv);
      bit4out34.write(bit4out34_bv);
      bit4out35.write(bit4out35_bv);
      bit4out36.write(bit4out36_bv);
      bit4out37.write(bit4out37_bv);
      bit4out38.write(bit4out38_bv);
      bit4out39.write(bit4out39_bv);
      bit4out40.write(bit4out40_bv);
      bit4out41.write(bit4out41_bv);
      bit4out42.write(bit4out42_bv);
      bit4out43.write(bit4out43_bv);
      bit4out44.write(bit4out44_bv);
      bit4out45.write(bit4out45_bv);
      bit4out46.write(bit4out46_bv);
      bit4out47.write(bit4out47_bv);
      bit4out48.write(bit4out48_bv);
      bit4out49.write(bit4out49_bv);
      bit4out50.write(bit4out50_bv);
      bit4out51.write(bit4out51_bv);
      bit4out52.write(bit4out52_bv);
      bit4out53.write(bit4out53_bv);
      bit4out54.write(bit4out54_bv);
      bit4out55.write(bit4out55_bv);
      bit4out56.write(bit4out56_bv);
      bit4out57.write(bit4out57_bv);
      bit4out58.write(bit4out58_bv);
      bit4out59.write(bit4out59_bv);
      bit4out60.write(bit4out60_bv); 
      bit4out61.write(bit4out61_bv);
      bit4out62.write(bit4out62_bv);
      bit4out63.write(bit4out63_bv);
      std::cout<<bit4out63_bv<<" "<<bit4out62_bv<<" "<<bit4out61_bv<<" "<<bit4out60_bv<<std::endl;
     } 
   }

   SC_CTOR(splitter)
   {
     
     SC_THREAD(splitter_proc0);
     sensitive << in0 << in1 << in2 << in3;
     dont_initialize();
   }

   ~splitter(){ }
};
  
#endif

