#ifndef SIPO_H
#define SIPO_H

#include <systemc>

SC_MODULE(sipo64)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in;
  sc_core::sc_out< sc_dt::sc_bv<64> > out;
  sc_dt::sc_bv<64> data;
  sc_dt::sc_bv<64> idlebits;
  bool b1;
  unsigned int i;
  unsigned int count;

  void shift()
  {
    while(1)
    {
      wait();
      if(count < 64)
      {
        b1 = in.read();
        data.range(count,count) = (b1 == true) ? "1" : "0";
        count = count + 1;
        out.write(idlebits);
      }
      else
      {
        count = 0;
        out.write(data);
        /* Print out the 64 bits collected
           over the last 64 clock ticks */
        std::cout<<"@ "<<sc_core::sc_time_stamp().to_seconds()<<" seconds parallel 64 bit output : "<<std::endl; 
        std::cout<<data<<std::endl; 
        data = "0000000000000000000000000000000000000000000000000000000000000000";
      }  
     }
  }

  SC_CTOR(sipo64):count(0),
  data("0000000000000000000000000000000000000000000000000000000000000000"),
  idlebits("0000000000000000000000000000000000000000000000000000000000000000")
  {
    SC_CTHREAD(shift, clk.pos());
  }

  ~sipo64(){ }
};

#endif

