#ifndef SYSCTRACE_H
#define SYSCTRACE_H

#include <systemc>

SC_MODULE(ssctracesglbool)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> din0;
  std::ofstream outstream;
  bool b0;
  double currtime;

  void ssctracesglbool_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      b0 = din0.read();
      outstream << std::scientific << currtime << "\t " << b0 << std::endl;
    }
  }

  SC_CTOR(ssctracesglbool)
  {
    outstream.open(name(), std::ios::out); 
    SC_THREAD(ssctracesglbool_proc0);
    sensitive << clk;
  }
  
  ~ssctracesglbool() { outstream.close(); }
};

SC_MODULE(ssctracesglshort)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<short> din0;
  std::ofstream outstream;
  short s0;
  double currtime;

  void ssctracesglshort_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      s0 = din0.read();
      outstream << std::scientific << currtime << "\t " << s0 << std::endl;
      }
  }

  SC_CTOR(ssctracesglshort)
  {
    outstream.open(name(), std::ios::out);
    SC_THREAD(ssctracesglshort_proc0);
    sensitive << clk;
  }
  
  ~ssctracesglshort() { outstream.close(); }
};


SC_MODULE(ssctracesglunsignedchar)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<unsigned char> din0;
  std::ofstream outstream;
  unsigned char uc0;
  double currtime;

  void ssctracesglunsignedchar_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      uc0 = din0.read();
      outstream << currtime << "\t " << uc0 << std::endl;
      }
  }

  SC_CTOR(ssctracesglunsignedchar)
  {
    outstream.open(name(), std::ios::out);
    SC_THREAD(ssctracesglunsignedchar_proc0);
    sensitive << clk;
  }

  ~ssctracesglunsignedchar() { outstream.close(); }
};
   
SC_MODULE(ssctracesglunsignedint)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<unsigned int> din0;
  std::ofstream outstream;
  unsigned int ui0;
  double currtime;

  void ssctracesglunsignedint_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      ui0 = din0.read();
      outstream << std::scientific << currtime << "\t " << ui0 << std::endl;
    }
  }

  SC_CTOR(ssctracesglunsignedint)
  {
    outstream.open(name(), std::ios::out); 
    SC_THREAD(ssctracesglunsignedint_proc0);
    sensitive << clk;
  }
  
  ~ssctracesglunsignedint() { outstream.close(); }
};

SC_MODULE(ssctracesixbool)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;

  std::ofstream output;
  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;

  double currtime;

  void ssctracesixbool_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      b0 = in0.read();
      b1 = in1.read();
      b2 = in2.read();
      b3 = in3.read();
      b4 = in4.read();
      b5 = in5.read();
      output << std::scientific << currtime << "\t " << b0 << "\t" << b1 << "\t" << b2 << "\t" << b3 << "\t" << b4 << "\t" << b5 << "\t" << b5 <<std::endl;
    }
  }

  SC_CTOR(ssctracesixbool)
  {
    output.open(name(), std::ios::out);
    SC_THREAD(ssctracesixbool_proc0);
    sensitive << clk.pos();
  }

  ~ssctracesixbool() { output.close(); }
};


SC_MODULE(ssctracedblbool)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> din0;
  sc_core::sc_in<bool> din1;
  std::ofstream output;
  bool b0;
  bool b1;
  double currtime;
 
  void ssctracedblbool_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      b0 = din0.read();
      b1 = din1.read();
      output << std::scientific << currtime << "\t " << b0 << "\t" << b1 << std::endl;
    }
  }

  SC_CTOR(ssctracedblbool)
  {
    output.open(name(), std::ios::out);
    SC_THREAD(ssctracedblbool_proc0);
    sensitive << clk;
  }
  
  ~ssctracedblbool() { output.close(); }
};

SC_MODULE(ssctracedblbool_nc)
{
  sc_core::sc_in<bool> din0;
  sc_core::sc_in<bool> din1;
  std::ofstream output;
  bool b0;
  bool b1;
  double currtime;

  void ssctracedblbool_nc_proc0()
  {
    /*
    while(1)
    {
      wait();
    */
      currtime = sc_core::sc_time_stamp().to_seconds();
      b0 = din0.read();
      b1 = din1.read();
 output << std::scientific << currtime << "," << b0 << "," << b1 << std::endl;
   /*  } */
  }

  SC_CTOR(ssctracedblbool_nc)
  {
    output.open(name(), std::ios::out);
    SC_METHOD(ssctracedblbool_nc_proc0);
    sensitive << din0;
  }

  ~ssctracedblbool_nc() { output.close(); }
};




SC_MODULE(ssctracesgldbl)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<double> din0;
 
  std::ofstream output;
  double currtime;
  double d0;
 

  void ssctracesgldbl_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      d0 = din0.read();
      output << std::scientific << currtime << "\t " << d0 << std::endl;
    }
  }

  SC_CTOR(ssctracesgldbl)
  {
    output.open(name(), std::ios::out);
    SC_THREAD(ssctracesgldbl_proc0);
    sensitive << clk;
  }

  ~ssctracesgldbl() { output.close(); }
};

SC_MODULE(ssctracedbldbl)
{
  sc_core::sc_in<double> din0;
  sc_core::sc_in<double> din1;
 
  std::ofstream output;
  double currtime;
  double d0;
  double d1;
 
  void ssctracedbldbl_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      d0 = din0.read();
      d1 = din1.read();
      output << std::scientific << currtime << "\t " << d0 << "\t" << d1 << std::endl;
    }
  }

  SC_CTOR(ssctracedbldbl)
  {
    output.open(name(), std::ios::out);
    SC_THREAD(ssctracedbldbl_proc0);
    sensitive << din0 << din1;
  }

  ~ssctracedbldbl() { output.close(); }
};


SC_MODULE(ssctracetrdbl)
{
/*  sc_core::sc_in<bool> clk; */
  sc_core::sc_in<double> din0;
  sc_core::sc_in<double> din1;
  sc_core::sc_in<double> din2;
  std::ofstream output;
  double currtime;
  double d0;
  double d1;
  double d2;

  void ssctracetrdbl_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      d0 = din0.read();
      d1 = din1.read();
      d2 = din2.read();
      output << std::scientific << currtime << "\t " << d0 << "\t" << d1 << "\t" << d2 << std::endl;
    }
  }

  SC_CTOR(ssctracetrdbl)
  {
    output.open(name(), std::ios::out);
    SC_THREAD(ssctracetrdbl_proc0);
    /* sensitive << clk; */
    sensitive << din0 << din1 << din2;
  }

  ~ssctracetrdbl() { output.close(); }
};

#endif

      
