#include "test.h"
#include <cstdlib>
#include <cstring>
#include "systemc.h"

/* TEST BENCH SYSTEMC EXAMPLE 5.6 */ 

int sc_main(int argc, char **argv)
{
  /* Bit-vector channels */ 
  sc_core::sc_signal< sc_dt::sc_bv<8> > thermoin;
  sc_core::sc_signal< sc_dt::sc_bv<4> > thermoout;
  sc_core::sc_signal< sc_dt::sc_bv<5> > onehotout;
  /* Local bit vector */
  sc_dt::sc_bv<8> thmin;
  /* Instantiate one counter and 1-hot encoder */
  onecounter one_count("one_count");
  onehot one_hot("one_hot");
  /* Trace file pointer */
  sc_core::sc_trace_file *fp;
  /* Create. Initialize trace file */
  fp = sc_create_vcd_trace_file("tr_thgen_onehot");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  /* Connect module ports and channels */
  one_count.in(thermoin);
  one_count.out(thermoout);
  one_hot.in(thermoout);
  one_hot.out(onehotout);
  /* Connect trace file and data channels */
  sc_trace(fp, thermoin, "thermoin");
  sc_trace(fp, thermoout, "thermoout");
  sc_trace(fp, onehotout, "onehotout");
  /* Generate data and run 1 simulation step */
  thmin = "00000000";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00000001";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00000011";

  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00001110";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00001111";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "01010101";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00101100";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "00111011";
  thermoin.write(thmin);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate data and run 1 simulation step */
  thmin = "10101111";
  thermoin.write(thmin);  sc_start(1.0, sc_core::SC_NS);
  /* Stop simulation and close trace file */
  sc_core::sc_stop();
  sc_close_vcd_trace_file(fp);

  return 0;
}

