#include "n2_cl_u1.h"
#include <cstdlib>
#include <cstring>

/* TEST BENCH SYSTEMC EXAMPLE 5.3 */

int sc_main(int argc, char **argv)
{
   /* Combinational logic – NO clocks */
   /* Input/output channesl */
   sc_core::sc_signal<bool> sigin0;
   sc_core::sc_signal<bool> sigin1;
   sc_core::sc_signal<bool> sigin2;
   sc_core::sc_signal<bool> sigin3;
   sc_core::sc_signal<bool> sigout0;
   sc_core::sc_signal<bool> sigout1;
   /* Trace file pointer */
   sc_core::sc_trace_file *fp;   
  /* Declare/define adder and trace file */
   cl_u1_csa32_16x csa32("csa32_16x");
   fp = sc_create_vcd_trace_file("tr_csa_32");
   fp->set_time_unit(1.0, sc_core::SC_NS);
  
  /* Connect module ports and channels */
   csa32.in0(sigin0);
   csa32.in1(sigin1);
   csa32.in2(sigin2);
   csa32.carry(sigout0);
   csa32.sum(sigout1);
   csa32.LIB = true; /*Set environmanr variable */
  
   /* Connect trace file with channels whose data is to be plotted */
   sc_trace(fp, sigin0, "adder_in_0");
   sc_trace(fp, sigin1, "adder_in_1");
   sc_trace(fp, sigin2, "adder_in_2");
   sc_trace(fp, sigout0, "adder_carry");
   sc_trace(fp, sigout1, "adder_sum");
 
  /* Generate data and run a simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sc_start(1.0,sc_core::SC_NS);
  
  /* Generate data and run a simulation step */
  sigin0.write(true);
  sigin1.write(false);
  sigin2.write(false);
  sc_start(1.0,sc_core::SC_NS);
  
  /* Generate data and run a simulation step */
  sigin0.write(false);
  sigin1.write(true);
  sigin2.write(false);
  sc_start(1.0,sc_core::SC_NS);
   /* Generate data and run a simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(true);
  sc_start(1.0,sc_core::SC_NS);
   
  /* Generate data and run a simulation step */
  sigin0.write(true);
  sigin1.write(false);
  sigin2.write(true);
  sc_start(1.0,sc_core::SC_NS);
  
  /* Generate data and run a simulation step */
  sigin0.write(false);
  sigin1.write(true);
  sigin2.write(true);
  sc_start(1.0,sc_core::SC_NS);
   
  /* Generate data and run a simulation step */
  sigin0.write(true);
  sigin1.write(true);
  sigin2.write(false);
  sc_start(1.0,sc_core::SC_NS);
   
  /* Generate data and run a simulation step */
  sigin0.write(true);
  sigin1.write(true);
  sigin2.write(true);
  sc_start(6.0,sc_core::SC_NS);
  /* Stop simulation, close trace file */
  sc_stop();
  sc_close_vcd_trace_file(fp);
  return 0;
}

