#include "testbv.h"
#include "systemc.h"
#include <cstdlib>
#include <cstring>

/* TEST BENCH SYSTEMC EXAMPLE 5.4 */

int sc_main(int argc, char **argv)
{
  /* Combinational logic – NO clocks */
  /* Input/output channels with bit vectors */
  sc_core::sc_signal< sc_dt::sc_bv<3> > sigin0;
  sc_core::sc_signal< sc_dt::sc_bv<2> > sigout0;
  sc_dt::sc_bv<3> input_vector;
  /*Declare/define adder and VCD trace file, 
    connect input/output ports with channels */ 
  adder3b adder_3b("adder_3b");
  sc_core::sc_trace_file *fp;
  
  adder_3b.input(sigin0);
  adder_3b.output(sigout0);

  fp = sc_create_vcd_trace_file("tr_csa_32_bv");
  fp->set_time_unit(1.0, sc_core::SC_NS);
  sc_trace(fp, sigin0, "adder_in");
  sc_trace(fp, sigout0, "adder_carry_sum");

  /* Generate new input and run single simulation step */
  input_vector = "000";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "100";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "010";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
   /* Generate new input and run single simulation step */
  input_vector = "001";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "110";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "011";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "101";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Generate new input and run single simulation step */
  input_vector = "111";
  sigin0.write(input_vector);
  sc_core::sc_start(1.0, sc_core::SC_NS);
  /* Stop simulatiom and close trace file */
  sc_core::sc_stop();
  sc_close_vcd_trace_file(fp);  
  return 0;
}

