#include "barrelshift.h"

/* TEST BENCH SYSTEMC EXAMPLE 5.7 */

int sc_main(int argc, char **argv)
{
  /* Declare/define channels/signals */
  sc_core::sc_signal< sc_dt::sc_bv<MAX> > sig0;
  sc_core::sc_signal< sc_dt::sc_bv<MAX> > sig1;
  sc_core::sc_signal< sc_dt::sc_bv<MAX> > sig2;
  sc_core::sc_signal<bool> sig3;

  /* Declare/define local data members */
  sc_dt::sc_bv<MAX> datain;
  sc_dt::sc_bv<MAX> shiftlen;
  /* sc_dt::sc_bv<MAX> dataout; */

  /* Member to control shift direction */
  bool shiftright;
  barrelshift bs("bs");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_barrel_shift");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  /* Connect module ports and channels */
  bs.din0(sig0);
  bs.din1(sig1);
  bs.shiftright(sig3);
  bs.dout(sig2);

  /* Connect trace file and signals */
  sc_core::sc_trace(fp, sig0, "data_in");
  sc_core::sc_trace(fp, sig1, "shift_len");
  sc_core::sc_trace(fp, sig2, "data_out");
  sc_core::sc_trace(fp, sig3, "shift_right");

  /* Generate new data and insert into channels */
  datain = "00100000000000000000000000000000";
  shiftlen = "0000000000000000000000000000010";
  shiftright = true;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;
 
  /* Generate new data and insert into channels */
  datain = "10101010010101010011001111001100";
  shiftlen = "0000000000000000000000000000001";
  shiftright = true;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;
  
  /* Generate new data and insert into channels */
  datain = "00111011010101011111001111001100";  
  shiftlen = "0000000000000000000000000000100";
  shiftright = false;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;
 
  /* Generate new data and insert into channels */
  datain = "10101010010101010011001111001111";
  shiftlen = "0000000000000000000000000000101";
  shiftright = false;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;

  /* Generate new data and insert into channels */
  datain = "10101010010101010011000000001111";
  shiftlen = "000000000000000000000000000011";
  shiftright = true;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;

  /* Generate new data and insert into channels */
  datain = "10101010010101010011000000001111";
  shiftlen = "000000000000000000000000000010";
  shiftright = true;
  sig0.write(datain);
  sig1.write(shiftlen);
  sig3.write(shiftright);
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<"shift length "<<shiftlen.to_int()<<std::endl;
  std::cout<<"shift right "<<shiftright<<std::endl;
  std::cout<<"Data in "<<datain<<std::endl;
  std::cout<<"Data out "<<sig2.read()<<std::endl;

  /* Stop simulation and close trace file */
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp); 
  return 0;
}

