#include "bilbo.h"
#include "systemc.h"

int sc_main(int argc, char **argv)
{
 
  sc_core::sc_signal<bool> shftinsig;
  sc_core::sc_signal<bool> c1sig;
  sc_core::sc_signal<bool> c2sig;
  sc_core::sc_signal<bool> c3sig;
  sc_core::sc_signal<bool> t1sig;
  sc_core::sc_signal<bool> t2sig;
  sc_core::sc_signal<bool> t3sig;
  sc_core::sc_signal<bool> t4sig;
  sc_core::sc_signal<bool> outsig;

  bool shftinval;
  bool c1val;
  bool c2val;
  bool c3val;
  bool t1val;
  bool t2val;
  bool t3val;
  bool t4val;
  
  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);

  bilbo bil_bo("bil_bo");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_bilbo");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  bil_bo.clk(clk);
  bil_bo.shftin(shftinsig);
  bil_bo.c1(c1sig);
  bil_bo.c2(c2sig);
  bil_bo.c3(c3sig);
  bil_bo.t1(t1sig);
  bil_bo.t2(t2sig);
  bil_bo.t3(t3sig);
  bil_bo.t4(t4sig);
  bil_bo.shftout(outsig);

  sc_core::sc_trace(fp, clk, "clk");
  sc_core::sc_trace(fp, shftinsig, "shiftin");
  sc_core::sc_trace(fp, c1sig, "c1");
  sc_core::sc_trace(fp, c2sig, "c2");
  sc_core::sc_trace(fp, c3sig, "c3");
  sc_core::sc_trace(fp, t1sig, "t1");
  sc_core::sc_trace(fp, t2sig, "t2");
  sc_core::sc_trace(fp, t3sig, "t3");
  sc_core::sc_trace(fp, t4sig, "t4");
  sc_core::sc_trace(fp, outsig, "out");


  shftinval = false;
  c1val = false;
  c2val = false;
  c3val = false;
  t1val = false;
  t2val = false;
  t3val = false;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);

  shftinval = true;
  c1val = true;
  c2val = false;
  c3val = true;
  t1val = true;
  t2val = false;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);
  
  shftinval = false;
  c1val = false;
  c2val = true;
  c3val = false;
  t1val = false;
  t2val = true;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);
 
  shftinval = true;
  c1val = true;
  c2val = true;
  c3val = true;
  t1val = false;
  t2val = true;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);

  shftinval = false;
  c1val = true;
  c2val = true;
  c3val = false;
  t1val = false;
  t2val = true;
  t3val = true;
  t4val = true;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);

  shftinval = true;
  c1val = false;
  c2val = false;
  c3val = true;
  t1val = false;
  t2val = true;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);

  shftinval = false;
  c1val = false;
  c2val = true;
  c3val = true;
  t1val = false;
  t2val = false;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);

  shftinval = true;
  c1val = true;
  c2val = true;
  c3val = true;
  t1val = false;
  t2val = false;
  t3val = true;
  t4val = false;

  shftinsig.write(shftinval);
  c1sig.write(c1val);
  c2sig.write(c2val);
  c3sig.write(c3val);
  t1sig.write(t1val);
  t2sig.write(t2val);
  t3sig.write(t3val);
  t4sig.write(t4val);

  sc_core::sc_start(10.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);

  return 0;
}

