#include "commonsrcs.h"
#include "cdreader.h"
#include "gendatatrace.h"

#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  if(argc < 5)
  {
    std::cout<<"insufficient parameters ..."<<std::endl;
    std::cout<<"usage ./sim <resistivity> <length> <width> <thickness>"<<std::endl;
    exit(0);
  }
 
  sca_tdf::sca_signal<double> rawdata;
  sca_tdf::sca_signal<double> psdout0;
  sca_tdf::sca_signal<double> psdout1;
  sca_tdf::sca_signal<double> ampout;
  double resistivity;
  double length;
  double width;
  double thickness;

  resistivity = strtod(argv[1], NULL);
  length = strtod(argv[2], NULL);
  width = strtod(argv[3], NULL);
  thickness = strtod(argv[4], NULL);

  randata ran_data("ran_data");
  psd ps_d("ps_d");
  ps_d.resistivity = resistivity;
  ps_d.L = length;
  ps_d.W = width;
  ps_d.thickness = thickness;
  instamplifier inst_amp("inst_amp");
  tracetriplecombo trpll("tr_cd_reader");

  ran_data.randatasigout(rawdata);
  ps_d.inlightpos(rawdata);
  ps_d.voltage1(psdout0);
  ps_d.voltage2(psdout1);
  inst_amp.inp0(psdout0);
  inst_amp.inp1(psdout1);
  inst_amp.outp(ampout);
  trpll.in1(psdout0);
  trpll.in2(psdout1);
  trpll.in3(ampout);

  sc_start(500.0, sc_core::SC_US);
  return 0;
}
    
    
       
