#include "n2_cl_a1.h"
#include <cstdlib>
#include <cstring>

/* TEST BENCH SYSTEMC EXAMPLE 5.5 - BIT ONLY IO */

int sc_main(int argc, char **argv)
{
  /* Eight channels for multiplexer input bit */
  sc_core::sc_signal<bool> sigin0;
  sc_core::sc_signal<bool> sigin1;
  sc_core::sc_signal<bool> sigin2;
  sc_core::sc_signal<bool> sigin3;
  sc_core::sc_signal<bool> sigin4;
  sc_core::sc_signal<bool> sigin5;
  sc_core::sc_signal<bool> sigin6;
  sc_core::sc_signal<bool> sigin7;
  /* Eight channels for multiplexer select lines */
  sc_core::sc_signal<bool> sel0;
  sc_core::sc_signal<bool> sel1;
  sc_core::sc_signal<bool> sel2;
  sc_core::sc_signal<bool> sel3;
  sc_core::sc_signal<bool> sel4;
  sc_core::sc_signal<bool> sel5;
  sc_core::sc_signal<bool> sel6;
  sc_core::sc_signal<bool> sel7;
  /* Multiplexer output channel */
  sc_core::sc_signal<bool> sigout0;
  /* Trace file pointer for VCD format output */
  sc_core::sc_trace_file *fp;
  /* Instantiate multiplexer, trace */
  cl_a1_aomux8_12x mux8("mux_8");
  fp = sc_create_vcd_trace_file("tr_mux_8");

  fp->set_time_unit(1.0, sc_core::SC_NS);

  /* Connect multiplexer input/output ports with channels */
  mux8.in0(sigin0);
  mux8.in1(sigin1);
  mux8.in2(sigin2);
  mux8.in3(sigin3);
  mux8.in4(sigin4);
  mux8.in5(sigin5);
  mux8.in6(sigin6);
  mux8.in7(sigin7);

  mux8.sel0(sel0);
  mux8.sel1(sel1);
  mux8.sel2(sel2);
  mux8.sel3(sel3);
  mux8.sel4(sel4);
  mux8.sel5(sel5);
  mux8.sel6(sel6);
  mux8.sel7(sel7);

  mux8.out(sigout0);
  mux8.LIB = true;  /*Set environmanr variable */
  /* Connect trace file and data input/output channels */
  sc_trace(fp, sigin0, "in0");
  sc_trace(fp, sigin1, "in1");
  sc_trace(fp, sigin2, "in2");
  sc_trace(fp, sigin3, "in3");
  sc_trace(fp, sigin4, "in4");
  sc_trace(fp, sigin5, "in5");
  sc_trace(fp, sigin6, "in6");
  sc_trace(fp, sigin7, "in7");
  sc_trace(fp, sel0, "sel0");
  sc_trace(fp, sel1, "sel1");
  sc_trace(fp, sel2, "sel2");
  sc_trace(fp, sel3, "sel3");
  sc_trace(fp, sel4, "sel4");
  sc_trace(fp, sel5, "sel5");
  sc_trace(fp, sel6, "sel6");
  sc_trace(fp, sel7, "sel7");
  sc_trace(fp, sigout0, "out");
  /* Generate new data and run single simulation step */
  sigin0.write(true);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(true);
  sel1.write(false);
  sel2.write(false);
  sel3.write(false);
  sel4.write(false);
  sel5.write(false);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
 /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(true);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(true);
  sel2.write(false);
  sel3.write(false);
  sel4.write(false);
  sel5.write(false);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  /* Print input signal, select signal and output 
     signal bits to console */
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(true);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(false);
  sel2.write(true);
  sel3.write(false);
  sel4.write(false);
  sel5.write(false);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(true);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(false);
  sel2.write(false);
  sel3.write(true);
  sel4.write(false);
  sel5.write(false);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(false);
  sel2.write(false);
  sel3.write(false);
  sel4.write(true);
  sel5.write(false);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(true);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(false);
  sel2.write(false);
  sel3.write(false);
  sel4.write(false);
  sel5.write(true);
  sel6.write(false);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(false);
  sel0.write(false);
  sel1.write(false);
  sel2.write(false);
  sel3.write(false);
  sel4.write(false);
  sel5.write(false);
  sel6.write(true);
  sel7.write(false);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Generate new data and run single simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sigin4.write(false);
  sigin5.write(false);
  sigin6.write(false);
  sigin7.write(true);
  sel0.write(false);
  sel1.write(false);
  sel2.write(false);
  sel3.write(false);
  sel4.write(false);
  sel5.write(false);
  sel6.write(false);
  sel7.write(true);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data "<<sigin0.read();
  std::cout<<" "<<sigin1.read()<<" "<<sigin2.read()<<" ";
  std::cout<<sigin3.read()<<" "<<sigin4.read()<<" ";
  std::cout<<sigin5.read()<<" "<<sigin6.read()<<" ";
  std::cout<<sigin7.read()<<" Select ";
  std::cout<<sel0.read()<<" "<<sel1.read()<<" ";
  std::cout<<sel2.read()<<" "<<sel3.read()<<" ";
  std::cout<<sel4.read()<<" "<<sel5.read()<<" ";
  std::cout<<sel6.read()<<" "<<sel7.read()<<" Output ";
  std::cout<<sigout0.read()<<std::endl;
  /* Stop simulation and close trace file */
  sc_stop();
  sc_close_vcd_trace_file(fp);
  return 0;
}
