#include "n2_cl_a1.h"
#include <cstdlib>
#include <cstring>

/* TEST BENCH SYSTEMC EXAMPLE 5.1 */

int sc_main(int argc, char **argv)
{
  /* Combinational logic – NO clocks */
  /* Input/output channels */
  sc_core::sc_signal<bool> sigin0;
  sc_core::sc_signal<bool> sigout0;
  /* Trace file pointer -- for VCD format output */
  sc_core::sc_trace_file *fp;

  /*Declare/define inverter and VCD trace file */
  cl_a1_clk_inv_16x inv_1_bit("inv_1_bit");
  fp = sc_create_vcd_trace_file("tr_inv_1_bit");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  /* Connect module ports and channels */
  inv_1_bit.in(sigin0);
  inv_1_bit.out(sigout0);
  inv_1_bit.LIB = true; /*Set environmanr variable */
    
  sigin0.write(true);
  sc_trace(fp, sigin0, "inv_in");
  sc_trace(fp, sigout0, "inv_out");
  /* Run a single  simulation step */
  sc_start(2.0, sc_core::SC_NS);
  /* Print time stamp and signal
     values for console display */
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
  /* Change input and run another simulation step */
  sigin0.write(false);
  sc_start(2.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
  /* Change input and run another simulation step */
  sigin0.write(true);
  sc_start(2.0, sc_core::SC_NS);
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
   /* Change input and run another simulation step */
  sigin0.write(false);
  sc_start(2.0, sc_core::SC_NS);
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
  /* Change input and run another simulation step */
  sigin0.write(true);
  sc_start(2.0, sc_core::SC_NS);
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
   /* Change input and run another simulation step */
  sigin0.write(false);
  sc_start(2.0, sc_core::SC_NS);
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
  /* Change input and run another simulation step */
  sigin0.write(true);
  sc_start(2.0, sc_core::SC_NS);
std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t"<<sigin0.read()<<"\t"<<sigout0.read()<<std::endl;
  /* Stop simulation and close VCD trace file */
  sc_stop();
  sc_close_vcd_trace_file(fp);
  return 0;
}
