#include "dec2ieee754.h"

const unsigned int SIZE = 10;

int sc_main(int argc, char **argv)
{
  
  if(argc < 3)
  {
    std::cout<<"Insufficient parameters ... "<<std::endl;
    std::cout<<"usage ./sim <floating point number> <floating point number> "<<std::endl;
    exit(0);
  }

  sc_core::sc_signal<float> numsig0;
  sc_core::sc_signal<float> numsig1;
  sc_core::sc_signal< sc_dt::sc_bv<EXPO> > opersig;
  sc_core::sc_signal< sc_dt::sc_bv<1> > sigf;
  sc_core::sc_signal< sc_dt::sc_bv<1> > signsig0;
  sc_core::sc_signal< sc_dt::sc_bv<1> > signsig1;
  sc_core::sc_signal< sc_dt::sc_bv<MAXFRBITS32> > significandsig0;
  sc_core::sc_signal< sc_dt::sc_bv<EXPSIZE32> > exponentsig0;
  sc_core::sc_signal< sc_dt::sc_bv<MAXFRBITS32> > significandsig1;
  sc_core::sc_signal< sc_dt::sc_bv<EXPSIZE32> > exponentsig1;
  sc_core::sc_signal< sc_dt::sc_bv<MAXFRBITS32> > significandsigf;
  sc_core::sc_signal< sc_dt::sc_bv<EXPSIZE32> > exponentsigf;
  
  dec2ieee754_32_conv ieee_convt("ieee_convt");
  ieee754_32_2dec_conv ieee_dec_conv("ieee_dec_conv");
  ieee754_32_arithmetic_all_bin arithallbin("arith_all_bin");


  char number0[SIZE];
  char number1[SIZE];
  float num0;
  float num1;
  sc_dt::sc_bv<EXPO> opervalue;
  unsigned int i;
  unsigned int j;
  unsigned int len0;
  unsigned int len1;

  ieee_convt.floatin0(numsig0);
  ieee_convt.floatin1(numsig1);
  ieee_convt.exponentout0(exponentsig0);
  ieee_convt.significandout0(significandsig0);
  ieee_convt.signout0(signsig0);
  ieee_convt.exponentout1(exponentsig1);
  ieee_convt.significandout1(significandsig1);
  ieee_convt.signout1(signsig1);
  /*  
  arithall.floatin0(numsig0);
  arithall.floatin1(numsig1);
  arithall.operin(opersig);
  arithall.exponentout0(exponentsigf);
  arithall.significandout0(significandsigf);
  arithall.signout0(sigf);
  */
  arithallbin.significandin0(significandsig0);
  arithallbin.significandin1(significandsig1);
  arithallbin.exponentin0(exponentsig0);
  arithallbin.exponentin1(exponentsig1);
  arithallbin.signin0(signsig0);
  arithallbin.signin1(signsig1);
  arithallbin.oper = 3;
  
  ieee_dec_conv.exponentin(exponentsigf);
  ieee_dec_conv.significandin(significandsigf);
  ieee_dec_conv.signbitin(sigf);

  len0 = strlen(argv[1]);
  len1 = strlen(argv[2]);

  if(len0 > 0 && len1 > 0)
  {
    strcpy(number0, argv[1]);
    strcpy(number1, argv[2]);
  }   
  else
  {
    std::cout<<"invalid input ... exiting ..."<<std::endl;
    exit(0);
  }

  num0 = strtof(number0, NULL);
  num1 = strtof(number1, NULL);
  opervalue = "10";
  numsig0.write(0.0);
  numsig1.write(0.0);
  opersig.write(opervalue);
  sc_core::sc_start(10.0, sc_core::SC_NS);  
  
  numsig0.write(num0);
  numsig1.write(num1);
  opersig.write(opervalue);
 
  sc_core::sc_start(10.0, sc_core::SC_NS);
  
  numsig0.write(num0);
  numsig1.write(num1);
  opersig.write(opervalue);
  sc_core::sc_start(10.0, sc_core::SC_NS);  
  sc_core::sc_stop();
  return 0;
}

