#include "commonsrcs.h"
#include "delsig.h"
#include "dff1.h"
#include "gendatatrace.h"
#include "sysctrace.h"

#include <cstdlib>
#include <cstring>


int sc_main(int argc, char **argv)
{
  sc_core::sc_report_handler::set_actions("/IEEE_Std_1666/deprecated", sc_core::SC_DO_NOTHING);

  double amplitude;
  double frequency;
  double refvalue;

  if(argc < 4)
  {
    std::cout<<"Missing arguments ..."<<std::endl;
    std::cout<<"usage ./sim <amplitude> <frequency> <refval>"<<std::endl;
    exit(0);
  }


  amplitude = strtod(argv[1], NULL);
  frequency = strtod(argv[2], NULL);
  refvalue  = strtod(argv[3], NULL);

  sc_core::sc_signal<bool> dffin;
  sc_core::sc_signal<bool> dffout;
  sca_tdf::sca_signal<double> sigin;
  sca_tdf::sca_signal<double> refsig;
  sca_tdf::sca_signal<double> sigcmpin;
  sca_tdf::sca_signal<double> sigdacin;
  sca_tdf::sca_signal<double> sigdacout; 

  sc_core::sc_clock clock("clock", 1.6, sc_core::SC_US, 0.5);
  /* audiosig audio_sig("audio_sig"); */
  comparator c0("c0");
  refsrc ref_src("ref_src");
  /* delsigcore delsig_core("delsig_core"); ,p 100.0, 100.0); */
  lssd2 delsig_core("delsig_core", 60.0, 60.0);
  dff1 dff_1("dff_1");
  onebitdac one_bit_dac("one_bit_dac");
  sinsrc ssrc("sin_src"); 
  ssctracesglbool trbool("tr_dff_out");
  tracedoublecombo trdbl("tr_delsigcore_dac");
  
  ssrc.sigout(sigin);
  ssrc.amplitude = amplitude;
  ssrc.frequency = frequency;

  /* audio_sig.audioout(sigin); */
  ref_src.refout(refsig);
  ref_src.refvalue = refvalue;
  
  delsig_core.sigin(sigin);
  delsig_core.fdbksigin(sigdacout);
  delsig_core.sigout(sigcmpin);  
  
  c0.sigin(sigcmpin);
  c0.refsig(refsig);
  c0.sigout(sigdacin);
  c0.sigoutde(dffin);
  /* c0.sigoutde(iirin); */

  dff_1.clock(clock);
  dff_1.din(dffin);
  dff_1.dout(dffout);

  one_bit_dac.sigin(sigdacin);
  one_bit_dac.sigout(sigdacout);

  /*  
  iirfilt iir_filt("iir_filt");
  iir_filt.clock(clock);
  iir_filt.moddatain(iirin);
  iir_filt.dout(iirout); 
  */
  
  trdbl.in1(sigin);
  trdbl.in2(sigdacin);

  trbool.clk(clock);
  trbool.din0(dffout);

  sc_core::sc_start(100.0, sc_core::SC_MS);
  sc_core::sc_stop();
  return 0;
} 
 
