#include "commonsrcs.h"
#include "delsigbp.h"
#include "dff1.h"
#include "gendatatrace.h"
#include "sysctrace.h"

/* #include <systemc> */

#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> blsig0;
  sc_core::sc_signal<bool> blsig1;
 
  sca_tdf::sca_signal<double> sig0;
  sca_tdf::sca_signal<double> sig1;
  sca_tdf::sca_signal<double> sig2;
  sca_tdf::sca_signal<double> sig3;
  sca_tdf::sca_signal<double> sig4;
  sca_tdf::sca_signal<double> sig5;
  sca_tdf::sca_signal<double> sig6;
  sca_tdf::sca_signal<double> sig7;
  
  
  double amplitude;
  double frequency;
  double refval;
  
  if(argc < 4)
  {
    std::cout<<"insufficient parameters ..."<<std::endl;
    std::cout<<"usage : ./sim <amplitude> <frequency> <reference value>"<<std::endl;
    exit(0);
  }

  amplitude = strtod(argv[1], NULL);
  frequency = strtod(argv[2], NULL);
  refval = strtod(argv[3], NULL);
  
  sc_core::sc_clock clock("clock", 2.0, sc_core::SC_US, 0.5);
 
  comparator comp("c0");
  refsrc ref_src("ref_src");
  dff1 df_f_1("df_f_1");
  elnbndpass60 eln_bp_0("eln_bp_0");
  elnbndpass60 eln_bp_1("eln_bp_1");
  onebitdac one_bit_dac("one_bit_dac");
  sinsrc sin_src("sin_src");
  sumwrap sum_wrap_0("sum_wrap_0");
  sumwrap sum_wrap_1("sum_wrap_1");
  ssctracesglbool trbool("tr_dff_out");  
  tracedoublecombo trdbl("tr_bndpass_bp"); 
  
  sin_src.sigout(sig0);
  sin_src.amplitude = amplitude;
  sin_src.frequency = frequency;

  ref_src.refout(sig1);  
  ref_src.refvalue = refval;

  comp.sigin(sig6);
  comp.refsig(sig1);
  comp.sigout(sig7);
  comp.sigoutde(blsig0);

  df_f_1.din(blsig0);
  df_f_1.clock(clock);
  df_f_1.dout(blsig1);

  eln_bp_0.inp(sig3);
  eln_bp_0.outp(sig4);

  eln_bp_1.inp(sig5);
  eln_bp_1.outp(sig6);

  one_bit_dac.sigin(sig7);
  one_bit_dac.sigout(sig2);

  sum_wrap_0.sigin(sig0);
  sum_wrap_0.fdbksigin(sig2);
  sum_wrap_0.sigout(sig3);       

  sum_wrap_1.sigin(sig4);
  sum_wrap_1.fdbksigin(sig2);
  sum_wrap_1.sigout(sig5);    

  trdbl.in1(sig0);
  trdbl.in2(sig7);

  trbool.clk(clock);
  trbool.din0(blsig1);
  
  sc_start(100.0, sc_core::SC_MS);
  return 0;
}


