#include "fecenc.h"
#include "fecsrc.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal< sc_dt::sc_bv<16> > bitchnl;
  sc_core::sc_signal<bool> ctrl_line;  
  sc_core::sc_clock clk("clk", 20, sc_core::SC_NS, 0.5);
  fecsrc fec_src("fec_src");
  fecenc fec_enc("fec_enc");
  
  fec_src.clk(clk);
  fec_src.txc_ctrl(ctrl_line);
  fec_src.tx_bit_16(bitchnl);

  fec_enc.tx_clk(clk);
  fec_enc.txc_ctrl(ctrl_line);
  fec_enc.tx_bit_16(bitchnl);

  sc_core::sc_start(2750.0, sc_core::SC_NS);
  sc_core::sc_stop();
  return 0;
}

 
