#include "movavg.h"
#include "syscsrcs.h"
#include "sysctrace.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<double> dblsig;
  sc_core::sc_signal<double> avgsig;

  sc_core::sc_clock clk("clk", 10.0, sc_core::SC_US, 0.5); 
  movavg mavg("mavg");
  syncdatasrcdbl sdtsrc("sdtsrc");
  ssctracedbldbl sscmvg("tr_movavg");
  mavg.clk(clk);
  mavg.insig(dblsig);
  mavg.outsig(avgsig);
  sdtsrc.clk(clk);
  sdtsrc.dout(dblsig);
  sscmvg.din0(dblsig);
  sscmvg.din1(avgsig);
  sc_core::sc_start(20000.0, sc_core::SC_US);
  sc_core::sc_stop();
  return 0;
}

