#include "n2_stb_cm_64x45_array.h"
#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> cam_ldq_sig ; /* quad-ld cam */
  sc_core::sc_signal<bool> tcu_array_wr_inhibit_sig;
  sc_core::sc_signal<bool> siclk_sig;
  sc_core::sc_signal< sc_dt::sc_bv<3> > cam_rw_ptr_sig ; 
  /* wr pointer for single port. */
  sc_core::sc_signal< sc_dt::sc_bv<3> > cam_rw_tid_sig ; 
  /* thread id for rw. */
  sc_core::sc_signal<bool> wptr_vld_sig ; /* write pointer vld */
  sc_core::sc_signal<bool> rptr_vld_sig ; /* read pointer vld */
  sc_core::sc_signal< sc_dt::sc_bv<45> > camwr_data_sig ; 
  /* data for compare/write */
  sc_core::sc_signal<bool> cam_vld_sig ; /* cam is required. */
  sc_core::sc_signal< sc_dt::sc_bv<3> > cam_cm_tid_sig ; 
  /* thread id for cam operation.*/
  sc_core::sc_signal< sc_dt::sc_bv<8> > cam_line_en_sig; 
  /* mask for squashing cam */
  sc_core::sc_signal< sc_dt::sc_bv<45> > stb_rdata_sig; 
  /* rd data from CAM RAM. */
  sc_core::sc_signal< bool> stb_ld_partial_raw_sig; 
  /* ld with partial raw. */
  sc_core::sc_signal< sc_dt::sc_bv<3> > stb_cam_hit_ptr_sig;
  sc_core::sc_signal< bool> stb_cam_hit_sig ;  /* any hit in stb */
  sc_core::sc_signal< bool> stb_cam_mhit_sig ;  /* multiple hits in stb */

  sc_dt::sc_bv<45> camwr_data_value;
  sc_dt::sc_bv<45> stb_rdata_value;
  sc_dt::sc_bv<8> cam_line_en_value;
  sc_dt::sc_bv<3> cam_rw_ptr_value;
  sc_dt::sc_bv<3> cam_rw_tid_value;
  sc_dt::sc_bv<3> stb_cam_hit_ptr_value;
  
  bool cam_ldq_value;
  bool tcu_array_wr_inhibit_value;
  bool siclk_value;
  bool wptr_vld_value;
  bool rptr_vld_value;
  bool cam_vld_value;
  bool stb_ld_partial_raw_value;
  bool stb_cam_hit_value;
  bool stb_cam_mhit_value;

  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  n2_stb_cm_64x45_array cam_array_64x45("n2_stb_cm_64x45_array_64x45");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_n2_stb_cm_64x45");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  
  cam_array_64x45.clk(clk);
  cam_array_64x45.cam_ldq(cam_ldq_sig); /* quad-ld cam. */
  cam_array_64x45.tcu_array_wr_inhibit(tcu_array_wr_inhibit_sig);
  cam_array_64x45.siclk(siclk_sig);
  cam_array_64x45.cam_rw_ptr(cam_rw_ptr_sig); 
  /* wr pointer for single port. */
  cam_array_64x45.cam_rw_tid(cam_rw_tid_sig); 
  /* thread id for rw. */
  cam_array_64x45.wptr_vld(wptr_vld_sig); /* write pointer vld */
  cam_array_64x45.rptr_vld(rptr_vld_sig); /* read pointer vld */
  cam_array_64x45.camwr_data(camwr_data_sig); 
  /* data for compare/write */
  cam_array_64x45.cam_vld(cam_vld_sig); /* cam is required. */
  cam_array_64x45.cam_cm_tid(cam_cm_tid_sig); 
  /* thread id for cam operation.*/
  cam_array_64x45.cam_line_en(cam_line_en_sig); 
  /* mask for squashing cam */
  cam_array_64x45.stb_rdata(stb_rdata_sig); 
  /* rd data from CAM RAM. */
  cam_array_64x45.stb_ld_partial_raw(stb_ld_partial_raw_sig); 
  /* ld with partial raw. */
  cam_array_64x45.stb_cam_hit_ptr(stb_cam_hit_ptr_sig);
  cam_array_64x45.stb_cam_hit(stb_cam_hit_sig);  /* any hit in stb */
  cam_array_64x45.stb_cam_mhit(stb_cam_mhit_sig); /* multiple hits in stb */
  
  sc_core::sc_trace(fp, clk, "clk");
  sc_core::sc_trace(fp, cam_ldq_sig, "cam_ldq");
  sc_core::sc_trace(fp, tcu_array_wr_inhibit_sig, "tcu_array_wr_inhibit");
  sc_core::sc_trace(fp, siclk_sig, "siclk");
  sc_core::sc_trace(fp, cam_rw_ptr_sig, "cam_rw_ptr");
  sc_core::sc_trace(fp, cam_rw_tid_sig, "cam_rw_tid");
  sc_core::sc_trace(fp, wptr_vld_sig, "wptr_vld");
  sc_core::sc_trace(fp, rptr_vld_sig, "rptr_vld");
  sc_core::sc_trace(fp, camwr_data_sig, "camwr_data");
  sc_core::sc_trace(fp, cam_vld_sig, "cam_vld");
  
  camwr_data_value="000000011000000011100010010001111000010101010";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="000";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=true;
  rptr_vld_value=false;
  cam_vld_value=false;

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(2.0, sc_core::SC_NS);
  
  camwr_data_value="010100110001100111000110010100100101101100011";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="001";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=true;
  rptr_vld_value=false;
  cam_vld_value=false;
  

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(2.0, sc_core::SC_NS);

  camwr_data_value="010111110101100111000110110100101101101101011";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="010";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=true;
  rptr_vld_value=false;
  cam_vld_value=false;
  

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(2.0, sc_core::SC_NS);

  camwr_data_value="010110000101100111000110110111101101101101010";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="011";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=true;
  rptr_vld_value=false;
  cam_vld_value=false;
  

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(1.0, sc_core::SC_NS);

  camwr_data_value="010110101101100101010110110100101101101101011";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="101";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=true;
  rptr_vld_value=false;
  cam_vld_value=false;
  

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(2.0, sc_core::SC_NS);

  camwr_data_value="010111110101100111000110110100101101101101011";
  cam_line_en_value="00000000";
  cam_rw_ptr_value="010";
  cam_ldq_value=true;
  tcu_array_wr_inhibit_value=false;
  siclk_value=false;
  wptr_vld_value=false;
  rptr_vld_value=true;
  cam_vld_value=false;
  

  cam_ldq_sig.write(cam_ldq_value);
  tcu_array_wr_inhibit_sig.write(tcu_array_wr_inhibit_value);
  siclk_sig.write(siclk_value);
  cam_rw_ptr_sig.write(cam_rw_ptr_value);
  cam_rw_tid_sig.write(cam_rw_tid_value);
  wptr_vld_sig.write(wptr_vld_value);
  rptr_vld_sig.write(rptr_vld_value);
  camwr_data_sig.write(camwr_data_value);
  cam_vld_sig.write(cam_vld_value);
  cam_line_en_sig.write(cam_line_en_value);

  sc_core::sc_start(4.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  
  return 0;
}

