#include "pulsecounter.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_clock mclk("mclk",2.0,sc_core::SC_NS, 0.5);
  sc_core::sc_clock sclk("sclk",10.0, sc_core::SC_US, 0.5);

  pulsecounter pcntr("pcntr");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_pulsecounter");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  pcntr.mclk(mclk);
  pcntr.sig(sclk);

  sc_trace(fp, mclk, "clock");
  sc_trace(fp, sclk, "sec_clk");

  sc_core::sc_start(1500.0, sc_core::SC_US);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

