#include "pwmsysc.h"
#include "syscsrcs.h"
#include "sysctrace.h"
#include <cstdlib>

int sc_main(int argc, char* argv[])
{
   /* Read in triangle carrier signal 
      amplitude, frequency, DC signal value */
   if(argc < 4)
   {
     std::cout<<"Insufficient parameters ..."<<std::endl;
     std::cout<<"usage ./sim <amplitude> <frequency> <offset>"<<std::endl;
     exit(0);
   }

   /* Declare/define channels/signals */
   sc_core::sc_signal<double> pwm;
   sc_core::sc_signal<double> triangle;
   sc_core::sc_signal<double> refsig;
   
   double amplitude = strtod(argv[1], NULL);
   double frequency = strtod(argv[2], NULL);
   double offset = strtod(argv[3], NULL);

   /* Declare/define clock for reference and high frequency 
      triangle carrier wave generation */
   sc_core::sc_clock clk("clk", 25.0, sc_core::SC_US, 0.5);     
   
   /* Declare/define PWM module, signal sources and trace file */
   pwmtrstl pwm_trstl("pwm_tr_stl");
   refsrc ref_src("ref_src");
   trianglesrc triangle_src("triangle_src");
   ssctracedbldbl ssctrdbldbl("tr_pwmstl");

   /* Connect module ports and channels/signals */
   pwm_trstl.refsigin(refsig);
   pwm_trstl.intriangle(triangle);
   pwm_trstl.pwmout(pwm);
 
   ref_src.clk(clk);
   ref_src.refout(refsig);
   ref_src.refval = offset;

   triangle_src.clk(clk);
   triangle_src.sigout(triangle);
   triangle_src.amplitude = amplitude;
   triangle_src.frequency = frequency;

   ssctrdbldbl.din0(triangle);
   ssctrdbldbl.din1(pwm);
   /* Run simulation for pre-defind time-interval and then stop */
   sc_core::sc_start(5000.0, sc_core::SC_US);
   sc_core::sc_stop();
   return 0;
}
