#include "dff2.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> d_qd0;
  sc_core::sc_signal<bool> d_qd1;
  sc_core::sc_signal<bool> d_qd2;
  sc_core::sc_signal<bool> d_qd3;
  sc_core::sc_signal<bool> d_qd4;
  sc_core::sc_signal<bool> d_qd5;
  sc_core::sc_signal<bool> q0;
  sc_core::sc_signal<bool> q1;
  sc_core::sc_signal<bool> q2;
  sc_core::sc_signal<bool> q3;
  sc_core::sc_signal<bool> q4;
  sc_core::sc_signal<bool> q5;

  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  dff_2 d_f_f_2_0("d_f_f_2_0");
  dff_2 d_f_f_2_1("d_f_f_2_1");
  dff_2 d_f_f_2_2("d_f_f_2_2");
  dff_2 d_f_f_2_3("d_f_f_2_3");
  dff_2 d_f_f_2_4("d_f_f_2_4");
  dff_2 d_f_f_2_5("d_f_f_2_5");

  sc_core::sc_trace_file *fp;
  fp = sc_core::sc_create_vcd_trace_file("tr_ripple_cntr");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  d_f_f_2_0.clock(clk);
  d_f_f_2_0.din(d_qd0);
  d_f_f_2_0.dout(q0);
  d_f_f_2_0.doutb(d_qd0);
  
  d_f_f_2_1.clock(q0);
  d_f_f_2_1.din(d_qd1);
  d_f_f_2_1.dout(q1);
  d_f_f_2_1.doutb(d_qd1);

  d_f_f_2_2.clock(q1);
  d_f_f_2_2.din(d_qd2);
  d_f_f_2_2.dout(q2);
  d_f_f_2_2.doutb(d_qd2);

  d_f_f_2_3.clock(q2);
  d_f_f_2_3.din(d_qd3);
  d_f_f_2_3.dout(q3);
  d_f_f_2_3.doutb(d_qd3);

  d_f_f_2_4.clock(q3);
  d_f_f_2_4.din(d_qd4);
  d_f_f_2_4.dout(q4);
  d_f_f_2_4.doutb(d_qd4);

  d_f_f_2_5.clock(q4);
  d_f_f_2_5.din(d_qd5);
  d_f_f_2_5.dout(q5);
  d_f_f_2_5.doutb(d_qd5);

  sc_trace(fp, clk, "clk");
  sc_trace(fp, q0, "q0");
  sc_trace(fp, q1, "q1");
  sc_trace(fp, q2, "q2");
  sc_trace(fp, q3, "q3");
  sc_trace(fp, q4, "q4");
  sc_trace(fp, q5, "q5");

  sc_core::sc_start(1000.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

