#include "threeightdec.h"
#include "systemc.h"

/* TEST BENCH SYSTEMC EXAMPLE 5.8 */

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal< sc_dt::sc_lv<3> > insig;
  sc_core::sc_signal< sc_dt::sc_lv<8> > outsig;
  sc_dt::sc_lv<3> invect;
  sc_dt::sc_lv<8> outvect;

  threeightdec dec_3_8("dec_3_8");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_threeightdec");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  dec_3_8.in(insig);
  dec_3_8.out(outsig);
  sc_core::sc_trace(fp, insig, "lv3in");
  sc_core::sc_trace(fp, outsig, "lv8out");
  
  invect = "ZZZ";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  /* Print input and output signal values on console */
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;
 
  invect = "000";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  invect = "100";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;  
 
  invect = "010";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;
 
  invect = "001";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  invect = "101";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  invect = "011";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  invect = "110";
  insig.write(invect);
    
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  invect = "111";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;
 
  invect = "XXX";
  insig.write(invect);
  
  sc_core::sc_start(5.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Input ";
  std::cout<<insig.read()<<" Output "<<outsig.read()<<std::endl;

  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

