#ifndef TESTBV_H
#define TESTBV_H

#include <systemc>

SC_MODULE(adder3b)
{
  sc_core::sc_in< sc_dt::sc_bv<3> > input;
  sc_core::sc_out< sc_dt::sc_bv<2> > output;

  sc_dt::sc_bv<3> inp;
  sc_dt::sc_bv<2> tmp0;
  sc_dt::sc_bv<2> tmp1;
  sc_dt::sc_bv<2> tmp2;
  sc_dt::sc_bv<2> carry_sum;
  sc_dt::sc_bv<1> carry_bit;
  sc_dt::sc_bv<1> sum_bit;
  sc_dt::sc_bv<1> cb0;
  sc_dt::sc_bv<1> cb1;
  sc_dt::sc_bv<1> cb2; 

  void adder3b_proc0()
  {
    while(1)
    {
      wait();
      inp = input.read();
      tmp0 = inp.range(0,1);
      tmp1 = inp.range(1,2);
      tmp2[0] = inp[0];
      tmp2[1] = inp[2];
      cb0 = tmp0.and_reduce();
      cb1 = tmp1.and_reduce();
      cb2 = tmp2.and_reduce();
      carry_bit = cb0 | cb1 | cb2;
      sum_bit = inp.xor_reduce();
      carry_sum[0] = carry_bit[0];
      carry_sum[1] = sum_bit[0];
      output.write(carry_sum);
      std::cout<<"In : "<<inp<<" Carry "<<carry_bit<<" Sum "<<sum_bit<<std::endl;
    }
  }

  SC_CTOR(adder3b)
  {
    SC_THREAD(adder3b_proc0);
    sensitive << input;
  }
  ~adder3b(){ }
};

SC_MODULE(mux8)
{
  sc_core::sc_in< sc_dt::sc_bv<8> > in;
  sc_core::sc_in< sc_dt::sc_bv<8> > sel;
  sc_core::sc_out< sc_dt::sc_bv<1> > out;

  sc_dt::sc_bv<8> inbv;
  sc_dt::sc_bv<8> selbv;
  sc_dt::sc_bv<8> tmp;
  sc_dt::sc_bv<1> outbv;

  void mux8_proc0()
  {
    while(1)
    {
      wait();
      inbv = in.read();
      selbv = sel.read();
      tmp = inbv & selbv;
      outbv = tmp.or_reduce();
      out.write(outbv);
    }
  }

  SC_CTOR(mux8)
  {
    SC_THREAD(mux8_proc0);
    sensitive << sel;
  }

  ~mux8(){ }
};

#endif

  
