#ifndef BILBO_H
#define BILBO_H

#include <systemc>

SC_MODULE(dff)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in0;
  sc_core::sc_out<bool> out0;

  void dff_proc0()
  {
    while(1)
    {
      wait();
      out0.write(in0.read());
    }
  }

  SC_CTOR(dff)
  {
    SC_THREAD(dff_proc0);
    sensitive << clk.pos();
  }

  ~dff(){ }
};

SC_MODULE(dffout2)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in0;
  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;

  void dffout2_proc0()
  {
    while(1)
    {
      wait();
      out0.write(in0.read());
      out1.write(!(in0.read()));
    }
  }

  SC_CTOR(dffout2)
  {
    SC_THREAD(dffout2_proc0);
    sensitive << clk.pos();
  }

  ~dffout2(){ }
};

SC_MODULE(mux2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> ctrl;
  sc_core::sc_out<bool> out0;

  void mux2_proc0()
  {
    while(1)
    {
      wait();
      if(ctrl.read() == true) out0.write(in0.read());
      else if(ctrl.read() == false) out0.write(in1.read());
    }
  }

  SC_CTOR(mux2)
  {
    SC_THREAD(mux2_proc0);
    sensitive << ctrl;
  }
 
  ~mux2(){ }
};

   

SC_MODULE(nand2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  
  void nand2_proc0()
  {
    while(1)
    {
      wait();
      out0.write(!(in0.read()) & !(in1.read()));
    }
  }

  SC_CTOR(nand2)
  {
    SC_THREAD(nand2_proc0);
    sensitive << in0 << in1;
  }
  
  ~nand2(){ }
};

SC_MODULE(nor2)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  
  void nor2_proc0()
  {
    while(1)
    {
      wait();
      out0.write(!(in0.read()) | !(in1.read()));
    }
  }

  SC_CTOR(nor2)
  {
    SC_THREAD(nor2_proc0);
    sensitive << in0 << in1;
  }
  
  ~nor2(){ }
};
  
SC_MODULE(xorgate)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  bool b0;
  bool b1;
  bool b2;

  void xorgate_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      b1 = in1.read();
      b2 = ((b0 & !b1) | (!b0 & b1));
      out0.write(b2);
    }
  }

  SC_CTOR(xorgate):b0(false), b1(false), b2(false)
  { 
    SC_THREAD(xorgate_proc0);
    sensitive << in0 <<in1;
  }

  ~xorgate() { }
};

SC_MODULE(xorgateneg)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  bool b0;
  bool b1;
  bool b2;

  void xorgateneg_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      b1 = in1.read();
      b2 = !((b0 & !b1) | (!b0 & b1));
      out0.write(b2);
    }
  }

  SC_CTOR(xorgateneg):b0(false), b1(false), b2(false)
  { 
    SC_THREAD(xorgateneg_proc0);
    sensitive << in0 <<in1;
  }

  ~xorgateneg() { }
};

SC_MODULE(bilbo)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> shftin;
  sc_core::sc_in<bool> c1;
  sc_core::sc_in<bool> c2;
  sc_core::sc_in<bool> c3;
  sc_core::sc_in<bool> t1;
  sc_core::sc_in<bool> t2;
  sc_core::sc_in<bool> t3;
  sc_core::sc_in<bool> t4;
  sc_core::sc_out<bool> shftout;

  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig6a;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;
  sc_core::sc_signal<bool> sig9;
  sc_core::sc_signal<bool> sig10;
  sc_core::sc_signal<bool> sig11;
  sc_core::sc_signal<bool> sig12;
  sc_core::sc_signal<bool> sig13;
  sc_core::sc_signal<bool> sig14;
  sc_core::sc_signal<bool> sig15;
  sc_core::sc_signal<bool> sig16;
  sc_core::sc_signal<bool> sig17;
  
  dff df0;
  dff df1;
  dff df2;
  
  dffout2 dffo;

  mux2 mux_2;

  nand2 nand_0;
  nand2 nand_1;
  nand2 nand_2;
  nand2 nand_3;

  nor2 nor_0;
  nor2 nor_1;
  nor2 nor_2;
  nor2 nor_3;

  xorgateneg xorn_0;
  xorgateneg xorn_1;
  xorgateneg xorn_2;
  xorgateneg xorn_3;

  xorgate xor_0;

  SC_CTOR(bilbo):df0("df0"), df1("df1"), df2("df2"),
                 dffo("dffo"), mux_2("mux_2"),
                 nand_0("nand_0"), nand_1("nand_1"),
                 nand_2("nand_2"), nand_3("nand_3"),
                 nor_0("nor_0"), nor_1("nor_1"),
                 nor_2("nor_2"), nor_3("nor_3"),
                 xorn_0("xorn_0"), xorn_1("xorn_1"), 
                 xorn_2("xorn_2"), xorn_3("xorn_3"),
                 sig0("sig0"), sig1("sig1"), sig2("sig2"),
                 sig3("sig3"), sig4("sig4"), sig5("sig5"),
                 sig6("sig6"), sig6a("sig6a"), sig7("sig7"), 
                 sig8("sig8"), sig9("sig9"), sig10("sig10"), 
                 sig11("sig11"), sig12("sig12"), sig13("sig13"),
                 sig14("sig14"), sig15("sig15"), sig16("sig16"),
                 sig17("sig17"), xor_0("xor_0")
                 
  {
    mux_2.in0(shftin);
    mux_2.in1(sig0);
    mux_2.ctrl(c3);
    mux_2.out0(sig17);

    nor_0.in0(c2);
    nor_0.in1(sig17);
    nor_0.out0(sig15);

    nand_0.in0(c1);
    nand_0.in1(t1);
    nand_0.out0(sig16);

    xorn_0.in0(sig16);
    xorn_0.in1(sig15);
    xorn_0.out0(sig14);

    df0.clk(clk);
    df0.in0(sig14);
    df0.out0(sig13);

    nor_1.in0(c2);
    nor_1.in1(sig13);
    nor_1.out0(sig11);

    nand_1.in0(c1);
    nand_1.in1(t2);
    nand_1.out0(sig12);

    xorn_1.in0(sig11);
    xorn_1.in1(sig12);
    xorn_1.out0(sig10);

    df1.clk(clk);
    df1.in0(sig10);
    df1.out0(sig9);

    nor_2.in0(c2);
    nor_2.in1(sig9);
    nor_2.out0(sig6);

    nand_2.in0(c1);
    nand_2.in1(t3);
    nand_2.out0(sig7);

    xorn_2.in0(sig7);
    xorn_2.in1(sig6);
    xorn_2.out0(sig6a);

    df2.clk(clk);
    df2.in0(sig6a);
    df2.out0(sig5);
  
    nor_3.in0(c2);
    nor_3.in1(sig5);
    nor_3.out0(sig4);

    nand_3.in0(c1);
    nand_3.in1(t4);
    nand_3.out0(sig3);

    xorn_3.in0(sig3);
    xorn_3.in1(sig4);
    xorn_3.out0(sig2);

    dffo.clk(clk);
    dffo.in0(sig2);
    dffo.out0(shftout);
    dffo.out1(sig1);

    xor_0.in0(sig1);
    xor_0.in1(sig13);
    xor_0.out0(sig0);
 }

 ~bilbo(){ }
};


  
#endif

