#ifndef BOOTH_H
#define BOOTH_H

#include <systemc>

const unsigned int WIDTH = 32;
const unsigned int WIDTHP1 = 33;
const unsigned int WIDTH2 = 64;
const unsigned int WIDTH2P1 = 65;

SC_MODULE(booth)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> enable;
  sc_core::sc_in< sc_dt::sc_bv<WIDTH> > multiplier;   
  sc_core::sc_in< sc_dt::sc_bv<WIDTH> > multiplicand;
  sc_core::sc_out<bool> done;
  sc_core::sc_out< sc_dt::sc_bv<WIDTH2> > product;

  sc_dt::sc_bv<2> current_state;
  sc_dt::sc_bv<2> next_state;
  sc_dt::sc_bv<WIDTH> iter_cnt;
  sc_dt::sc_bv<WIDTH2P1> a_reg;
  sc_dt::sc_bv<WIDTH2P1> s_reg;
  sc_dt::sc_bv<WIDTH2P1> p_reg;
  sc_dt::sc_bv<WIDTH2P1> sum_reg;
  sc_dt::sc_bv<WIDTHP1> multiplier_neg;
  
  void booth_proc0()
  {
    while(1)
    {
      wait();
      if(enable.read() == false) current_state = "00";
      else current_state = next_state;
    }
  }

  void booth_proc1()
  {
    while(1)
    {
      wait();
      if(current_state == "00")
      {
        if(enable.read() == true) next_state = "01";
        else next_state = "00";
      }
      else if(current_state == "01")
      { 
         next_state = "10";
      }
      else if(current_state == "10")
      {
         if(iter_cnt.to_int() == WIDTH) next_state = "11";
         else next_state = "01";
      }
      else if(current_state == "11")
      {
        next_state = "00";
      } 
    }
  }

  void booth_proc2()
  {
    sc_dt::sc_bv<2> p_reg_tmp;
    sc_dt::sc_bv<32> multiplier_local;
    while(1)
    {
      wait();
      if(current_state == "00")
      {
       multiplier_local = multiplier.read();
       multiplier_neg = (~multiplier_local).to_int() + 1;
       a_reg = (multiplier.read(),  "000000000000000000000000000000000");
       s_reg = (multiplier_neg, "000000000000000000000000000000000");
       p_reg = ("000000000000000000000000000000000", multiplicand.read(),
                "0");
       iter_cnt = "00000000000000000000000000000000";
       done.write(false);
      }
      else if(current_state == "01")
      {
       p_reg_tmp = p_reg.range(1,0);
        if(p_reg_tmp == "01")
        {
         sum_reg = p_reg ^ a_reg;
        }
        else if(p_reg_tmp == "10")
        {
         sum_reg = p_reg ^ s_reg;
        }
        else if(p_reg_tmp == "11")
        { 
         sum_reg = p_reg;
        }
        else if(p_reg_tmp == "00")
        {
         sum_reg = p_reg;
        }
        iter_cnt = iter_cnt.to_int() + 1;
      }
      else if(current_state == "10")
      {
        p_reg = (sum_reg.range(64,64),sum_reg.range(64,1));
      }
      else if(current_state == "11")
      {
        product.write(p_reg);
        done.write(true);
      }
    }
  }
  
  SC_CTOR(booth):current_state("00"),next_state("00"),
iter_cnt("0000000000000000"), 
  a_reg("000000000000000000000000000000000000000000000000000000000000000000"),                  p_reg("000000000000000000000000000000000000000000000000000000000000000000"), 
s_reg("000000000000000000000000000000000000000000000000000000000000000000"),
sum_reg("000000000000000000000000000000000000000000000000000000000000000000"), 
multiplier_neg("000000000000000000000000000000000")
  {
    SC_CTHREAD(booth_proc0,clk.pos());
    SC_CTHREAD(booth_proc2,clk.pos());
    SC_THREAD(booth_proc1);
    sensitive << clk << enable << multiplier << multiplicand;
  }

  ~booth(){ }
};

#endif
   
/*
// state encodings.
parameter   IDLE   = 2'b00,
            ADD    = 2'b01,
            SHIFT  = 2'b10,
            OUTPUT = 2'b11;
 
reg  [1:0]              current_state, next_state;  // state registers.
reg  [2*WIDTH+1:0]      a_reg,s_reg,p_reg,sum_reg;  // computational values.
reg  [WIDTH-1:0]        iter_cnt;                   // iteration count for determining when done.
wire [WIDTH:0]          multiplier_neg;             // negative value of multiplier
 
// state machine.
always @(posedge clk)
  if (!enable) current_state = IDLE;
  else         current_state <= next_state;
 
always @* begin
  next_state = 2'bx;
  case (current_state)
    IDLE   : if (enable)          next_state = ADD;
             else                 next_state = IDLE;
    ADD    :                      next_state = SHIFT;
    SHIFT  : if (iter_cnt==WIDTH) next_state = OUTPUT;
             else                 next_state = ADD;
    OUTPUT :                      next_state = IDLE;
  endcase
end
 
// negative value of multiplier.
assign multiplier_neg = -{multiplier[WIDTH-1],multiplier}; 
// algorithm implemenation details.
always @(posedge clk) begin
  case (current_state)
    IDLE :  begin
      a_reg    <= {multiplier[WIDTH-1],multiplier,{(WIDTH+1){1'b0}}};
      s_reg    <= {multiplier_neg,{(WIDTH+1){1'b0}}};
      p_reg    <= {{(WIDTH+1){1'b0}},multiplicand,1'b0};
      iter_cnt <= 0;
      done     <= 1'b0;
    end
    ADD  :  begin
      case (p_reg[1:0])
        2'b01       : sum_reg <= p_reg+a_reg;
        2'b10       : sum_reg <= p_reg+s_reg;
        2'b00,2'b11 : sum_reg <= p_reg;
      endcase
      iter_cnt <= iter_cnt + 1;
    end
    SHIFT :  begin
      p_reg <= {sum_reg[2*WIDTH+1],sum_reg[2*WIDTH+1:1]};
    end
    OUTPUT : begin
      product <= p_reg[2*WIDTH:1];
      done    <= 1'b1;
    end
  endcase
end
endmodule
*/
