#ifndef CHNL_H
#define CHNL_H

#include <systemc>
#include <iostream>
#include <cstring>
#include <cstdlib>


class chnlIf : public sc_core::sc_interface
{
  public: 
  virtual void write_proc(char *) = 0;
  virtual void read_proc(char *) = 0; 
};

class chnl : public chnlIf, public sc_core::sc_module
{
  private:
   char msg[64];
   enum states{READY = 0, BUSY };
   unsigned int chnlstatus;
   unsigned int waitperiod;

  public:
   SC_HAS_PROCESS(chnl);
   sc_core::sc_in<bool> clk;

   void write_proc(char *cp)
   {
     if(cp != NULL)
     {
       wait();
       while(chnlstatus == BUSY) 
       {
         std::cout<<"waiting to write ..."<<std::endl;
         waitperiod = std::rand() % 10;
         wait(waitperiod); 
       }
       if(chnlstatus == READY)
       {
         chnlstatus = BUSY;
         strncpy(msg, cp, strlen(cp));
         chnlstatus = READY;
       }
     }
   }

   void read_proc(char *cp)
   {
     if(cp != NULL)
     {
       wait();
       while(chnlstatus == BUSY) 
       {
         std::cout<<"Channel busy wait - read ..."<<std::endl;
         waitperiod = std::rand() % 10;
         wait(waitperiod); 
       }
       if(chnlstatus == READY)
       {
         chnlstatus = BUSY;
         strncpy(cp, msg, strlen(msg));
         chnlstatus = READY;
       }
     }
   }

   chnl (sc_core::sc_module_name nm) : sc_core::sc_module(nm),
                              chnlstatus(READY),
                              waitperiod(0)
   {
     bzero(&msg[0], 64*sizeof(char));
     sensitive<<clk.pos();
   }

   ~chnl() { }
};


#endif

