#ifndef CHNLENDS_H
#define CHNLENDS_H

#include "chnl.h"


const unsigned int MAX = 64;
const char *str = "Shri Shri Durga Shri Saraswati Shri Lakshmi Namaha";

class chnlendA : public sc_core::sc_module
{
  private:
   chnl &chnlPtr;
   char tmpA[MAX];
  public:
   sc_core::sc_in<bool> clk;
   /* SC_HAS_PROCESS(chnlendA); */
   typedef chnlendA SC_CURRENT_USER_MODULE;  

   void readtest()
   {
     while(1)
     {
       wait();
       chnlPtr.read_proc(&tmpA[0]);
       std::cout<<name()<<" read : "<<tmpA<<std::endl;
       bzero(&tmpA[0], MAX*sizeof(char));
     } 
   }

   chnlendA(sc_core::sc_module_name nm,
            chnl &chnlPtr) : sc_core::sc_module(nm), chnlPtr(chnlPtr)
   { 
     SC_THREAD(readtest);
     sensitive<<clk.pos();  
     bzero(&tmpA[0], MAX*sizeof(char)); 
   }
   ~chnlendA(){ }

   
};


class chnlendB : public sc_core::sc_module
{
  private:
   chnl &chnlPtr;
   char tmpB[MAX];
  public:
   sc_core::sc_in<bool> clk;
   SC_HAS_PROCESS(chnlendB); 

   void writetest()
   {
     while(1)
     {
       wait();
       sprintf(&tmpB[0], "%s", str);
       chnlPtr.write_proc(&tmpB[0]);
       std::cout<<name()<<" wrote : "<<tmpB<<std::endl;
       bzero(&tmpB[0], MAX*sizeof(char));
     } 
   }   

   chnlendB(sc_core::sc_module_name nm, 
            chnl &chnlPtr) : sc_core::sc_module(nm), chnlPtr(chnlPtr)
   {
     SC_THREAD(writetest);
     sensitive<<clk.pos();
     bzero(&tmpB[0], MAX*sizeof(char));
   }
   ~chnlendB(){ }

   
};

#endif

