#ifndef COMMONSRCS_H
#define COMMONSRCS_H

#include <systemc-ams>
#include <cstdlib>

const double PI2     = 6.28;
const double PH0     = 2.09;
const double PH1     = 4.18; 
const unsigned int MAX = 150;

SCA_TDF_MODULE(boolsrc)
{
  sca_tdf::sca_out<bool> sigout;
  
  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_NS);
    sigout.set_rate(1);
  }

  void processing()
  {
    sigout.write(true);
  }

  SCA_CTOR(boolsrc){}
  ~boolsrc(){}
};



SCA_TDF_MODULE(syncpulse)
{
  sca_tdf::sca_de::sca_out<double> sigout;
  double currtime;
  double freq;
  double value;
  double plsvalue;

  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_MS);
    sigout.set_rate(1);
  }

  void processing()
  {
    currtime = sc_core::sc_time_stamp().to_seconds();
    value = plsvalue*cos(6.28*freq*currtime) -
            plsvalue*cos(3.0*6.28*freq*currtime)/3 +
            plsvalue*cos(5.0*6.28*freq*currtime)/5 -
            plsvalue*cos(7.0*6.28*freq*currtime)/7 +
            plsvalue*cos(9.0*6.28*freq*currtime)/9 -
            plsvalue*cos(11.0*6.28*freq*currtime)/11 +
            plsvalue*cos(13.0*6.28*freq*currtime)/13 -
            plsvalue*cos(15.0*6.28*freq*currtime)/15 +
            plsvalue*cos(17.0*6.28*freq*currtime)/17 -
            plsvalue*cos(19.0*6.28*freq*currtime)/19 +
            plsvalue*cos(21.0*6.28*freq*currtime)/21 -
            plsvalue*cos(23.0*6.28*freq*currtime)/23 +
            plsvalue*cos(25.0*6.28*freq*currtime)/25 -
            plsvalue*cos(27.0*6.28*freq*currtime)/27 +
            plsvalue*cos(29.0*6.28*freq*currtime)/29 -
            plsvalue*cos(31.0*6.28*freq*currtime)/31 +
            plsvalue*cos(33.0*6.28*freq*currtime)/33 -
            plsvalue*cos(35.0*6.28*freq*currtime)/35 +
            plsvalue*cos(37.0*6.28*freq*currtime)/37 -
            plsvalue*cos(39.0*6.28*freq*currtime)/39 +
            plsvalue*cos(41.0*6.28*freq*currtime)/41 -
            plsvalue*cos(43.0*6.28*freq*currtime)/43 +
            plsvalue*cos(45.0*6.28*freq*currtime)/45 -
            plsvalue*cos(47.0*6.28*freq*currtime)/47 +
            plsvalue*cos(49.0*6.28*freq*currtime)/49 -
            plsvalue*cos(51.0*6.28*freq*currtime)/51;
    sigout.write(value);
  }

  SCA_CTOR(syncpulse):value(0.0){ }
  ~syncpulse(){ }
};

SCA_TDF_MODULE(constsrcpn)
{
  sca_tdf::sca_out<double> sigout0;
  sca_tdf::sca_out<double> sigout1;
  double dvalue0;
  double dvalue1;

  void set_attributes()
  {
    sigout0.set_timestep(1.0, sc_core::SC_NS);
    sigout1.set_timestep(1.0, sc_core::SC_NS);
    sigout0.set_rate(1);
    sigout1.set_rate(1);
  }

  void processing()
  {
    dvalue1 = 0.0 - dvalue0;
    sigout0.write(dvalue0);
    sigout1.write(dvalue1);
  }

  SCA_CTOR(constsrcpn):dvalue0(0.0), dvalue1(0.0){}
  ~constsrcpn(){}
};
  

SCA_TDF_MODULE(onebitadc)
{
  sca_tdf::sca_de::sca_in<double> sigin;
  sca_tdf::sca_de::sca_out<double> sigout;
  double currvalue;

  void set_attributes()
  {
    sigin.set_timestep(1.0, sc_core::SC_MS);
    sigout.set_timestep(1.0, sc_core::SC_MS);
    sigin.set_rate(1);
    sigout.set_rate(1);
  }

  void processing()
  {
    currvalue = sigin.read();
    if(currvalue < 0.0) sigout.write(0.0);
    else sigout.write(currvalue);
  }

  SCA_CTOR(onebitadc):currvalue(0.0){ }
  ~onebitadc(){ }
};


SCA_TDF_MODULE(txlinetrg)
{
  sca_tdf::sca_out<double> trg;
  bool first;
  double dd;
  unsigned int count;
  unsigned int tmp;

  void set_attributes()
  {
    trg.set_timestep(1.0, sc_core::SC_US);
    trg.set_rate(1);
  }

  void processing()
  {
    if(first == false) first = true;
    else
    {
      if(count % MAX == 0)
      {
        tmp = (unsigned int)(10.0*drand48());
        dd = (tmp % 2 == 1) ? 10.0 : 0.0;
        count = 0;
      }
    }
    std::cout<<name()<<" "<<count<<" "<<dd<<std::endl;
    count += 1;
    trg.write(dd);
  }
  
  SCA_CTOR(txlinetrg):first(false),
                      count(0),
                      dd(0.0),
                      tmp(0){ }
  ~txlinetrg(){ }
};

SCA_TDF_MODULE(ransig)
{
  sca_tdf::sca_out<double> ransigout;
  double ranvalue;
 
  void set_attributes()
  {
    ransigout.set_timestep(1.0, sc_core::SC_US);
    ransigout.set_rate(1);
  }

  void processing()
  {
    ranvalue = drand48(); /* *1.0E-12; */
    ransigout.write(ranvalue);
  }

  SCA_CTOR(ransig){ }
  ~ransig(){ }
};

SCA_TDF_MODULE(randata)
{
  sca_tdf::sca_out<double> randatasigout;
  double ranvalue;
  /* double datavalue; */

  void set_attributes()
  {
    randatasigout.set_timestep(1.0, sc_core::SC_US);
    randatasigout.set_rate(1);
  }

  void processing()
  {
    ranvalue = 10.0*drand48();
    /*
    datavalue = ranvalue >= 5.0 ? 7.5 : 2.5;  
    randatasigout.write(datavalue);
    */
    randatasigout.write(ranvalue);
  }

  SCA_CTOR(randata){ }
  ~randata(){ }
};



SC_MODULE(adjrefsrc)
{
  sc_core::sc_in<double> adjin;
  sc_core::sc_out<double> refout;
  double adjval;
  double refvalue;
  double threshold;
  double tmp;
    
  void adjrefsrc_proc0()
  {
    while(1)
    {
      wait();
      tmp = adjin.read();
      if(refvalue < threshold) refvalue += tmp/adjval;
      else refvalue -= tmp/adjval;
      refout.write(refvalue);
    }
  }


  SC_CTOR(adjrefsrc):adjval(0.0),refvalue(0.0),threshold(0.0), tmp(0.0) 
  {
    SC_THREAD(adjrefsrc_proc0);
    sensitive << adjin; 
  }

  ~adjrefsrc() { }
};



SCA_TDF_MODULE(refsrc)
{
  sca_tdf::sca_out<double> refout;
  double refvalue;

  void set_attributes()
  {
    refout.set_timestep(1.0, sc_core::SC_US);
    refout.set_rate(1);
  }

  void processing()
  {
    refout.write(refvalue);
  }

  SCA_CTOR(refsrc) { }
  ~refsrc() { }
};

SCA_TDF_MODULE(refsrcde)
{
  sca_tdf::sca_de::sca_out<double> refout;
  double refvalue;

  void set_attributes()
  {
    refout.set_timestep(1.0, sc_core::SC_NS); 
    refout.set_rate(1);
  }

  void processing()
  {
    refout.write(refvalue);
  }

  SCA_CTOR(refsrcde) { }
  ~refsrcde() { }
};


SCA_TDF_MODULE(refsrcdeus)
{
  sca_tdf::sca_de::sca_out<double> refout;
  double refvalue;

  void set_attributes()
  {
    refout.set_timestep(1.0, sc_core::SC_US); 
    refout.set_rate(1);
  }

  void processing()
  {
    refout.write(refvalue);
  }

  SCA_CTOR(refsrcdeus) { }
  ~refsrcdeus() { }
};

SCA_TDF_MODULE(audiosig)
{
  sca_tdf::sca_out<double> audioout;
  double audiovalue;
  bool first;
  unsigned int count;

  void set_attributes()
  {
    audioout.set_timestep(1.0, sc_core::SC_US);
    audioout.set_rate(1);
  }

  void processing()
  {
    if(first == false)
    {
      first = true;
    }
    else
    {
      if(count % 350 == 0)
      {
        audiovalue = std::rand() % 10;
        count = 0;
      }
    }
    std::cout<<audiovalue<<std::endl;
    audioout.write(audiovalue);
    count += 1;
  }

  SCA_CTOR(audiosig):audiovalue(5.0), first(false){ }
  ~audiosig(){ }
};


SCA_TDF_MODULE(audiosigshort)
{
  sca_tdf::sca_out<short> audioout;
  short audiovalue;
  bool first;
  unsigned int count;

  void set_attributes()
  {
    audioout.set_timestep(1.0, sc_core::SC_US);
    audioout.set_rate(1);
  }

  void processing()
  {
    if(!first)
    {
      audioout.write(audiovalue);
      first = true;
      count += 1;
    }
    else
    {
      if(count == 500)
      {
        audiovalue = (short)(std::rand() % 10);
        count = 0;
      }
      audioout.write(audiovalue);
      count += 1;
    }
  }

  SCA_CTOR(audiosigshort) : audiovalue(5), first(false){ }
  ~audiosigshort(){ }
};


SCA_TDF_MODULE(audiosigshortde)
{
  sca_tdf::sca_de::sca_out<short> audioout;
  short audiovalue;
  bool first;
  unsigned int count;

  void set_attributes()
  {
    audioout.set_timestep(1.0, sc_core::SC_US);
    audioout.set_rate(1);
  }

  void processing()
  {
    if(first == false)
    {
      audioout.write(audiovalue);
      first = true;
    }
    else if(first == true)
    {
      if(count % 10 == 0)
      {
        audiovalue = (short)(10*(std::rand() % 10));
        count = 0;
      }
    }
    audioout.write(audiovalue);
    count += 1;
  }

  SCA_CTOR(audiosigshortde) : audiovalue(5), first(false){ }
  ~audiosigshortde(){ }
};


SCA_TDF_MODULE(audiosigfast)
{
  sca_tdf::sca_out<double> audiooutfast;
  double audiovaluefast;
  bool firstfast;
  unsigned int countfast;

  void set_attributes()
  {
    audiooutfast.set_timestep(1.0, sc_core::SC_NS);
    audiooutfast.set_rate(1);
  }

  void processing()
  {
    if(!firstfast)
    {
      audiooutfast.write(audiovaluefast);
      firstfast = true;
      countfast += 1;
    }
    else
    {
      if(countfast == 500)
      {
        audiovaluefast = std::rand() % 10;
        countfast = 0;
      }
      audiooutfast.write(audiovaluefast);
      countfast += 1;
    }
  }

  SCA_CTOR(audiosigfast) :  audiovaluefast(5.0), firstfast(false){ }
  ~audiosigfast(){ }
};


SCA_TDF_MODULE(sinsrcdeadj)
{
  sca_tdf::sca_de::sca_out<double> sigout;
  double amplitude;
  double currtime;
  double frequency;
  double incr;
  double sinval;
  unsigned int count;
  
  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_NS);
    sigout.set_rate(1);
  }

  void processing()
  {
    currtime = sigout.get_time().to_seconds();
    if(count == MAX) { count = 0; frequency += incr; }
    else
    {
      sinval = amplitude*sin(6.28*frequency*currtime);
      count += 1;
    }
    sigout.write(sinval);
  }

  SCA_CTOR(sinsrcdeadj):count(0), 
                        currtime(0.0), 
                        sinval(0.0)
  { }
  ~sinsrcdeadj(){ }
};
  

SCA_TDF_MODULE(sinsrc)
{
   sca_tdf::sca_out<double> sigout;

   double amplitude;
   double frequency;
   double currtime;
   double lasttime;
   double sineval;

   void set_attributes()
   {
    sigout.set_timestep(1.0, sc_core::SC_US);  /* Was SC_NS */
    sigout.set_rate(1);
   }

   void initialize()
   {
     sigout.initialize(0.0);
   }

   void processing()
   {
      currtime = sigout.get_time().to_seconds();
      sineval = amplitude*sin(2.0*3.14*frequency*currtime);
      /* std::cout<<" time = "<<currtime << std::endl; */
      lasttime = currtime > lasttime ? currtime : lasttime;
      sigout.write(sineval);
   }

   SCA_CTOR(sinsrc) : currtime(0.0),
                      lasttime(0.0){ }
   ~sinsrc(){}
};

SCA_TDF_MODULE(sinsrcdephpi)
{
   sca_tdf::sca_de::sca_out<double> sigout0;
   sca_tdf::sca_de::sca_out<double> sigout1;

   double amplitude;
   double frequency;
   double phase;
   double currtime;
   double lasttime;
   double sineval0;
   double sineval1;

   void set_attributes()
   {
     sigout0.set_timestep(1.0, sc_core::SC_US);
     sigout1.set_timestep(1.0, sc_core::SC_US);
     sigout0.set_rate(1);
     sigout1.set_rate(1);
   }
   
   void processing()
   {
      currtime = sigout0.get_time().to_seconds();
      sineval0 = amplitude*sin(2.0*3.14*frequency*currtime);
      sineval1 = amplitude*sin(2.0*3.14*frequency*currtime + phase);
      lasttime = currtime > lasttime ? currtime : lasttime;
      sigout0.write(sineval0);
      sigout1.write(sineval1);
   }

   SCA_CTOR(sinsrcdephpi) : currtime(0.0),
                            lasttime(0.0), 
                            sineval0(0.0),
                            sineval1(0.0){ }
   ~sinsrcdephpi(){}
};


SCA_TDF_MODULE(sinsrcde)
{
   sca_tdf::sca_de::sca_out<double> sigout;

   double amplitude;
   double frequency;
   double currtime;
   double lasttime;
   double sineval;

   void set_attributes()
   {
     sigout.set_timestep(1.0, sc_core::SC_PS); /* was SC_US */
     sigout.set_rate(1);
   }
   
   void processing()
   {
      currtime = sigout.get_time().to_seconds();
      sineval = amplitude*sin(2.0*3.14*frequency*currtime);
      lasttime = currtime > lasttime ? currtime : lasttime;
      sigout.write(sineval);
   }

   SCA_CTOR(sinsrcde) : currtime(0.0),
                        lasttime(0.0), 
                        sineval(0.0){ }
   ~sinsrcde(){}
};


SCA_TDF_MODULE(sinsrc_offset)
{
  sca_tdf::sca_out<double> sigout;

  double amplitude;
  double frequency;
  double currtime;
  double offset;
  double sineval;

  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_US);
    sigout.set_rate(1);
  }

  void initialize()
  {
    sigout.initialize(0.0);
  }

    void processing()
   {
      currtime = sigout.get_time().to_seconds();
      sineval = offset + amplitude*sin(2.0*3.14*frequency*currtime);
      /* cout<<" time = "<<currtime << endl; */
      sigout.write(sineval);
   }

   SCA_CTOR(sinsrc_offset) : currtime(0.0){ }
   ~sinsrc_offset(){}
};

SCA_TDF_MODULE(sinsrcdeph)
{
   sca_tdf::sca_de::sca_out<double> sinout0;
   sca_tdf::sca_de::sca_out<double> sinout1;
   sca_tdf::sca_de::sca_out<double> sinout2;
   double amplitude;
   double currtime;
   double d0;
   double d1;
   double d2;
   double frequency;
   double freq_incr;  

   void set_attributes()
   {
     sinout0.set_timestep(1.0, sc_core::SC_US);
     sinout1.set_timestep(1.0, sc_core::SC_US);
     sinout2.set_timestep(1.0, sc_core::SC_US);
     sinout0.set_rate(1);
     sinout1.set_rate(1);
     sinout2.set_rate(1);
   }

   void processing()
   {
     currtime = sinout0.get_time().to_seconds();
     d0 = amplitude*sin(2.0*3.14*(frequency + freq_incr)*currtime);
     d1 = amplitude*sin((2.0*3.14*(frequency + freq_incr) + PH0)*currtime);
     d2 = amplitude*sin((2.0*3.14*(frequency + freq_incr) + PH1)*currtime);
     sinout0.write(d0);
     sinout1.write(d1);
     sinout2.write(d2);
   }

   SCA_CTOR(sinsrcdeph):amplitude(0.0),
                        currtime(0.0),
                        d0(0.0),
                        d1(0.0), 
                        d2(0.0), 
                        frequency(0.0),
                        freq_incr(0.0)
   { }
   ~sinsrcdeph(){ }
};

SCA_TDF_MODULE(sinsrcvarfreq)
{
  sca_tdf::sca_de::sca_in<double> in;
  sca_tdf::sca_de::sca_out<double> out;
  double amplitude;
  double currtime;
  double frequency;
  double freq_incr;
  double outvalue;

  void set_attributes()
  {
    in.set_timestep(1.0, sc_core::SC_US);
    out.set_timestep(1.0, sc_core::SC_US);
    in.set_rate(1);
    out.set_rate(1);
  }

  void processing()
  {
    currtime = in.get_time().to_seconds();
    freq_incr = in.read();
    outvalue = amplitude*sin(2.0*3.14*(frequency+freq_incr)*currtime);
    out.write(outvalue);
  }

  SCA_CTOR(sinsrcvarfreq):amplitude(0.0),
                          currtime(0.0),
                          frequency(0.0),
                          freq_incr(0.0),
                          outvalue(0.0)
  { }
  ~sinsrcvarfreq(){ }
};
   
SCA_TDF_MODULE(sinsrcdbl)
{
  sca_tdf::sca_out<double> sigout1;
  sca_tdf::sca_out<double> sigout2;

  double amplitude;
  double frequency;
  double sinvalout1;
  double sinvalout2;
  double phasedelay;
  double currtime;

  void set_attributes()
  {
    sigout1.set_timestep(1.0, sc_core::SC_US);
    sigout2.set_timestep(1.0, sc_core::SC_US);
    sigout1.set_rate(1);
    sigout2.set_rate(1);
  }

  void processing()
  {
    currtime = sigout1.get_time().to_seconds();
    sinvalout1 = amplitude*sin(2.0*3.14*frequency*currtime);
    sinvalout2 = amplitude*sin(2.0*3.14*frequency*currtime + phasedelay);
    sigout1.write(sinvalout1);
    sigout2.write(sinvalout2);
  }

  SCA_CTOR(sinsrcdbl) { }

  ~sinsrcdbl(){ }
};

SCA_TDF_MODULE(src_triangle_de)
{
   sca_tdf::sca_de::sca_out<double> out;
   double amplitude;
   double frequency;
   double tmp;
   double currtime;
   double outval;

   void set_attributes()
   {
     out.set_timestep(1.0, sc_core::SC_US);
     out.set_rate(1);
   }

   void processing()
   {
      currtime = out.get_time().to_seconds();
      tmp = sin(PI2*frequency*currtime)-
            (1.0/9.0)*sin(3.0*PI2*frequency*currtime)+
            (1.0/25.0)*sin(5.0*PI2*frequency*currtime)-
            (1.0/49.0)*sin(7.0*PI2*frequency*currtime)+
            (1.0/81.0)*sin(9.0*PI2*frequency*currtime)-
            (1.0/121.0)*sin(11.0*PI2*frequency*currtime)+
            (1.0/169.0)*sin(13.0*PI2*frequency*currtime)-
            (1.0/225.0)*sin(15.0*PI2*frequency*currtime)+
            (1.0/289.0)*sin(17.0*PI2*frequency*currtime);
      outval = amplitude*(8.0/9.8596)*tmp;
      out.write(outval);
    /* std::cout<<currtime<<" "<<tmp<<" "<<outval<<std::endl; */
   }

   SC_CTOR(src_triangle_de) : tmp(0.0),
                              currtime(0.0),
                              outval(0.0)
   { }
  ~src_triangle_de(){}
};


SCA_TDF_MODULE(src_triangle)
{
   sca_tdf::sca_out<double> out;
   double amplitude;
   double frequency;
   double tmp;
   double currtime;
   double outval;

   void set_attributes()
   {
     out.set_timestep(1.0, sc_core::SC_US);
     out.set_rate(1);
   }

   void processing()
   {
      currtime = out.get_time().to_seconds();
      tmp = sin(PI2*frequency*currtime)-
            (1.0/9.0)*sin(3.0*PI2*frequency*currtime)+
            (1.0/25.0)*sin(5.0*PI2*frequency*currtime)-
            (1.0/49.0)*sin(7.0*PI2*frequency*currtime)+
            (1.0/81.0)*sin(9.0*PI2*frequency*currtime)-
            (1.0/121.0)*sin(11.0*PI2*frequency*currtime)+
            (1.0/169.0)*sin(13.0*PI2*frequency*currtime)-
            (1.0/225.0)*sin(15.0*PI2*frequency*currtime)+
            (1.0/289.0)*sin(17.0*PI2*frequency*currtime);
      outval = amplitude*(8.0/9.8596)*tmp;
      out.write(outval);
    /* std::cout<<currtime<<" "<<tmp<<" "<<outval<<std::endl; */
   }

   SC_CTOR(src_triangle) : tmp(0.0),
                           currtime(0.0){ }

   ~src_triangle(){}
};

SCA_TDF_MODULE(rampnegpos)
{
  sca_tdf::sca_out<double> rampout;
  double inc;
  double nstart;
  double pend;
  double tmp;

  void initialize() { tmp = nstart; }

  void set_attributes()
  {
    rampout.set_timestep(1.0, sc_core::SC_US);
    rampout.set_rate(1);
  }

  void processing()
  {
    if(tmp < pend) tmp += inc;
    else if(tmp >= pend) tmp = nstart;
    rampout.write(tmp);
  }
  
  SCA_CTOR(rampnegpos){ }
  ~rampnegpos(){ }
};

#endif

