#ifndef DELSFDE_H
#define DELSFDE_H

#include <systemc-ams>

/* Note that each SystemC-AMS LSF 
library module must have its time 
related information set explicity 
with the 'set_timestep(....,....)'
method. Although one can set it 
for one module, and allow that 
information to propagate through 
the cluster, using it with each 
LSF module does not hurt. This 
issue does not arise when using 
LSF modules coupled with TDF modules,
because in that case, the time 
information set explicitly in each
TDF module propagates through the 
cluster */

SC_MODULE(desrc)
{
  /*Declare/define SystemC input/output ports */
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> outp;
  double d;

  /* Module operation thread */
  void desrc_proc0()
  {
    while(1)
    {
      wait();
      d = 10.0*drand48();
      outp.write(d);
    }
  }

  /* Constructor */
  SC_CTOR(desrc):d(0)
  {
    /*Declare/assign thread and its 
      sensitivity list */
    SC_THREAD(desrc_proc0);
    sensitive << clk.pos();
  }

  ~desrc(){ } /* Destructor */
};

SC_MODULE(delsfde)
{
  /* Internal LSF signal channels */
  private:
   sca_lsf::sca_signal sig0;
   sca_lsf::sca_signal sig1;
   sca_lsf::sca_signal sig2;
   
  public:
   /* SystemC input/output ports */
   sc_core::sc_in<bool> clk; 
   sc_core::sc_in<double> inp;
   sc_core::sc_out<double> out0;
   sc_core::sc_out<double> out1;
   /* SystemC discrete-event -- SystemC-AMS LSF 
   converter ports */
   sca_lsf::sca_de::sca_source de2lsf;
   sca_lsf::sca_de::sca_sink lsf2de0;
   sca_lsf::sca_de::sca_sink lsf2de1;
   /* SystemC-AMS LSF demultiplexer with SystemC
   discrete-event control signal */
   sca_lsf::sca_de::sca_demux lsf2dedemux;
  
   /* Constructor -- initialize internal 
      modules/channels */
   SC_CTOR(delsfde):clk("clk"),
                    de2lsf("de2lsf",1.01),
                    inp("inp"),
                    lsf2de0("lsf2de0", 1.02), 
                    lsf2de1("lsf2de1", 1.03),
                    lsf2dedemux("lsf2dedemux"),
                    out0("out0"), 
                    out1("out1"),
                    sig0("sig0"),
                    sig1("sig1"),
                    sig2("sig2")
  {
    /* Connect all module ports, signal channels */
    de2lsf.inp(inp);
    de2lsf.y(sig0);
    /* Set time step for LSF module */
    de2lsf.set_timestep(1.0, sc_core::SC_NS);
    
    lsf2dedemux.x(sig0);
    lsf2dedemux.ctrl(clk);
    lsf2dedemux.y1(sig1);
    lsf2dedemux.y2(sig2);
    /* Set time step for LSF module */
    lsf2dedemux.set_timestep(1.0, sc_core::SC_NS);

    lsf2de0.x(sig1);
    lsf2de0.outp(out0);
    /* Set time step for LSF module */
    lsf2de0.set_timestep(1.0, sc_core::SC_NS);

    lsf2de1.x(sig2);
    lsf2de1.outp(out1);
    /* Set time step for LSF module */
    lsf2de1.set_timestep(1.0, sc_core::SC_NS);
    
  }
  
  ~delsfde(){ } /* Destructor */
};

#endif
  
