#ifndef DELSIG_H
#define DELSIG_H

using namespace std;

#include <systemc-ams>

SCA_TDF_MODULE(comparator)
{
  sca_tdf::sca_in<double> sigin;
  sca_tdf::sca_in<double> refsig;
  sca_tdf::sca_out<double> sigout;
  sca_tdf::sca_de::sca_out<bool> sigoutde; 
  double d1;
  double d2;
  double d3;
  bool deout;
 
  void set_attributes()
  {
    sigoutde.set_timestep(1.0, sc_core::SC_US); 
    sigout.set_timestep(1.0, sc_core::SC_US);
    sigin.set_rate(1);
    sigout.set_rate(1);
    sigoutde.set_rate(1); 
  }

  void processing()
  {
    d1 = sigin.read();
    d2 = refsig.read();
    d3 = (d1 > d2) ? 1.0 : 0.0;
    deout = (d3 == 1.0) ? true : false; 
    sigout.write(d3);
    sigoutde.write(deout); 
  }

  SCA_CTOR(comparator) : d1(0.0),
                         d2(0.0),
                         d3(0.0),
                         deout(false)
                         { }
  ~comparator(){ }
};

SC_MODULE(lssd2)
{
  private:
  sca_lsf::sca_signal sig1;
  sca_lsf::sca_signal sig2;
  sca_lsf::sca_signal sig3;
  sca_lsf::sca_signal sig4;
  sca_lsf::sca_signal sig5;
  sca_lsf::sca_signal sig6;
  sca_lsf::sca_signal sig7;
  sca_lsf::sca_signal sig8;

  public:
  sca_tdf::sca_in<double> sigin;
  sca_tdf::sca_in<double> fdbksigin;
  sca_tdf::sca_out<double> sigout;
  sca_lsf::sca_tdf::sca_source tdf2lsf0;
  sca_lsf::sca_tdf::sca_source tdf2lsf1;
  sca_lsf::sca_tdf::sca_sink lsf2tdf;
  sca_lsf::sca_gain gain1;
  sca_lsf::sca_gain gain2;
  sca_lsf::sca_integ integ1;
  sca_lsf::sca_integ integ2;
  sca_lsf::sca_sub sub1;
  sca_lsf::sca_sub sub2;

  lssd2(sc_core::sc_module_name,
                 double d0,
                 double d1):sigin("sigin"),
                  fdbksigin("fdbksigin"),
                  sigout("sigout"),
                  tdf2lsf0("tdf2lsf0"),
                  tdf2lsf1("tdf2lsf1"),
                  lsf2tdf("lsf2tdf"),
                  gain1("gain1", d0),
                  gain2("gain2", d1),
                  integ1("integ1"), integ2("integ2"),
                  sub1("sub1"), sub2("sub2"),
                  sig1("sig1"), sig2("sig2"),
                  sig3("sig3"), sig4("sig4"),
                  sig5("sig5"), sig6("sig6"),
                  sig7("sig7"), sig8("sig8")
  {
     tdf2lsf0.inp(sigin);
     tdf2lsf0.y(sig1);

     tdf2lsf1.inp(fdbksigin);
     tdf2lsf1.y(sig4);
     lsf2tdf.x(sig8);
     lsf2tdf.outp(sigout);

     sub1.x1(sig1);
     sub1.x2(sig4);
     sub1.y(sig2);

     sub2.x1(sig5);
     sub2.x2(sig4);
     sub2.y(sig6);

     gain1.x(sig3);
     gain1.y(sig5);

     gain2.x(sig7);
     gain2.y(sig8);

     integ1.x(sig2);
     integ1.y(sig3);

     integ2.x(sig6);
     integ2.y(sig7);
  }

  ~lssd2() { }
};


SCA_TDF_MODULE(onebitdac)
{
  sca_tdf::sca_in<double> sigin;
  sca_tdf::sca_out<double> sigout;
  double d0;
  double d1;

  void set_attributes()
  {
    sigout.set_timestep(1.0, sc_core::SC_US);
    sigout.set_rate(1);
    sigout.set_delay(1);
    sigin.set_rate(1);
  }

  void processing()
  {
    d0 = sigin.read();
    d1 = d0 == 1.0 ? 1.0 : -1.0;
    sigout.write(d1);
  }

  SCA_CTOR(onebitdac){ }
  ~onebitdac(){ }
};


 
#endif

