#ifndef ELNTDFINV_H
#define ELNTDFINV_H

#include <systemc-ams>

SCA_TDF_MODULE(trgsrc)
{
  sca_tdf::sca_out<bool> out0;
  sca_tdf::sca_out<bool> out1;
  bool b0;
  bool b1;
  unsigned int rval;

  void set_attributes()
  {
    out0.set_timestep(1.0, sc_core::SC_US);
    out1.set_timestep(1.0, sc_core::SC_US);
    out0.set_rate(1);
    out1.set_rate(1);
  }

  void processing()
  {
    rval = ((unsigned int)(10.0*drand48()) % 2);
    b0 = rval == 1 ? true : false;
    b1 = !b0;
    out0.write(b0);
    out1.write(b1);
    std::cout<<name()<<" "<<b0<<" "<<b1<<std::endl;
  }

  SCA_CTOR(trgsrc):b0(false),b1(false),rval(0){ }
  ~trgsrc(){ }
};

SC_MODULE(elntdfinv)
{
  sca_tdf::sca_in<bool> in0;
  sca_tdf::sca_in<bool> in1;
  sca_tdf::sca_in<double> vconst;
  sca_tdf::sca_out<double> out0;
  
  sca_eln::sca_r r0;
  sca_eln::sca_r r1;
  sca_eln::sca_tdf::sca_rswitch swtch0;
  sca_eln::sca_tdf::sca_rswitch swtch1;
  sca_eln::sca_tdf::sca_vsource vsrc;
  sca_eln::sca_tdf::sca_vsink vout;

  sca_eln::sca_node n1;
  sca_eln::sca_node n2;
  sca_eln::sca_node n3;
  sca_eln::sca_node n4;
  sca_eln::sca_node_ref gnd; 

  SC_CTOR(elntdfinv):r0("r0", 500.0),
                     r1("r1", 5000.0),
                     swtch0("swtch0"),
                     swtch1("swtch1"),
                     vout("vout",1.0),
                     vsrc("vsrc",1.0) 
  {
    r0.p(n4);
    r0.n(gnd);

    r1.p(n2);
    r1.n(n3);

    swtch0.p(n1);
    swtch0.n(n2);
    swtch0.ctrl(in0);
    
    swtch1.p(n3);
    swtch1.n(n4);
    swtch1.ctrl(in1);

    vsrc.inp(vconst);
    vsrc.p(n1);
    vsrc.n(gnd);

    vout.outp(out0);
    vout.p(n3);
    vout.n(gnd);
  }

  ~elntdfinv(){ }
};

#endif

