#ifndef EXPLICITEVENT_H
#define EXPLICITEVENT_H

#include <systemc>
sc_core::sc_event ev0;
SC_MODULE(stimulus)
{
  private:
  bool flag;
  /* stimulus class's private method that does not trigger master or slaves */
  void do_task()
   {
    unsigned int i;
    for(i = 0; i < 20; i++)
    {
      std::cout<<name()<<" do_task "<<std::endl;
    }
  }
  public:
  sc_core::sc_in<bool> clk;
 /*Input port for external clock -- implicit event */
  void stimulus_proc0()
  {
    while(1)
    {
      wait();
       if(flag == false)
        {
         /* If flag is false, perform own task, notify master and slaves, set flag to true*/
        do_task();
        ev0.notify(10.0, sc_core::SC_NS);
          /* Wait pre-defined time interval before notification */
        flag = true;
          /*Set flag to true */
        std::cout<<"Notification sent ..."<<std::endl;
      }
    }
  }

  /* Constructor */
  SC_CTOR(stimulus)
   {
    SC_CTHREAD(stimulus_proc0, clk.pos()); 
    /* Implicit event, sensitize process to clock positive edge */
  }
  /*Destructor */
  ~stimulus() { }
};

SC_MODULE(master)
{
  private:
   bool flag;
  public:
  /* Declare/define input/outpit ports */
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> dout;
  double dvalue;
  /* Master main operation  process*/
  void master_proc0()
  {
    while(1)
    {
      wait();
     /* Wait for implicit event – input clock posirive edge */
      if(flag == false)
      {
        wait(ev0);
         /* If flag is not set wait for explicit event – event notification from stimulus */
        flag = true;
         /* Set flag */
        std::cout<<"master receives notification"<<std::endl;
      }
      else
      {
        dvalue = drand48();
        dout.write(dvalue);
       /*Send data to slaves */
      }
    }
  }
  /* Constructor */
  SC_CTOR(master):flag(false)
  {
    SC_THREAD(master_proc0);
    /*Declare/assign thread triggered by implicit event */
    sensitive << clk.pos();
    /*Sensitize thread to implicit event */
  }
  /*Destructor */
  ~master(){ }
};

SC_MODULE(slave)
{
  private:
   bool flag;
  public:
  /* Declare/define input/outpit ports */
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<double> din;
  double d;
  /* Slave main operation  process*/
  void slave_proc0()
  {
    while(1)
    {
     wait();
 /* Wait for implicit event – input clock posirive edge */
     if(flag == false)
     {
       wait(ev0);
       /* If flag is not set wait for explicit event – event notification from stimulus */
       flag = true;
       /* Set flag */
       std::cout<<name()<<" receives notification"<<std::endl;
     }
     else
     {
        d = din.read();
       /*Receive data from master  */
       std::cout<<name()<<" rec'd "<<d<<std::endl;
     }
    }
  }
  /*Constructor */
  SC_CTOR(slave):flag(false)
  {
    SC_THREAD(slave_proc0)
 /*Declare/assign thread triggered by implicit event */
    sensitive << clk.pos();
 /*Sensitize thread to implicit event */
  }
  /* Destructor */
  ~slave(){ }
};
#endif

