#ifndef FLIPFLOP_H
#define FLIPFLOP_H

#include <systemc>

SC_MODULE(inv)
{
  sc_core::sc_in<bool> din;
  sc_core::sc_out<bool> dout;

  void inv_proc0()
  {
    dout.write(din.read());
  }

  SC_CTOR(inv)
  {
    SC_METHOD(inv_proc0);
    sensitive << din;
  }
  
  ~inv(){ }
};

SC_MODULE(dff)
{
  sc_core::sc_in<bool>  clk;
  sc_core::sc_in<bool>  din;
  sc_core::sc_out<bool> dout;

  void dff_proc0()
  {
    dout.write(din.read());
  }

  SC_CTOR(dff)
  {
    SC_METHOD(dff_proc0);
    sensitive << clk.pos();
  }

  ~dff(){ }
};

SC_MODULE(jkff)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> din0;
  sc_core::sc_in<bool> din1;
  sc_core::sc_out<bool> dout0;
  sc_core::sc_out<bool> dout1;

  bool b0;
  bool b1;
  bool b2;
  bool b3; 
 
  void jkff_proc0()
  {
    b1 = din0.read();
    b2 = din1.read();
    
    std::cout<<name()<<"  @ "<<sc_core::sc_time_stamp().to_seconds()<<" sec Qt "<<b0; 
    
    if(b0 == false)
    {
      if(b1 == false && b2 == false) b0 = false;
      else if(b1 == false && b2 == true) b0 = false;
      else if(b1 == true && b2 == false) b0 = true;
      else if(b1 == true && b2 == true) b0 = true;
    }
    else if(b0 == true)
    {
      if(b1 == false && b2 == false) b0 = true;
      else if(b1 == false && b2 == true) b0 = false;
      else if(b1 == true && b2 == false) b0 = true;
      else if(b1 == true && b2 == true) b0 = false;
    }
    
    std::cout<<" J "<<b1<<" K "<<b2<<" Q(t+1) "<<b0<<std::endl;
    
    b3 = b0;
    dout0.write(b0);
    dout1.write(!b3);
  }

  SC_CTOR(jkff):b0(false), b1(false), b2(false), b3(false)
  {
    SC_METHOD(jkff_proc0);
    sensitive << clk.pos() << din0 << din1;
  }
  ~jkff(){ }
};

#endif
  
