#ifndef GENDATATRACE_H
#define GENDATATRACE_H

#include <systemc-ams>

SCA_TDF_MODULE(tracedblboolcombo)
{
  sca_tdf::sca_in<bool> boolin1;
  sca_tdf::sca_in<bool> boolin2;
  std::ofstream outboolstrm;

  void set_attributes()
  {
    boolin1.set_rate(1);
    boolin2.set_rate(1);
  }
  void processing()
  {
    double currtime;
    currtime = boolin1.get_time().to_seconds();
    outboolstrm<< std::scientific<<currtime << "\t" << boolin1.read() <<"\t"<< boolin2.read() << std::endl;
  }

  SCA_CTOR(tracedblboolcombo)
  { 
    outboolstrm.open(name(), std::ios::out); 
  }
  ~tracedblboolcombo(){ outboolstrm.close(); }
};



SCA_TDF_MODULE(traceboolcombo)
{
  sca_tdf::sca_in<bool> inbool0;
  sca_tdf::sca_in<bool> inbool1;
  sca_tdf::sca_in<bool> inbool2;
  std::ofstream outboolstream;

  void set_attributes()
  {
    inbool0.set_rate(1);
    inbool1.set_rate(1);
    inbool2.set_rate(1);
  }

  void processing()
  {
    double currtime;
    currtime = inbool0.get_time().to_seconds();
    outboolstream << currtime << "\t " << inbool0.read() <<"\t" <<inbool1.read()<<"\t"<<inbool2.read()<<std::endl;
  }

  SCA_CTOR(traceboolcombo)
  {
    outboolstream.open(name(), std::ios::out);
  }

  ~traceboolcombo(){ outboolstream.close(); }
};



SCA_TDF_MODULE(tracedouble)
{
   sca_tdf::sca_in<double> in;
   std::ofstream output;

   void set_attributes() { in.set_rate(1); }

   void processing()
   {
     double currtime;
     currtime = in.get_time().to_seconds();
     output <<std::scientific<< currtime << "\t " << in.read() << std::endl;
   }
   SCA_CTOR(tracedouble)
   {
     output.open(name(), std::ios::out);
   }

   ~tracedouble(){ output.close(); }
};


SCA_TDF_MODULE(tracedoublecombo)
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_in<double> in2;
  std::ofstream outstream;

  void set_attributes()
  {
    in1.set_rate(1);
    in2.set_rate(1);
  }

  void processing()
  {
     double currtime;
     currtime = in1.get_time().to_seconds();
     outstream <<std::scientific<< currtime << "\t " << in1.read() << "\t" << in2.read() <<std::endl;
   }

   SCA_CTOR(tracedoublecombo)
   {
     outstream.open(name(), std::ios::out);
   }

   ~tracedoublecombo(){ outstream.close(); }
};


SCA_TDF_MODULE(traceshortunsignedcharcombo)
{
  sca_tdf::sca_in<short> in1;
  sca_tdf::sca_in<unsigned char> in2;
  std::ofstream outstream;

  void set_attributes()
  {
    in1.set_rate(1);
    in2.set_rate(1);
  }

  void processing()
  {
     double currtime;
     currtime = in1.get_time().to_seconds();
     std::cout<<std::scientific<< currtime <<"\t"<<std::scientific<<in1.read()<<"\t"<<std::scientific<<in2.read()<<std::endl;
   }

   SCA_CTOR(traceshortunsignedcharcombo)
   {
       outstream.open(name(), std::ios::out);
   }

   ~traceshortunsignedcharcombo(){ outstream.close(); }
};

SCA_TDF_MODULE(tracetriplecombo)
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_in<double> in2;
  sca_tdf::sca_in<double> in3;
  std::ofstream outstream;

  void set_attributes()
  {
    in1.set_rate(1);
    in2.set_rate(1);
    in3.set_rate(1);
  }
  void processing()
  {
     double currtime;
     currtime = in1.get_time().to_seconds();
     outstream <<std::scientific<< currtime << "\t " << in1.read() << "\t" << in2.read() << "\t" << in3.read() << std::endl;
   }

   SCA_CTOR(tracetriplecombo)
   {
      outstream.open(name(), std::ios::out);
   }

   ~tracetriplecombo(){ outstream.close(); }
};

SCA_TDF_MODULE(traceint)
{
   sca_tdf::sca_in<unsigned int> in;
   std::ofstream output;

   void set_attributes() { in.set_rate(1); }

   void processing()
   {
     double currtime;
     currtime = in.get_time().to_seconds();
     output <<std::scientific<< currtime << "\t " << in.read() << std::endl;
   }
 SCA_CTOR(traceint) { output.open(name(), std::ios::out); }
 ~traceint(){ output.close(); }
};

SCA_TDF_MODULE(traceintdoublecombo)
{
  sca_tdf::sca_in<double> in1;
  sca_tdf::sca_in<unsigned int> in2;
  std::ofstream outstream;

  void set_attributes()
  {
    in1.set_rate(1);
    in2.set_rate(1);
  }

  void processing()
  {
     double currtime;
     currtime = in1.get_time().to_seconds();
     outstream <<std::scientific<< currtime << "\t " << in1.read() << "\t" << in2.read() <<std::endl;
   }

   SCA_CTOR(traceintdoublecombo)
   {
     outstream.open(name(), std::ios::out);
   }

   ~traceintdoublecombo(){ outstream.close(); }
};


SCA_TDF_MODULE(tracebool)
{
   sca_tdf::sca_in<bool> in;
   std::ofstream output;

   void set_attributes() { in.set_rate(1); }

   void processing()
   {
     double currtime;
     currtime = in.get_time().to_seconds();
     output <<std::scientific<< currtime << "\t " << in.read() << std::endl;
   }

  SCA_CTOR(tracebool) { output.open(name(), std::ios::out); }
 ~tracebool(){ output.close(); }
};



SCA_TDF_MODULE(traceintcombo)
{
  sca_tdf::sca_in<int> int1;
  sca_tdf::sca_in<int> int2;
  std::ofstream outintstream;

  void set_attributes()
  {
    int1.set_rate(1);
    int2.set_rate(1);
  }
void processing()
  {
     double currtime;
     currtime = int1.get_time().to_seconds();
     outintstream <<std::scientific<< currtime << "\t " << int1.read() << "\t" << int2.read() <<std::endl;
   }

   SCA_CTOR(traceintcombo)
   {
     outintstream.open(name(), std::ios::out);
   }

   ~traceintcombo(){ outintstream.close(); }
};



SCA_TDF_MODULE(elntrace2)
{
  sca_tdf::sca_in<double> sig_in1;
  sca_tdf::sca_in<double> sig_in2;
  std::ofstream output;

  void set_attributes()
  {
    set_timestep(1.0, sc_core::SC_US);
  }
  void processing()
  {
      double currtime;

      currtime = sig_in1.get_time().to_seconds();
      output << currtime << "\t " << sig_in1.read() << "\t" << sig_in2.read() << std::endl;
   }

   SCA_CTOR(elntrace2) 
   {
      output.open(name(), std::ios::out);
   }
   ~elntrace2(){ output.close(); }
};


#endif

