#ifndef MEMMISC_H
#define MEMMISC_H

#include <systemc>

SC_MODULE(inv_clk)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<bool> inv_clk_out;
  bool b0;
  
  void inv_clk_proc0()
  {
    while(1)
    {
      wait();
      b0 = clk.read();
      inv_clk_out.write(!b0);
    }
  }

  SC_CTOR(inv_clk):b0(false)
  {
    SC_THREAD(inv_clk_proc0);
    sensitive << clk;
  }

  ~inv_clk(){ }
};

#endif

