#ifndef MOVAVG_H
#define MOVAVG_H

#include <systemc>

const unsigned int MAXFILTELEM = 55;

SC_MODULE(movavg)
{
  public:
   sc_core::sc_in<bool> clk;
   sc_core::sc_in<double> insig;
   sc_core::sc_out<double> outsig;

   bool first;
   double currtime;
   double lastsample;
   double sum;
   double sum_copy;
   double tmp;
   double tmp0;

   unsigned int count;
   
   
   void movavg_proc0()
   {
     while(1)
     {
       wait();
       tmp0 = insig.read();
       currtime = sc_core::sc_time_stamp().to_seconds();
       
       if(count < MAXFILTELEM)
       {
         if(first == false && count == 0) 
         { 
           sum += tmp0;
           first = true; 
         }
         else if(first == true && count == 0)
         {
           sum += 0.25*tmp0;
           sum += 0.75*lastsample;
         }
         else if(first == true && count > 0)
         {
           sum += tmp0;
         } 
         count += 1;
         if(count == MAXFILTELEM - 1) 
         { 
           lastsample = tmp0;
           sum_copy = sum;
           sum_copy /= MAXFILTELEM;
         }  
       }
       else
       {
         count = 0;
         sum = 0.0;
       }
       outsig.write(sum_copy);
     }
   }       
    
   SC_CTOR(movavg):currtime(0.0), 
                   count(0),
                   first(false), 
                   lastsample(0.0),
                   sum(0.0), 
                   sum_copy(0.0), 
                   tmp0(0.0) 
   { 
     SC_THREAD(movavg_proc0);
     sensitive << clk.pos();
   }
   ~movavg(){ }
};

#endif

