#ifndef N2_CL_A1_H
#define N2_CL_A1_H

#include "systemc.h"

const unsigned int SIZE = 1;


SC_MODULE(cl_a1_msffmin_fp_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;

   void a1_msffmin_fp_16x_proc0()
   {
    /*
     while(1)
     { 
       wait(); */
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);          
         else q.write(d.read()); 
       }
   /*  } */ 
   }
   
   void a1_msffmin_fp_16x_proc1()
   {
     /*
     while(1)
     {
       wait();
     */
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
   /*  } */
   }

   void a1_msffmin_fp_16x_proc2()
   {
     /*
     while(1)
     {
       wait(); */ 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
     /*  } */
     }
   }

   void a1_msffmin_fp_16x_proc3()
   {
     /*
     while(1)
     {
       wait(); */
       if (siclk.read() == false && 
           soclk.read() == false) q.write(d.read());
    /*  } */
   }


   SC_CTOR(cl_a1_msffmin_fp_16x):l1(false)
   {
     SC_METHOD(a1_msffmin_fp_16x_proc0);
     sensitive << l1clk.pos() << siclk.pos();
     SC_METHOD(a1_msffmin_fp_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_16x_proc2);
     SC_METHOD(a1_msffmin_fp_16x_proc3);
     sensitive << l1clk.pos();
   }

   ~cl_a1_msffmin_fp_16x() { }
};

SC_MODULE(cl_a1_msffmin_fp_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;

   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;

   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;

   void a1_msffmin_fp_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     } 
   }

   void a1_msffmin_fp_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

 
   SC_CTOR(cl_a1_msffmin_fp_8x)
   {
     SC_THREAD(a1_msffmin_fp_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_8x_proc2);
     SC_CTHREAD(a1_msffmin_fp_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_8x() { }
};


SC_MODULE(cl_a1_msffmin_fp_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
  
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;

   void cl_a1_msffmin_fp_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void cl_a1_msffmin_fp_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void cl_a1_msffmin_fp_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void cl_a1_msffmin_fp_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   SC_CTOR(cl_a1_msffmin_fp_4x)
   {
     SC_THREAD(cl_a1_msffmin_fp_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(cl_a1_msffmin_fp_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(cl_a1_msffmin_fp_4x_proc2);
     SC_CTHREAD(cl_a1_msffmin_fp_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_4x() { }
};


SC_MODULE(cl_a1_msffmin_fp_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void cl_a1_msffmin_fp_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void cl_a1_msffmin_fp_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void cl_a1_msffmin_fp_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void cl_a1_msffmin_fp_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void cl_a1_msffmin_fp_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_32x)
   {
     SC_THREAD(cl_a1_msffmin_fp_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(cl_a1_msffmin_fp_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(cl_a1_msffmin_fp_32x_proc2);
     SC_METHOD(cl_a1_msffmin_fp_32x_proc4);
     SC_CTHREAD(cl_a1_msffmin_fp_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_32x() { }
};

SC_MODULE(cl_a1_msffmin_fp_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void cl_a1_msffmin_fp_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void cl_a1_msffmin_fp_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void cl_a1_msffmin_fp_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void cl_a1_msffmin_fp_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void cl_a1_msffmin_fp_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_1x)
   {
     SC_THREAD(cl_a1_msffmin_fp_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(cl_a1_msffmin_fp_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(cl_a1_msffmin_fp_1x_proc2);
     SC_METHOD(cl_a1_msffmin_fp_1x_proc4);
     SC_CTHREAD(cl_a1_msffmin_fp_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_1x() { }
};

SC_MODULE(cl_a1_msffmin_fp_30ps_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_30ps_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_30ps_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_30ps_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_30ps_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_30ps_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_30ps_16x)
   {
     SC_THREAD(a1_msffmin_fp_30ps_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_30ps_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_30ps_16x_proc2);
     SC_METHOD(a1_msffmin_fp_30ps_16x_proc4);
     SC_CTHREAD(a1_msffmin_fp_30ps_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_30ps_16x() { }
};

/*
SC_MODULE(cl_a1_msffmin_fp_30ps_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_30ps_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_30ps_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_30ps_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_30ps_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_30ps_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_30ps_16x)
   {
     SC_THREAD(a1_msffmin_fp_30ps_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_30ps_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_30ps_16x_proc2);
     SC_METHOD(a1_msffmin_fp_30ps_16x_proc4);
     SC_CTHREAD(a1_msffmin_fp_30ps_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_30ps_8x() { }
};
*/

SC_MODULE(cl_a1_msffmin_fp_30ps_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_30ps_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_30ps_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_30ps_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_30ps_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_30ps_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_30ps_4x)
   {
     SC_THREAD(a1_msffmin_fp_30ps_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_30ps_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_30ps_4x_proc2);
     SC_METHOD(a1_msffmin_fp_30ps_4x_proc4);
     SC_CTHREAD(a1_msffmin_fp_30ps_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_30ps_4x() { }
};

SC_MODULE(cl_a1_msffmin_fp_30ps_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_30ps_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_30ps_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_30ps_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_30ps_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_30ps_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_30ps_32x)
   {
     SC_THREAD(a1_msffmin_fp_30ps_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_30ps_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_30ps_32x_proc2);
     SC_METHOD(a1_msffmin_fp_30ps_32x_proc4);
     SC_CTHREAD(a1_msffmin_fp_30ps_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_30ps_32x() { }
};


SC_MODULE(cl_a1_msffmin_fp_30ps_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_30ps_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_fp_30ps_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_30ps_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_30ps_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_30ps_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_30ps_1x)
   {
     SC_THREAD(a1_msffmin_fp_30ps_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_fp_30ps_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_30ps_1x_proc2);
     SC_METHOD(a1_msffmin_fp_30ps_1x_proc4);
     SC_CTHREAD(a1_msffmin_fp_30ps_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_30ps_1x() { }
};

SC_MODULE(cl_a1_msffmin_fp_syrst_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_1x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_1x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_1x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_1x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_1x() { }
};

/*SC_MODULE(cl_a1_msffmin_fp_syrst_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         // Conflict -- data and scan 
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_1x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_1x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_1x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_1x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_1x() { }
};
*/

SC_MODULE(cl_a1_msffmin_fp_syrst_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_4x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_4x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_4x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_4x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_4x() { }
};

SC_MODULE(cl_a1_msffmin_fp_syrst_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_8x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_8x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_8x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_8x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_8x() { }
};


SC_MODULE(cl_a1_msffmin_fp_syrst_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_16x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_16x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_16x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_16x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_16x() { }
};

SC_MODULE(cl_a1_msffmin_fp_syrst_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_fp_syrst_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_fp_syrst_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_fp_syrst_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_fp_syrst_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_fp_syrst_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_fp_syrst_32x)
   {
     SC_THREAD(a1_msffmin_fp_syrst_32x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_fp_syrst_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_fp_syrst_32x_proc2);
     SC_METHOD(a1_msffmin_fp_syrst_32x_proc4);
     SC_CTHREAD(a1_msffmin_fp_syrst_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_fp_syrst_32x() { }
};


SC_MODULE(cl_a1_msffmin_30ps_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_16x)
   {
     SC_THREAD(a1_msffmin_30ps_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_16x_proc2);
     SC_METHOD(a1_msffmin_30ps_16x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_16x() { }
};


SC_MODULE(cl_a1_msffmin_30ps_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

 
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_8x)
   {
     SC_THREAD(a1_msffmin_30ps_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_8x_proc2);
     SC_METHOD(a1_msffmin_30ps_8x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_8x() { }
};

SC_MODULE(cl_a1_msffmin_30ps_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_4x)
   {
     SC_THREAD(a1_msffmin_30ps_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_4x_proc2);
     SC_METHOD(a1_msffmin_30ps_4x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_4x() { }
};

SC_MODULE(cl_a1_msffmin_30ps_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_32x)
   {
     SC_THREAD(a1_msffmin_30ps_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_32x_proc2);
     SC_METHOD(a1_msffmin_30ps_32x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_32x() { }
};


SC_MODULE(cl_a1_msffmin_30ps_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_1x)
   {
     SC_THREAD(a1_msffmin_30ps_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_1x_proc2);
     SC_METHOD(a1_msffmin_30ps_1x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_1x() { }
};




/*SC_MODULE(cl_a1_msffmin_30ps_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_30ps_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_30ps_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_30ps_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_30ps_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_30ps_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_30ps_4x)
   {
     SC_THREAD(a1_msffmin_30ps_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_30ps_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_30ps_4x_proc2);
     SC_METHOD(a1_msffmin_30ps_4x_proc4);
     SC_CTHREAD(a1_msffmin_30ps_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_30ps_4x() { }
};
*/

SC_MODULE(cl_a1_msffmin_syrst_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_syrst_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_syrst_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_syrst_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_syrst_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_syrst_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_syrst_1x)
   {
     SC_THREAD(a1_msffmin_syrst_1x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_syrst_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_syrst_1x_proc2);
     SC_METHOD(a1_msffmin_syrst_1x_proc4);
     SC_CTHREAD(a1_msffmin_syrst_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_syrst_1x() { }
};

SC_MODULE(cl_a1_msffmin_syrst_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_syrst_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_syrst_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_syrst_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_syrst_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_syrst_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_syrst_4x)
   {
     SC_THREAD(a1_msffmin_syrst_4x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_syrst_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_syrst_4x_proc2);
     SC_METHOD(a1_msffmin_syrst_4x_proc4);
     SC_CTHREAD(a1_msffmin_syrst_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_syrst_4x() { }
};

SC_MODULE(cl_a1_msffmin_syrst_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_syrst_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_syrst_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_syrst_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_syrst_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_syrst_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_syrst_8x)
   {
     SC_THREAD(a1_msffmin_syrst_8x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_syrst_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_syrst_8x_proc2);
     SC_METHOD(a1_msffmin_syrst_8x_proc4);
     SC_CTHREAD(a1_msffmin_syrst_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_syrst_8x() { }
};

SC_MODULE(cl_a1_msffmin_syrst_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_syrst_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_syrst_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_syrst_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_syrst_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_syrst_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_syrst_16x)
   {
     SC_THREAD(a1_msffmin_syrst_16x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_syrst_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_syrst_16x_proc2);
     SC_METHOD(a1_msffmin_syrst_16x_proc4);
     SC_CTHREAD(a1_msffmin_syrst_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_syrst_16x() { }
};




SC_MODULE(cl_a1_msffmin_syrst_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_syrst_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false) q.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false) q.write(l1);
         else if (l1clk.read() == true &&  
                  siclk.read() == true)
         {
         /* Conflict -- data and scan */
                  l1 = false;
                  q.write(false);
         }
       }
     }  
   }
   
   void a1_msffmin_syrst_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read() & reset.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_syrst_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_syrst_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_msffmin_syrst_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_syrst_32x)
   {
     SC_THREAD(a1_msffmin_syrst_32x_proc0);
     sensitive << l1clk << siclk << d;
     SC_THREAD(a1_msffmin_syrst_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_syrst_32x_proc2);
     SC_METHOD(a1_msffmin_syrst_32x_proc4);
     SC_CTHREAD(a1_msffmin_syrst_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_syrst_32x() { }
};

SC_MODULE(cl_a1_bsac_cell_4x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> ac_test_signal;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_in<bool> updateclk;
  sc_core::sc_in<bool> ac_mode;
  sc_core::sc_out<bool> q;
  sc_core::sc_out<bool> so;
  /* sc_core::sc_signal<bool> l1clk; 
  sc_core::sc_signal<bool> siclk; 
  sc_core::sc_signal<bool> soclk;
  sc_core::sc_signal<bool> updateclk; */
  bool l1;
  bool qm;

  void a1_bsac_cell_4x_proc0()
  {
    while(1)
    {
      wait();
      if (l1clk.read() == false && 
          siclk.read() == false) l1 = d.read();  /* Load master with data*/
      else if (l1clk.read() &&  
             siclk.read()) l1 = si.read(); /* Load master with scan/flush*/
      else if (l1clk.read() == false &&  
               siclk.read() == true) 
       cout<<"Conflict between data and scan"<<endl;
      else if (l1clk.read() == true &&  
               soclk.read() == false) so.write(l1);
                  /* Load slave with master data */
      else if (l1clk.read() == true &&  
               siclk.read() == true && 
               soclk.read() == false) so.write(si.read());  
    }
  }

  void a1_bsac_cell_4x_proc1() 
  {
    while(1)
    {
      wait();
      if(updateclk.read() == true)  qm =l1;
    }
  }

  void a1_bsac_cell_4x_proc2() 
  {
    while(1)
    {
      wait();
      if(ac_mode.read() == false)  q.write(qm);
      /*  else         q=qm ^ ac_test_signal; */
    }
  }

  SC_CTOR(cl_a1_bsac_cell_4x):qm(false)
  {
    SC_THREAD(a1_bsac_cell_4x_proc0);
    sensitive << l1clk << siclk << soclk << d << si;
    SC_THREAD(a1_bsac_cell_4x_proc1);
    sensitive << updateclk;
    SC_THREAD(a1_bsac_cell_4x_proc2);
    sensitive << ac_mode << ac_test_signal;
  }

  ~cl_a1_bsac_cell_4x(){ }
};


    
SC_MODULE(cl_a1_blatch_4x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_out<bool> latout;
  sc_core::sc_out<bool> so;
  sc_core::sc_signal<bool> si_unused;

  bool s;
  bool m;
  bool SCAN_MODE;
  bool FASTFLUSH;
  bool INITLATZERO;

  void a1_blatch_4x_proc0()
  {
    while(1)
    {  
      wait();
      if(SCAN_MODE == true && FASTFLUSH == true)
      {
        if(siclk.read() == true)
        {
          m =  false;  /* pseudo flush reset */
          s =  false;  /* pseudo flush reset */
        }
        else
        {
          m =  d.read();
          s =  d.read();
        }
      }
    }
  }

  void a1_blatch_4x_proc1()
  {
    while(1)
    {  
      wait();
      if(SCAN_MODE == true && FASTFLUSH == false)
      {
        if (l1clk.read() == false && 
            siclk.read() == false)  m = d.read();   
        else if (l1clk.read() == true && 
                 siclk.read() == true) m = si.read(); 
        else if (l1clk.read() == false && 
                 siclk.read() == true) 
        std::cout<<"Conflict between data and scan"<<std::endl;
        else if (l1clk.read() == true && 
                 soclk.read() == false && 
                 siclk.read() == false)  s = m;   
        else if (l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)  s = si.read();
      }
    }
  }

  void a1_blatch_4x_proc2()
  {
    while(1)
    {  
      wait();
      if(SCAN_MODE == false && FASTFLUSH == false)
      {
        si_unused.write(si.read());
      }
    }
  }

  void a1_blatch_4x_proc3()
  {
    while(1)
    {  
      wait();
       if(siclk.read() == false && 
          l1clk.read() == false) m = d.read();
       else if(siclk.read() == true && 
               l1clk.read() == false){ }
       if(siclk.read() == true && 
          l1clk.read() == true) m = si.read();
        if(l1clk.read() == true && 
           soclk.read() == false) s = m;
    }
  }

  void a1_blatch_4x_proc4()
  {
    latout.write(m);
    so.write(s);
  }

  SC_CTOR(cl_a1_blatch_4x)
  {
    SC_THREAD(a1_blatch_4x_proc0);
    sensitive << l1clk.posedge_event() << siclk.posedge_event();
    SC_THREAD(a1_blatch_4x_proc1);
    sensitive << l1clk << siclk << soclk << d << si;
    SC_THREAD(a1_blatch_4x_proc2);
    sensitive << l1clk << d << si << siclk;
    SC_METHOD(a1_blatch_4x_proc3);
    SC_METHOD(a1_blatch_4x_proc4);
  }

  ~cl_a1_blatch_4x(){ }
};
    
 
SC_MODULE(cl_a1_alatch_4x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_in<bool> se;
  sc_core::sc_out<bool> so;
  sc_core::sc_out<bool> q;

  bool l1;
  bool INITLATZERO;

  void a1_alatch_4x_proc0()
  {
    while(1)
    {
      wait();
      if (siclk.read() == true) l1 = si.read(); 
      /* Load master with scan or flush */
      if(se.read() == true && 
         soclk.read() == true && 
         l1clk.read() == true && 
         siclk.read() == true) q.write(si.read());
      else if(se.read() == true && 
              soclk.read() == false && 
              l1clk.read() == true)  q.write(l1);    
      else if(soclk.read() == false && 
              l1clk.read() == true)  q.write(d.read());
    }
  }

  SC_CTOR(cl_a1_alatch_4x)
  {
    if(INITLATZERO == true) q.write(false);
    SC_THREAD(a1_alatch_4x_proc0);
    sensitive << l1clk << siclk << soclk << d << si << se;
  }

  ~cl_a1_alatch_4x(){ }
};
   

SC_MODULE(cl_a1_clken_msff_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> clken;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_clken_msff_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write((d.read() & clken.read()) | 
                      (q.read() & ~clken.read())); 
       }
     }  
   }
   
   void a1_clken_msff_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_clken_msff_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_clken_msff_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read() == false) q.write(d.read());
     }
   }

   void a1_clken_msff_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_clken_msff_4x)
   {
     SC_THREAD(a1_clken_msff_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_clken_msff_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_clken_msff_4x_proc2);
     SC_METHOD(a1_clken_msff_4x_proc4);
     SC_CTHREAD(a1_clken_msff_4x_proc3, l1clk.pos());
   }

   ~cl_a1_clken_msff_4x() { }
};


SC_MODULE(cl_a1_msff_arst_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;
   bool SCAN_MODE;
   bool l1;
 
   void a1_msff_arst_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (reset.read() == true) { l1 = false; q.write(false); }
         else if (l1clk.read() == false && 
                  siclk.read() == false) l1 = d.read();
         else if (l1clk.read() == true && 
                  siclk.read() == true) l1 = si.read();
         else if (l1clk.read() == false && 
                  siclk.read() == true);
         else if (l1clk.read() == true && 
                  siclk.read() == false && 
                  soclk.read() == false)  q.write(l1);
         else if (l1clk.read() == true && 
                  siclk.read() == true && 
                  soclk.read() == false)  q.write(si.read());
       }
     }
   }
 
   void a1_msff_arst_4x_proc1()
   {
     if(SCAN_MODE == false)
     {
       si_unused.write(si.read());
       siclk_unused.write(siclk.read());
       soclk_unused.write(soclk.read());
     }
   }

   void a1_msff_arst_4x_proc2()
   {
     if (reset.read() == false) q.write(false);
     else if (siclk.read() == false && 
              soclk.read() == false ) q.write(d.read());
   }

   SC_CTOR(cl_a1_msff_arst_4x)
   {
     SC_THREAD(a1_msff_arst_4x_proc0);
     sensitive << l1clk << siclk << soclk << d << si << reset;
     SC_THREAD(a1_msff_arst_4x_proc1);
     sensitive << l1clk.posedge_event() << reset.posedge_event();
   }

   ~cl_a1_msff_arst_4x(){ }
};

SC_MODULE(cl_a1_aomux2_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_12x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_12x)
  {
    SC_METHOD(a1_aomux2_12x_proc0);
  }

  ~cl_a1_aomux2_12x(){ }
};

SC_MODULE(cl_a1_aomux2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_16x)
  {
    SC_METHOD(a1_aomux2_16x_proc0);
  }

  ~cl_a1_aomux2_16x(){ }
};


/*SC_MODULE(cl_a1_aomux2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_1x)
  {
    SC_METHOD(a1_aomux2_1x_proc0);
  }

  ~cl_a1_aomux2_1x(){ }
};*/


SC_MODULE(cl_a1_aomux2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_2x)
  {
    SC_METHOD(a1_aomux2_2x_proc0);
  }

  ~cl_a1_aomux2_2x(){ }
};

SC_MODULE(cl_a1_aomux2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_4x)
  {
    SC_METHOD(a1_aomux2_4x_proc0);
  }

  ~cl_a1_aomux2_4x(){ }
};

SC_MODULE(cl_a1_aomux2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_6x)
  {
    SC_METHOD(a1_aomux2_6x_proc0);
  }

  ~cl_a1_aomux2_6x(){ }
};


SC_MODULE(cl_a1_aomux2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | (sel1.read() & in1.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_8x)
  {
    SC_METHOD(a1_aomux2_8x_proc0);
  }

  ~cl_a1_aomux2_8x(){ }
};

/*
SC_MODULE(cl_a1_aomux2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_16x)
  {
    SC_METHOD(a1_aomux2_16x_proc0);
  }

  ~cl_a1_aomux2_16x(){ }
};
*/

SC_MODULE(cl_a1_aomux2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux2_1x)
  {
    SC_METHOD(a1_aomux2_1x_proc0);
  }

  ~cl_a1_aomux2_1x(){ }
};

SC_MODULE(cl_a1_aomux3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux3_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux3_2x)
  {
    SC_METHOD(a1_aomux3_2x_proc0);
  }

  ~cl_a1_aomux3_2x(){ }
};

SC_MODULE(cl_a1_aomux3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux3_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux3_4x)
  {
    SC_METHOD(a1_aomux3_4x_proc0);
  }

  ~cl_a1_aomux3_4x(){ }
};



SC_MODULE(cl_a1_aomux3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux3_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux3_6x)
  {
    SC_METHOD(a1_aomux3_6x_proc0);
  }

  ~cl_a1_aomux3_6x(){ }
};


SC_MODULE(cl_a1_aomux3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux3_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()));
    }
  }

  SC_CTOR(cl_a1_aomux3_8x)
  {
    SC_METHOD(a1_aomux3_8x_proc0);
  }

  ~cl_a1_aomux3_8x(){ }
};


SC_MODULE(cl_a1_aomux4_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_12x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_12x)
  {
    SC_METHOD(a1_aomux4_12x_proc0);
  }

  ~cl_a1_aomux4_12x(){ }
};


SC_MODULE(cl_a1_aomux4_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_16x)
  {
    SC_METHOD(a1_aomux4_16x_proc0);
  }

  ~cl_a1_aomux4_16x(){ }
};

SC_MODULE(cl_a1_aomux4_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_1x)
  {
    SC_METHOD(a1_aomux4_1x_proc0);
  }

  ~cl_a1_aomux4_1x(){ }
};


SC_MODULE(cl_a1_aomux4_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_2x)
  {
    SC_METHOD(a1_aomux4_2x_proc0);
  }

  ~cl_a1_aomux4_2x(){ }
};


SC_MODULE(cl_a1_aomux4_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_4x)
  {
    SC_METHOD(a1_aomux4_4x_proc0);
  }

  ~cl_a1_aomux4_4x(){ }
};


SC_MODULE(cl_a1_aomux4_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_6x)
  {
    SC_METHOD(a1_aomux4_6x_proc0);
  }

  ~cl_a1_aomux4_6x(){ }
};


SC_MODULE(cl_a1_aomux4_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_8x)
  {
    SC_METHOD(a1_aomux4_8x_proc0);
  }

  ~cl_a1_aomux4_8x(){ }
};


SC_MODULE(cl_a1_aomux4_niu_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_niu_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_niu_8x)
  {
    SC_METHOD(a1_aomux4_niu_8x_proc0);
  }

  ~cl_a1_aomux4_niu_8x(){ }
};

/*
SC_MODULE(cl_a1_aomux4_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux4_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux4_8x)
  {
    SC_METHOD(a1_aomux4_8x_proc0);
  }

  ~cl_a1_aomux4_8x(){ }
};
*/

SC_MODULE(cl_a1_aomux5_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_16x)
  {
    SC_METHOD(a1_aomux5_16x_proc0);
  }

  ~cl_a1_aomux5_16x(){ }
};

SC_MODULE(cl_a1_aomux5_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_1x)
  {
    SC_METHOD(a1_aomux5_1x_proc0);
  }

  ~cl_a1_aomux5_1x(){ }
};


SC_MODULE(cl_a1_aomux5_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_2x)
  {
    SC_METHOD(a1_aomux5_2x_proc0);
  }

  ~cl_a1_aomux5_2x(){ }
};


SC_MODULE(cl_a1_aomux5_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_4x)
  {
    SC_METHOD(a1_aomux5_4x_proc0);
  }

  ~cl_a1_aomux5_4x(){ }
};



SC_MODULE(cl_a1_aomux5_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_6x)
  {
    SC_METHOD(a1_aomux5_6x_proc0);
  }

  ~cl_a1_aomux5_6x(){ }
};


SC_MODULE(cl_a1_aomux5_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_8x)
  {
    SC_METHOD(a1_aomux5_8x_proc0);
  }

  ~cl_a1_aomux5_8x(){ }
};


SC_MODULE(cl_a1_aomux5_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux5_12x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()));
    }
  }

  SC_CTOR(cl_a1_aomux5_12x)
  {
    SC_METHOD(a1_aomux5_12x_proc0);
  }

  ~cl_a1_aomux5_12x(){ }
};


SC_MODULE(cl_a1_aomux6_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_16x)
  {
    SC_METHOD(a1_aomux6_16x_proc0);
  }

  ~cl_a1_aomux6_16x(){ }
};

SC_MODULE(cl_a1_aomux6_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_1x)
  {
    SC_METHOD(a1_aomux6_1x_proc0);
  }

  ~cl_a1_aomux6_1x(){ }
};


SC_MODULE(cl_a1_aomux6_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_2x)
  {
    SC_METHOD(a1_aomux6_2x_proc0);
  }

  ~cl_a1_aomux6_2x(){ }
};



SC_MODULE(cl_a1_aomux6_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_4x)
  {
    SC_METHOD(a1_aomux6_4x_proc0);
  }

  ~cl_a1_aomux6_4x(){ }
};




SC_MODULE(cl_a1_aomux6_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_6x)
  {
    SC_METHOD(a1_aomux6_6x_proc0);
  }

  ~cl_a1_aomux6_6x(){ }
};


SC_MODULE(cl_a1_aomux6_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_8x)
  {
    SC_METHOD(a1_aomux6_8x_proc0);
  }

  ~cl_a1_aomux6_8x(){ }
};




SC_MODULE(cl_a1_aomux6_by2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_by2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_by2_1x)
  {
    SC_METHOD(a1_aomux6_by2_1x_proc0);
  }

  ~cl_a1_aomux6_by2_1x(){ }
};

SC_MODULE(cl_a1_aomux6_by2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux6_by2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()));
    }
  }

  SC_CTOR(cl_a1_aomux6_by2_2x)
  {
    SC_METHOD(a1_aomux6_by2_2x_proc0);
  }

  ~cl_a1_aomux6_by2_2x(){ }
};


SC_MODULE(cl_a1_aomux7_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_12x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_12x)
  {
    SC_METHOD(a1_aomux7_12x_proc0);
  }

  ~cl_a1_aomux7_12x(){ }
};


SC_MODULE(cl_a1_aomux7_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_16x)
  {
    SC_METHOD(a1_aomux7_16x_proc0);
  }

  ~cl_a1_aomux7_16x(){ }
};


SC_MODULE(cl_a1_aomux7_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_1x)
  {
    SC_METHOD(a1_aomux7_1x_proc0);
  }

  ~cl_a1_aomux7_1x(){ }
};



SC_MODULE(cl_a1_aomux7_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_2x)
  {
    SC_METHOD(a1_aomux7_2x_proc0);
  }

  ~cl_a1_aomux7_2x(){ }
};



SC_MODULE(cl_a1_aomux7_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_4x)
  {
    SC_METHOD(a1_aomux7_4x_proc0);
  }

  ~cl_a1_aomux7_4x(){ }
};


SC_MODULE(cl_a1_aomux7_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_6x)
  {
    SC_METHOD(a1_aomux7_6x_proc0);
  }

  ~cl_a1_aomux7_6x(){ }
};


SC_MODULE(cl_a1_aomux7_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_8x)
  {
    SC_METHOD(a1_aomux7_8x_proc0);
  }

  ~cl_a1_aomux7_8x(){ }
};


SC_MODULE(cl_a1_aomux7_by2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_by2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_by2_1x)
  {
    SC_METHOD(a1_aomux7_by2_1x_proc0);
  }

  ~cl_a1_aomux7_by2_1x(){ }
};

SC_MODULE(cl_a1_aomux7_by2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux7_by2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()));
    }
  }

  SC_CTOR(cl_a1_aomux7_by2_2x)
  {
    SC_METHOD(a1_aomux7_by2_2x_proc0);
  }

  ~cl_a1_aomux7_by2_2x(){ }
};


SC_MODULE(cl_a1_aomux8_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_12x_proc0()
  {
    while(1)
    {
      wait();
      if(LIB == true)
      {
        out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
      }  
    }
  }

  SC_CTOR(cl_a1_aomux8_12x)
  {
    SC_THREAD(a1_aomux8_12x_proc0);
    sensitive << sel0 << sel1 << sel2 << sel3 << sel4 << sel5 << sel6 << sel7; 
  }

  ~cl_a1_aomux8_12x(){ }
};

SC_MODULE(cl_a1_aomux8_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_16x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_16x)
  {
    SC_METHOD(a1_aomux8_16x_proc0);
  }

  ~cl_a1_aomux8_16x(){ }
};

SC_MODULE(cl_a1_aomux8_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_1x)
  {
    SC_METHOD(a1_aomux8_1x_proc0);
  }

  ~cl_a1_aomux8_1x(){ }
};


SC_MODULE(cl_a1_aomux8_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_2x)
  {
    SC_METHOD(a1_aomux8_2x_proc0);
  }

  ~cl_a1_aomux8_2x(){ }
};

SC_MODULE(cl_a1_aomux8_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_4x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_4x)
  {
    SC_METHOD(a1_aomux8_4x_proc0);
  }

  ~cl_a1_aomux8_4x(){ }
};


SC_MODULE(cl_a1_aomux8_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_6x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_6x)
  {
    SC_METHOD(a1_aomux8_6x_proc0);
  }

  ~cl_a1_aomux8_6x(){ }
};



SC_MODULE(cl_a1_aomux8_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_8x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_8x)
  {
    SC_METHOD(a1_aomux8_8x_proc0);
  }

  ~cl_a1_aomux8_8x(){ }
};


SC_MODULE(cl_a1_aomux8_by2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_by2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_by2_1x)
  {
    SC_METHOD(a1_aomux8_by2_1x_proc0);
  }

  ~cl_a1_aomux8_by2_1x(){ }
};

SC_MODULE(cl_a1_aomux8_by2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;
  sc_core::sc_in<bool> in7;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_in<bool> sel1;
  sc_core::sc_in<bool> sel2;
  sc_core::sc_in<bool> sel3;
  sc_core::sc_in<bool> sel4;
  sc_core::sc_in<bool> sel5;
  sc_core::sc_in<bool> sel6;
  sc_core::sc_in<bool> sel7;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aomux8_by2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write((sel0.read() & in0.read()) | 
                (sel1.read() & in1.read()) |
                (sel2.read() & in2.read()) |
                (sel3.read() & in3.read()) |
                (sel4.read() & in4.read()) |
                (sel5.read() & in5.read()) |
                (sel6.read() & in6.read()) |
                (sel7.read() & in7.read()));
    }
  }

  SC_CTOR(cl_a1_aomux8_by2_2x)
  {
    SC_METHOD(a1_aomux8_by2_2x_proc0);
  }

  ~cl_a1_aomux8_by2_2x(){ }
};

SC_MODULE(cl_a1_l1hdr_12x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_12x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_12x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_12x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_12x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_12x)
   {
     SC_METHOD(a1_l1hdr_12x_proc0);
     SC_THREAD(a1_l1hdr_12x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_12x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_12x_proc3);
   }
   
   ~cl_a1_l1hdr_12x(){ }
};


SC_MODULE(cl_a1_l1hdr_16x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_16x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_16x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_16x)
   {
     SC_METHOD(a1_l1hdr_16x_proc0);
     SC_THREAD(a1_l1hdr_16x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_16x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_16x_proc3);
   }
   
   ~cl_a1_l1hdr_16x(){ }
};

SC_MODULE(cl_a1_l1hdr_24x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_24x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_24x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_24x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_24x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_24x)
   {
     SC_METHOD(a1_l1hdr_24x_proc0);
     SC_THREAD(a1_l1hdr_24x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_24x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_24x_proc3);
   }
   
   ~cl_a1_l1hdr_24x(){ }
};

SC_MODULE(cl_a1_l1hdr_32x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_32x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_32x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_32x)
   {
     SC_METHOD(a1_l1hdr_32x_proc0);
     SC_THREAD(a1_l1hdr_32x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_32x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_32x_proc3);
   }
   
   ~cl_a1_l1hdr_32x(){ }
};

SC_MODULE(cl_a1_l1hdr_4x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_4x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_4x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_4x)
   {
     SC_METHOD(a1_l1hdr_4x_proc0);
     SC_THREAD(a1_l1hdr_4x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_4x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_4x_proc3);
   }
   
   ~cl_a1_l1hdr_4x(){ }
};


SC_MODULE(cl_a1_l1hdr_48x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_48x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_48x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_48x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_48x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_48x)
   {
     SC_METHOD(a1_l1hdr_48x_proc0);
     SC_THREAD(a1_l1hdr_48x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_48x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_48x_proc3);
   }
   
   ~cl_a1_l1hdr_48x(){ }
};


SC_MODULE(cl_a1_l1hdr_64x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_64x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_64x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_64x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_64x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_64x)
   {
     SC_METHOD(a1_l1hdr_64x_proc0);
     SC_THREAD(a1_l1hdr_64x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_64x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_64x_proc3);
   }
   
   ~cl_a1_l1hdr_64x(){ }
};

SC_MODULE(cl_a1_l1hdr_8x)
{
   sc_core::sc_in<bool> l2clk;	/* level 2 clock, from clock grid */
   sc_core::sc_in<bool> se;	/* Scan Enable */
   sc_core::sc_in<bool> pce;    /* Clock enable for local power savings*/
   sc_core::sc_in<bool> pce_ov; /* TCU sourced clock enable override for testing */
   sc_core::sc_in<bool> stop;  /* TCU/CCU sourced clock stop for debug */ 
   sc_core::sc_out<bool> l1clk;
   bool l1en;
   bool FORMAL_TOOL;
   bool LIB;
   bool SCAN_MODE;
  
   void a1_l1hdr_8x_proc0()
   {
     if(FORMAL_TOOL == true && LIB == false)
     {
       l1en = (~stop.read() &  (pce.read() | pce_ov.read()));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void a1_l1hdr_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false)
       {
         l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void a1_l1hdr_8x_proc3()
   {
      l1clk.write((l2clk.read() & l1en) | se.read());
   }

   SC_CTOR(cl_a1_l1hdr_8x)
   {
     SC_METHOD(a1_l1hdr_8x_proc0);
     SC_THREAD(a1_l1hdr_8x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(a1_l1hdr_8x_proc2, l2clk.neg());
     SC_METHOD(a1_l1hdr_8x_proc3);
   }
   
   ~cl_a1_l1hdr_8x(){ }
};


SC_MODULE(cl_a1_msffmin_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_16x)
   {
     SC_THREAD(a1_msffmin_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_16x_proc2);
     SC_METHOD(a1_msffmin_16x_proc4);
     SC_CTHREAD(a1_msffmin_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_16x() { }
};


SC_MODULE(cl_a1_msffmin_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_8x)
   {
     SC_THREAD(a1_msffmin_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_8x_proc2);
     SC_METHOD(a1_msffmin_8x_proc4);
     SC_CTHREAD(a1_msffmin_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_8x() { }
};



SC_MODULE(cl_a1_msffmin_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_4x)
   {
     SC_THREAD(a1_msffmin_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_4x_proc2);
     SC_METHOD(a1_msffmin_4x_proc4);
     SC_CTHREAD(a1_msffmin_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_4x() { }
};


SC_MODULE(cl_a1_msffmin_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_32x)
   {
     SC_THREAD(a1_msffmin_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_32x_proc2);
     SC_METHOD(a1_msffmin_32x_proc4);
     SC_CTHREAD(a1_msffmin_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_32x() { }
};


SC_MODULE(cl_a1_msffmin_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_1x)
   {
     SC_THREAD(a1_msffmin_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_1x_proc2);
     SC_METHOD(a1_msffmin_1x_proc4);
     SC_CTHREAD(a1_msffmin_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_1x() { }
};

SC_MODULE(cl_a1_msffmin_lp_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

  
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffmin_lp_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msffmin_lp_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msffmin_lp_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffmin_lp_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msffmin_lp_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffmin_lp_4x)
   {
     SC_THREAD(a1_msffmin_lp_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffmin_lp_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffmin_lp_4x_proc2);
     SC_METHOD(a1_msffmin_lp_4x_proc4);
     SC_CTHREAD(a1_msffmin_lp_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffmin_lp_4x() { }
};


SC_MODULE(cl_a1_msff_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_16x)
   {
     SC_THREAD(a1_msff_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_16x_proc2);
     SC_METHOD(a1_msff_16x_proc4);
     SC_CTHREAD(a1_msff_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_16x() { }
};

SC_MODULE(cl_a1_msff_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_1x)
   {
     SC_THREAD(a1_msff_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_1x_proc2);
     SC_METHOD(a1_msff_1x_proc4);
     SC_CTHREAD(a1_msff_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_1x() { }
};



SC_MODULE(cl_a1_msff_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_32x)
   {
     SC_THREAD(a1_msff_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_32x_proc2);
     SC_METHOD(a1_msff_32x_proc4);
     SC_CTHREAD(a1_msff_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_32x() { }
};



SC_MODULE(cl_a1_msff_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_4x)
   {
     SC_THREAD(a1_msff_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_4x_proc2);
     SC_METHOD(a1_msff_4x_proc4);
     SC_CTHREAD(a1_msff_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_4x() { }
};


SC_MODULE(cl_a1_msff_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_8x)
   {
     SC_THREAD(a1_msff_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_8x_proc2);
     SC_METHOD(a1_msff_8x_proc4);
     SC_CTHREAD(a1_msff_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_8x() { }
};

SC_MODULE(cl_a1_msff_syrst_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_syrst_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_syrst_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_syrst_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_syrst_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_syrst_1x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_syrst_1x)
   {
     SC_THREAD(a1_msff_syrst_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_syrst_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_syrst_1x_proc2);
     SC_METHOD(a1_msff_syrst_1x_proc4);
     SC_CTHREAD(a1_msff_syrst_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_syrst_1x() { }
};

SC_MODULE(cl_a1_msff_syrst_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_syrst_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_syrst_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_syrst_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_syrst_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_syrst_4x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_syrst_4x)
   {
     SC_THREAD(a1_msff_syrst_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_syrst_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_syrst_4x_proc2);
     SC_METHOD(a1_msff_syrst_4x_proc4);
     SC_CTHREAD(a1_msff_syrst_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_syrst_4x() { }
};


SC_MODULE(cl_a1_msff_syrst_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_syrst_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_syrst_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_syrst_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_syrst_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_syrst_8x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_syrst_8x)
   {
     SC_THREAD(a1_msff_syrst_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_syrst_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_syrst_8x_proc2);
     SC_METHOD(a1_msff_syrst_8x_proc4);
     SC_CTHREAD(a1_msff_syrst_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_syrst_8x() { }
};


SC_MODULE(cl_a1_msff_syrst_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_syrst_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_syrst_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_syrst_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_syrst_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_syrst_16x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_syrst_16x)
   {
     SC_THREAD(a1_msff_syrst_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_syrst_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_syrst_16x_proc2);
     SC_METHOD(a1_msff_syrst_16x_proc4);
     SC_CTHREAD(a1_msff_syrst_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_syrst_16x() { }
};



SC_MODULE(cl_a1_msff_syrst_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   
   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msff_syrst_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q.write(false);
         else q.write(d.read());
       }
     }  
   }
   
   void a1_msff_syrst_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q.write(si.read());
         }
       }
     }
   }

   void a1_msff_syrst_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msff_syrst_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q.write(d.read());
     }
   }

   void a1_msff_syrst_32x_proc4()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msff_syrst_32x)
   {
     SC_THREAD(a1_msff_syrst_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msff_syrst_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msff_syrst_32x_proc2);
     SC_METHOD(a1_msff_syrst_32x_proc4);
     SC_CTHREAD(a1_msff_syrst_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msff_syrst_32x() { }
};


SC_MODULE(cl_a1_msffi_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_16x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_16x)
   {
     SC_THREAD(a1_msffi_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_16x_proc2);
     SC_METHOD(a1_msffi_16x_proc4);
     SC_CTHREAD(a1_msffi_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_16x() { }
};

/*SC_MODULE(cl_a1_msffi_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(liclk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(liclk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(liclk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_16x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_16x)
   {
     SC_THREAD(a1_msffi_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_16x_proc2);
     SC_METHOD(a1_msffi_16x_proc4);
     SC_CTHREAD(a1_msffi_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_16x() { }
};
*/

SC_MODULE(cl_a1_msffi_1x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_1x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_1x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_1x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_1x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_1x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_1x)
   {
     SC_THREAD(a1_msffi_1x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_1x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_1x_proc2);
     SC_METHOD(a1_msffi_1x_proc4);
     SC_CTHREAD(a1_msffi_1x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_1x() { }
};

SC_MODULE(cl_a1_msffi_32x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_32x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_32x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_32x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_32x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_32x)
   {
     SC_THREAD(a1_msffi_32x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_32x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_32x_proc2);
     SC_METHOD(a1_msffi_32x_proc4);
     SC_CTHREAD(a1_msffi_32x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_32x() { }
};



/*SC_MODULE(cl_a1_msffi_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_16x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_16x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_16x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_16x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_16x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_16x)
   {
     SC_THREAD(a1_msffi_16x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_16x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_16x_proc2);
     SC_METHOD(a1_msffi_16x_proc4);
     SC_CTHREAD(a1_msffi_16x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_16x() { }
};*/

SC_MODULE(cl_a1_msffi_4x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_4x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_4x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_4x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_4x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_4x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_4x)
   {
     SC_THREAD(a1_msffi_4x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_4x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_4x_proc2);
     SC_METHOD(a1_msffi_4x_proc4);
     SC_CTHREAD(a1_msffi_4x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_4x() { }
};



SC_MODULE(cl_a1_msffi_8x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_out<bool> q_l;
   sc_core::sc_out<bool> so;
   sc_core::sc_signal<bool> si_unused;
   sc_core::sc_signal<bool> siclk_unused;
   sc_core::sc_signal<bool> soclk_unused;

   bool l1;
   bool SCAN_MODE;
   bool FAST_FLUSH;
   bool INITLATZERO;

   void a1_msffi_8x_proc0()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == true)
       {
         if(siclk.read() == true) q_l.write(false);
         else q_l.write(d.read());
       }
     }  
   }
   
   void a1_msffi_8x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true && FAST_FLUSH == false)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false)
         {
           q_l.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false)
         {
           q_l.write(si.read());
         }
       }
     }
   }

   void a1_msffi_8x_proc2()
   {
     while(1)
     {
       wait(); 
       if(SCAN_MODE == false && FAST_FLUSH == false)
       {
         si_unused.write(si.read());
         siclk_unused.write(siclk.read());
         soclk_unused.write(soclk.read());
       }
     }
   }

   void a1_msffi_8x_proc3()
   {
     while(1)
     {
       wait();
       if (siclk.read() == false && 
             soclk.read()) q_l.write(d.read());
     }
   }

   void a1_msffi_8x_proc4()
   { 
     if(INITLATZERO == false) q_l.write(false);
   }
 
   SC_CTOR(cl_a1_msffi_8x)
   {
     SC_THREAD(a1_msffi_8x_proc0);
     sensitive << l1clk.posedge_event() << siclk.posedge_event();
     SC_THREAD(a1_msffi_8x_proc1);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_METHOD(a1_msffi_8x_proc2);
     SC_METHOD(a1_msffi_8x_proc4);
     SC_CTHREAD(a1_msffi_8x_proc3, l1clk.pos());
   }

   ~cl_a1_msffi_8x() { }
};

/*
SC_MODULE(cl_a1_msffi_16x)
{
   sc_core::sc_in<bool> d;
   sc_core::sc_in<bool> l1clk;
   sc_core::sc_in<bool> si;
   sc_core::sc_in<bool> siclk;
   sc_core::sc_in<bool> soclk;
   sc_core::sc_in<bool> reset;
   sc_core::sc_in<bool> updateclk;
   sc_core::sc_out<bool> q;
   sc_core::sc_out<bool> so;
   
   bool l1;
   bool LIB;
   bool INITLATZERO;
   
   void a1_msffjtag_4x_proc0()
   {
     while(1)
     {
       wait();
       if(LIB == true)
       {
         if(l1clk.read() == false && 
            siclk.read() == false)
         {
           l1 = d.read();
         } 
         else if(l1clk.read() == true && 
                 siclk.read() == true)
         {
           l1 = si.read();
         }
         else if(l1clk.read() == false && 
                 siclk.read() == true)
         {
           cout<<"Data and scan conflict disallowed ..."<<endl;
         }
         if(reset.read() == true) so.write(false);
         else if(l1clk.read() == true && 
                 siclk.read() == false && 
                 soclk.read() == false &&
                 reset.read() == false)
         {
           so.write(l1);
         }
         else if(l1clk.read() == true && 
                 siclk.read() == true && 
                 soclk.read() == false &&
                 reset.read() == false)
         {
           so.write(si.read());
         }
       }
     }
   }

   void a1_msffjtag_4x_proc1()
   {
     while(1)
     {
       wait();
       if(reset.read() == true)  q.write(false);
       else if(updateclk.read() == true)  q.write(l1);
     }
   }

   void a1_msffjtag_4x_proc2()
   { 
     if(INITLATZERO == false) q.write(false);
   }
 
   SC_CTOR(cl_a1_msffjtag_4x)
   {
     SC_THREAD(a1_msffjtag_4x_proc0);
     sensitive << l1clk << siclk << soclk << d << si << reset;
     SC_THREAD(a1_msffjtag_4x_proc1);
     sensitive << updateclk << reset;
     SC_METHOD(a1_msffjtag_4x_proc2);
   }

   ~cl_a1_msffjtag_4x() { }
};
*/

SC_MODULE(cl_a1_clksyncff_4x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_out<bool> q;
  sc_core::sc_out<bool> so;

  sc_core::sc_signal<bool> qlo;
  sc_core::sc_signal<bool> slo;

  cl_a1_msff_4x *xx0;
  cl_a1_msff_4x *xx1;

  SC_CTOR(cl_a1_clksyncff_4x)
  {
    xx0 = new cl_a1_msff_4x("xx0");
    xx1 = new cl_a1_msff_4x("xx1");
    xx0->l1clk(l1clk);
    xx0->d(d);
    xx0->si(si);
    xx0->siclk(siclk);
    xx0->soclk(soclk);
    xx0->q(qlo);
    xx0->so(slo);
      
    xx1->l1clk(l1clk);
    xx1->d(qlo);
    xx1->si(slo);
    xx1->siclk(siclk);
    xx1->soclk(soclk);
    xx1->q(q);
    xx1->so(so);
  }

  ~cl_a1_clksyncff_4x()
  {
    if(xx0 != NULL) { delete(xx0); xx0 = NULL; }
    if(xx1 != NULL) { delete(xx1); xx1 = NULL; }
  }
};

SC_MODULE(cl_a1_bs_cell2_4x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> highz_n;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_in<bool> updateclk;
  sc_core::sc_in<bool> mode;
  sc_core::sc_in<bool> muxd;
  sc_core::sc_out<bool> q;
  sc_core::sc_out<bool> so;
  bool l1;
  bool qm;

  void a1_bs_cell2_4x_proc0()
  {
    while(1)
    {
      wait();
      if (l1clk.read() == false && siclk.read() == false) l1 = d.read();
      if (l1clk.read() == true && siclk.read() == true)   l1 = si.read();
      if (l1clk.read() == false && siclk.read() == false)
        cout <<"Data and scan conflict disallowed ..."<<endl;
      if (l1clk.read() == true &&  soclk.read() == false) so = l1;
      if (l1clk.read() == true && 
          siclk.read() == true && 
          soclk.read() == true) so.write(si.read());
    }
  }
  
  void a1_bs_cell2_4x_proc1()
  {
    while(1)
    {
      wait();
      if(updateclk.read() == true) qm = l1;
    }
  }

  void a1_bs_cell2_4x_proc2()
  {
    while(1)
    {
      wait();
      if(mode.read() == false)  
        q.write(qm == true && highz_n.read() == true);
      else q.write(muxd.read());
    }
  }

  SC_CTOR(cl_a1_bs_cell2_4x)
  {
    SC_THREAD(a1_bs_cell2_4x_proc0);
    sensitive << l1clk << siclk << soclk << d << si;
    SC_THREAD(a1_bs_cell2_4x_proc1);
    sensitive << updateclk;
    SC_THREAD(a1_bs_cell2_4x_proc2);
    sensitive << mode << muxd << highz_n;
  }

  ~cl_a1_bs_cell2_4x() { }
};

SC_MODULE(cl_a1_clk_buf_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_16x)
  {
    SC_METHOD(a1_clk_buf_16x_proc0);
  }

  ~cl_a1_clk_buf_16x(){ }
};

SC_MODULE(cl_a1_clk_buf_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_20x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_20x)
  {
    SC_METHOD(a1_clk_buf_20x_proc0);
  }

  ~cl_a1_clk_buf_20x(){ }
};

SC_MODULE(cl_a1_clk_buf_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_24x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_24x)
  {
    SC_METHOD(a1_clk_buf_24x_proc0);
  }

  ~cl_a1_clk_buf_24x(){ }
};

SC_MODULE(cl_a1_clk_buf_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_32x)
  {
    SC_METHOD(a1_clk_buf_32x_proc0);
  }

  ~cl_a1_clk_buf_32x(){ }
};

SC_MODULE(cl_a1_clk_buf_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_48x)
  {
    SC_METHOD(a1_clk_buf_48x_proc0);
  }

  ~cl_a1_clk_buf_48x(){ }
};


SC_MODULE(cl_a1_clk_buf_64x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_64x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_64x)
  {
    SC_METHOD(a1_clk_buf_64x_proc0);
  }

  ~cl_a1_clk_buf_64x(){ }
};

SC_MODULE(cl_a1_clk_buf_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_buf_8x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_clk_buf_8x)
  {
    SC_METHOD(a1_clk_buf_8x_proc0);
  }

  ~cl_a1_clk_buf_8x(){ }
};

SC_MODULE(cl_a1_clk_inv_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_16x_proc0()
  {
    while(1)
    { 
      wait();
      if(LIB == true) out.write(!(in.read()));
    }
  }

  SC_CTOR(cl_a1_clk_inv_16x)
  {
    SC_THREAD(a1_clk_inv_16x_proc0);
    sensitive << in;
  }

  ~cl_a1_clk_inv_16x(){ }
};

/*SC_MODULE(cl_a1_clk_inv_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_20x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_20x)
  {
    SC_METHOD(a1_clk_inv_20x_proc0);
  }

  ~cl_a1_clk_inv_20x(){ }
};*/

SC_MODULE(cl_a1_clk_inv_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_20x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_20x)
  {
    SC_METHOD(a1_clk_inv_20x_proc0);
  }

  ~cl_a1_clk_inv_20x(){ }
};
 
SC_MODULE(cl_a1_clk_inv_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_32x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_32x)
  {
    SC_METHOD(a1_clk_inv_32x_proc0);
  }

  ~cl_a1_clk_inv_32x(){ }
};


SC_MODULE(cl_a1_clk_inv_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_48x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_48x)
  {
    SC_METHOD(a1_clk_inv_48x_proc0);
  }

  ~cl_a1_clk_inv_48x(){ }
};

SC_MODULE(cl_a1_clk_inv_64x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_64x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_64x)
  {
    SC_METHOD(a1_clk_inv_64x_proc0);
  }

  ~cl_a1_clk_inv_64x(){ }
};

SC_MODULE(cl_a1_clk_inv_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_inv_8x_proc0()
  {
    if(LIB == true) out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_clk_inv_8x)
  {
    SC_METHOD(a1_clk_inv_8x_proc0);
  }

  ~cl_a1_clk_inv_8x(){ }
};


SC_MODULE(cl_a1_clk_mux2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_mux2_16x_proc0()
  {
    while(1)
    {
      wait();
      if(sel0.read() == true) out.write(in0.read());
      else if(sel0.read() == false) out.write(in1.read());
    }
  }

  SC_CTOR(cl_a1_clk_mux2_16x)
  {
    SC_THREAD(a1_clk_mux2_16x_proc0);
    sensitive << sel0 << in0 << in1;
  }

  ~cl_a1_clk_mux2_16x(){ }
};

SC_MODULE(cl_a1_clk_mux2_24x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_mux2_24x_proc0()
  {
    while(1)
    {
      wait();
      if(sel0.read() == true) out.write(in0.read());
      else if(sel0.read() == false) out.write(in1.read());
    }
  }

  SC_CTOR(cl_a1_clk_mux2_24x)
  {
    SC_THREAD(a1_clk_mux2_24x_proc0);
    sensitive << sel0 << in0 << in1;
  }

  ~cl_a1_clk_mux2_24x(){ }
};


SC_MODULE(cl_a1_clk_mux2_32x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_mux2_32x_proc0()
  {
    while(1)
    {
      wait();
      if(sel0.read() == true) out.write(in0.read());
      else if(sel0.read() == false) out.write(in1.read());
    }
  }

  SC_CTOR(cl_a1_clk_mux2_32x)
  {
    SC_THREAD(a1_clk_mux2_32x_proc0);
    sensitive << sel0 << in0 << in1;
  }

  ~cl_a1_clk_mux2_32x(){ }
};

SC_MODULE(cl_a1_clk_mux2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> sel0;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_clk_mux2_8x_proc0()
  {
    while(1)
    {
      wait();
      if(sel0.read() == true) out.write(in0.read());
      else if(sel0.read() == false) out.write(in1.read());
    }
  }

  SC_CTOR(cl_a1_clk_mux2_8x)
  {
    SC_THREAD(a1_clk_mux2_8x_proc0);
    sensitive << sel0 << in0 << in1;
  }

  ~cl_a1_clk_mux2_8x(){ }
};

SC_MODULE(cl_a1_aoi12_12x)
{
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in10;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_12x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_12x)
  {
    SC_METHOD(a1_aoi12_12x_proc0);
  }
  
  ~cl_a1_aoi12_12x() { }
};

SC_MODULE(cl_a1_aoi12_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_16x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_16x)
  {
    SC_METHOD(a1_aoi12_16x_proc0);
  }
  
  ~cl_a1_aoi12_16x() { }
};



SC_MODULE(cl_a1_aoi12_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_1x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_1x)
  {
    SC_METHOD(a1_aoi12_1x_proc0);
  }
  
  ~cl_a1_aoi12_1x() { }
};

SC_MODULE(cl_a1_aoi12_2x)
{
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in10;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_2x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_2x)
  {
    SC_METHOD(a1_aoi12_2x_proc0);
  }
  
  ~cl_a1_aoi12_2x() { }
};


SC_MODULE(cl_a1_aoi12_4x)
{
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in10;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_4x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_4x)
  {
    SC_METHOD(a1_aoi12_4x_proc0);
  }
  
  ~cl_a1_aoi12_4x() { }
};


SC_MODULE(cl_a1_aoi12_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi12_8x_proc0()
  {
    out.write(~(( in10.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi12_8x)
  {
    SC_METHOD(a1_aoi12_8x_proc0);
  }
  
  ~cl_a1_aoi12_8x() { }
};

SC_MODULE(cl_a1_aoi21_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_12x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_12x)
  {
    SC_METHOD(a1_aoi21_12x_proc0);
  }
  
  ~cl_a1_aoi21_12x() { }
};

SC_MODULE(cl_a1_aoi21_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_16x_proc0()
  {
    out.write(~((in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_16x)
  {
    SC_METHOD(a1_aoi21_16x_proc0);
  }
  
  ~cl_a1_aoi21_16x() { }
};

SC_MODULE(cl_a1_aoi21_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_1x_proc0()
  {
    out.write(~((in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_1x)
  {
    SC_METHOD(a1_aoi21_1x_proc0);
  }
  
  ~cl_a1_aoi21_1x() { }
};

SC_MODULE(cl_a1_aoi21_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_2x_proc0()
  {
    out.write(~((in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_2x)
  {
    SC_METHOD(a1_aoi21_2x_proc0);
  }
  
  ~cl_a1_aoi21_2x() { }
};

SC_MODULE(cl_a1_aoi21_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_4x_proc0()
  {
    out.write(~((in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_4x)
  {
    SC_METHOD(a1_aoi21_4x_proc0);
  }
  
  ~cl_a1_aoi21_4x() { }
};

SC_MODULE(cl_a1_aoi21_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi21_8x_proc0()
  {
    out.write(~((in10.read() & in11.read() ) | in01.read()));
  }

  SC_CTOR(cl_a1_aoi21_8x)
  {
    SC_METHOD(a1_aoi21_8x_proc0);
  }
  
  ~cl_a1_aoi21_8x() { }
};


SC_MODULE(cl_a1_aoi22_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi22_12x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi22_12x)
  {
    SC_METHOD(a1_aoi22_12x_proc0);
  }
  
  ~cl_a1_aoi22_12x() { }
};

SC_MODULE(cl_a1_aoi22_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi22_1x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi22_1x)
  {
    SC_METHOD(a1_aoi22_1x_proc0);
  }
  
  ~cl_a1_aoi22_1x() { }
};

SC_MODULE(cl_a1_aoi22_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi22_2x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi22_2x)
  {
    SC_METHOD(a1_aoi22_2x_proc0);
  }
  
  ~cl_a1_aoi22_2x() { }
};

SC_MODULE(cl_a1_aoi22_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi22_4x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi22_4x)
  {
    SC_METHOD(a1_aoi22_4x_proc0);
  }
  
  ~cl_a1_aoi22_4x() { }
};

SC_MODULE(cl_a1_aoi22_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in00;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi22_8x_proc0()
  {
    out.write(~(( in10.read() & in11.read() ) | ( in00.read() & in01.read() )));
  }

  SC_CTOR(cl_a1_aoi22_8x)
  {
    SC_METHOD(a1_aoi22_8x_proc0);
  }
  
  ~cl_a1_aoi22_8x() { }
};

SC_MODULE(cl_a1_aoi33_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi33_1x_proc0()
  {
    out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
  }

  SC_CTOR(cl_a1_aoi33_1x)
  {
    SC_METHOD(a1_aoi33_1x_proc0);
  }
  
  ~cl_a1_aoi33_1x() { }
};

SC_MODULE(cl_a1_aoi33_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi33_2x_proc0()
  {
    out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
  }

  SC_CTOR(cl_a1_aoi33_2x)
  {
    SC_METHOD(a1_aoi33_2x_proc0);
  }
  
  ~cl_a1_aoi33_2x() { }
};


SC_MODULE(cl_a1_aoi33_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi33_4x_proc0()
  {
    out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
  }

  SC_CTOR(cl_a1_aoi33_4x)
  {
    SC_METHOD(a1_aoi33_4x_proc0);
  }
  
  ~cl_a1_aoi33_4x() { }
};


SC_MODULE(cl_a1_aoi33_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in11;
  sc_core::sc_in<bool> in12;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in02;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_aoi33_8x_proc0()
  {
    out.write(~(( in10.read() & in11.read() & in12.read() ) | ( in00.read() & in01.read() & in02.read() )));
  }

  SC_CTOR(cl_a1_aoi33_8x)
  {
    SC_METHOD(a1_aoi33_8x_proc0);
  }
  
  ~cl_a1_aoi33_8x() { }
};

SC_MODULE(cl_a1_rep_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_32x)
  {
    SC_METHOD(a1_rep_32x_proc0);
  }

  ~cl_a1_rep_32x(){ }
};

SC_MODULE(cl_a1_rep_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_40x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_40x)
  {
    SC_METHOD(a1_rep_40x_proc0);
  }

  ~cl_a1_rep_40x(){ }
};

SC_MODULE(cl_a1_rep_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_24x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_24x)
  {
    SC_METHOD(a1_rep_24x_proc0);
  }

  ~cl_a1_rep_24x(){ }
};

SC_MODULE(cl_a1_rep_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_16x)
  {
    SC_METHOD(a1_rep_16x_proc0);
  }

  ~cl_a1_rep_16x(){ }
};

SC_MODULE(cl_a1_rep_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_8x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_8x)
  {
    SC_METHOD(a1_rep_8x_proc0);
  }

  ~cl_a1_rep_8x(){ }
};

SC_MODULE(cl_a1_rep_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_48x)
  {
    SC_METHOD(a1_rep_48x_proc0);
  }

  ~cl_a1_rep_48x(){ }
};

SC_MODULE(cl_a1_rep_dcp2x_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp2x_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp2x_32x)
  {
    SC_METHOD(a1_rep_dcp2x_32x_proc0);
  }

  ~cl_a1_rep_dcp2x_32x(){ }
};

SC_MODULE(cl_a1_rep_dcp2x_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp2x_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp2x_16x)
  {
    SC_METHOD(a1_rep_dcp2x_16x_proc0);
  }

  ~cl_a1_rep_dcp2x_16x(){ }
};



SC_MODULE(cl_a1_rep_dcp2x_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp2x_24x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp2x_24x)
  {
    SC_METHOD(a1_rep_dcp2x_24x_proc0);
  }

  ~cl_a1_rep_dcp2x_24x(){ }
};


SC_MODULE(cl_a1_rep_dcp2x_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp2x_40x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp2x_40x)
  {
    SC_METHOD(a1_rep_dcp2x_40x_proc0);
  }

  ~cl_a1_rep_dcp2x_40x(){ }
};

SC_MODULE(cl_a1_rep_dcp2x_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp2x_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp2x_48x)
  {
    SC_METHOD(a1_rep_dcp2x_48x_proc0);
  }

  ~cl_a1_rep_dcp2x_48x(){ }
};

SC_MODULE(cl_a1_rep_dcp_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_32x)
  {
    SC_METHOD(a1_rep_dcp_32x_proc0);
  }

  ~cl_a1_rep_dcp_32x(){ }
};


/*SC_MODULE(cl_a1_rep_dcp_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_16x)
  {
    SC_METHOD(a1_rep_dcp_16x_proc0);
  }

  ~cl_a1_rep_dcp_16x(){ }
}; */


SC_MODULE(cl_a1_rep_dcp_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_16x)
  {
    SC_METHOD(a1_rep_dcp_16x_proc0);
  }

  ~cl_a1_rep_dcp_16x(){ }
};

SC_MODULE(cl_a1_rep_dcp_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_24x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_24x)
  {
    SC_METHOD(a1_rep_dcp_24x_proc0);
  }

  ~cl_a1_rep_dcp_24x(){ }
};

SC_MODULE(cl_a1_rep_dcp_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_40x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_40x)
  {
    SC_METHOD(a1_rep_dcp_40x_proc0);
  }

  ~cl_a1_rep_dcp_40x(){ }
};

SC_MODULE(cl_a1_rep_dcp_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp_48x)
  {
    SC_METHOD(a1_rep_dcp_48x_proc0);
  }

  ~cl_a1_rep_dcp_48x(){ }
};

SC_MODULE(cl_a1_rep_dcp50k_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp50k_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp50k_48x)
  {
    SC_METHOD(a1_rep_dcp50k_48x_proc0);
  }

  ~cl_a1_rep_dcp50k_48x(){ }
};

SC_MODULE(cl_a1_rep_dcp50k_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp50k_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp50k_32x)
  {
    SC_METHOD(a1_rep_dcp50k_32x_proc0);
  }

  ~cl_a1_rep_dcp50k_32x(){ }
};

SC_MODULE(cl_a1_rep_dcp50k_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_rep_dcp50k_40x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_rep_dcp50k_40x)
  {
    SC_METHOD(a1_rep_dcp50k_40x_proc0);
  }

  ~cl_a1_rep_dcp50k_40x(){ }
};

SC_MODULE(cl_a1_buf_12x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_12x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_12x)
  {
    SC_METHOD(a1_buf_12x_proc0);
  }

  ~cl_a1_buf_12x(){ }
};

SC_MODULE(cl_a1_buf_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_16x)
  {
    SC_METHOD(a1_buf_16x_proc0);
  }

  ~cl_a1_buf_16x(){ }
};


SC_MODULE(cl_a1_buf_1x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_1x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_1x)
  {
    SC_METHOD(a1_buf_1x_proc0);
  }

  ~cl_a1_buf_1x(){ }
};


SC_MODULE(cl_a1_buf_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_20x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_20x)
  {
    SC_METHOD(a1_buf_20x_proc0);
  }

  ~cl_a1_buf_20x(){ }
};

SC_MODULE(cl_a1_buf_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_24x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_24x)
  {
    SC_METHOD(a1_buf_24x_proc0);
  }

  ~cl_a1_buf_24x(){ }
};




SC_MODULE(cl_a1_buf_28x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_28x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_28x)
  {
    SC_METHOD(a1_buf_28x_proc0);
  }

  ~cl_a1_buf_28x(){ }
};

SC_MODULE(cl_a1_buf_2x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_2x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_2x)
  {
    SC_METHOD(a1_buf_2x_proc0);
  }

  ~cl_a1_buf_2x(){ }
};

SC_MODULE(cl_a1_buf_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_32x)
  {
    SC_METHOD(a1_buf_32x_proc0);
  }

  ~cl_a1_buf_32x(){ }
};

SC_MODULE(cl_a1_buf_36x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_36x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_36x)
  {
    SC_METHOD(a1_buf_36x_proc0);
  }

  ~cl_a1_buf_36x(){ }
};

SC_MODULE(cl_a1_buf_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_40x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_40x)
  {
    SC_METHOD(a1_buf_40x_proc0);
  }

  ~cl_a1_buf_40x(){ }
};

SC_MODULE(cl_a1_buf_44x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_44x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_44x)
  {
    SC_METHOD(a1_buf_44x_proc0);
  }

  ~cl_a1_buf_44x(){ }
};

SC_MODULE(cl_a1_buf_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_48x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_48x)
  {
    SC_METHOD(a1_buf_48x_proc0);
  }

  ~cl_a1_buf_48x(){ }
};

SC_MODULE(cl_a1_buf_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_4x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_4x)
  {
    SC_METHOD(a1_buf_4x_proc0);
  }

  ~cl_a1_buf_4x(){ }
};

SC_MODULE(cl_a1_buf_56x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_56x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_56x)
  {
    SC_METHOD(a1_buf_56x_proc0);
  }

  ~cl_a1_buf_56x(){ }
};

SC_MODULE(cl_a1_buf_64x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_64x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_64x)
  {
    SC_METHOD(a1_buf_64x_proc0);
  }

  ~cl_a1_buf_64x(){ }
};

SC_MODULE(cl_a1_buf_6x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_6x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_6x)
  {
    SC_METHOD(a1_buf_6x_proc0);
  }

  ~cl_a1_buf_6x(){ }
};

SC_MODULE(cl_a1_buf_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_buf_8x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_buf_8x)
  {
    SC_METHOD(a1_buf_8x_proc0);
  }

  ~cl_a1_buf_8x(){ }
};

SC_MODULE(cl_a1_bufmin_1x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_bufmin_1x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_bufmin_1x)
  {
    SC_METHOD(a1_bufmin_1x_proc0);
  }

  ~cl_a1_bufmin_1x(){ }
};

SC_MODULE(cl_a1_bufmin_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_bufmin_4x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_bufmin_4x)
  {
    SC_METHOD(a1_bufmin_4x_proc0);
  }

  ~cl_a1_bufmin_4x(){ }
};


SC_MODULE(cl_a1_bufmin_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_bufmin_8x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_bufmin_8x)
  {
    SC_METHOD(a1_bufmin_8x_proc0);
  }

  ~cl_a1_bufmin_8x(){ }
};

SC_MODULE(cl_a1_bufmin_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_bufmin_16x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_bufmin_16x)
  {
    SC_METHOD(a1_bufmin_16x_proc0);
  }

  ~cl_a1_bufmin_16x(){ }
};

SC_MODULE(cl_a1_bufmin_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_bufmin_32x_proc0()
  {
    if(LIB == true) out.write(in.read());
  }

  SC_CTOR(cl_a1_bufmin_32x)
  {
    SC_METHOD(a1_bufmin_32x_proc0);
  }

  ~cl_a1_bufmin_32x(){ }
};

SC_MODULE(cl_a1_csa32_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> carry;
  sc_core::sc_out<bool> sum;
  bool LIB;

  void a1_csa32_16x_proc0()
  {
    if(LIB == true) 
    {
      carry.write((in0.read() & in1.read()) | (in0.read() & in2.read()) | (in1.read() & in2.read()));
      sum.write((in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_csa32_16x)
  {
    SC_METHOD(a1_csa32_16x_proc0);
  }

  ~cl_a1_csa32_16x(){ }
};

SC_MODULE(cl_a1_csa32_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> carry;
  sc_core::sc_out<bool> sum;
  bool LIB;

  void a1_csa32_4x_proc0()
  {
    if(LIB == true) 
    {
      carry.write((in0.read() & in1.read()) | (in0.read() & in2.read()) | (in1.read() & in2.read()));
      sum.write((in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_csa32_4x)
  {
    SC_METHOD(a1_csa32_4x_proc0);
  }

  ~cl_a1_csa32_4x(){ }
};


SC_MODULE(cl_a1_inv_12x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_12x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_12x)
  {
    SC_METHOD(a1_inv_12x_proc0);
  }

  ~cl_a1_inv_12x() { }
};

SC_MODULE(cl_a1_inv_16x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_16x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_16x)
  {
    SC_METHOD(a1_inv_16x_proc0);
  }

  ~cl_a1_inv_16x() { }
};  

SC_MODULE(cl_a1_inv_1x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_1x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_1x)
  {
    SC_METHOD(a1_inv_1x_proc0);
  }

  ~cl_a1_inv_1x() { }
};

SC_MODULE(cl_a1_inv_20x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_20x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_20x)
  {
    SC_METHOD(a1_inv_20x_proc0);
  }

  ~cl_a1_inv_20x() { }
};


SC_MODULE(cl_a1_inv_24x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_24x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_24x)
  {
    SC_METHOD(a1_inv_24x_proc0);
  }

  ~cl_a1_inv_24x() { }
};

SC_MODULE(cl_a1_inv_28x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_28x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_28x)
  {
    SC_METHOD(a1_inv_28x_proc0);
  }

  ~cl_a1_inv_28x() { }
};

SC_MODULE(cl_a1_inv_2x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_2x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_2x)
  {
    SC_METHOD(a1_inv_2x_proc0);
  }

  ~cl_a1_inv_2x() { }
};

SC_MODULE(cl_a1_inv_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_32x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_32x)
  {
    SC_METHOD(a1_inv_32x_proc0);
  }

  ~cl_a1_inv_32x() { }
};

SC_MODULE(cl_a1_inv_36x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_36x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_36x)
  {
    SC_METHOD(a1_inv_36x_proc0);
  }

  ~cl_a1_inv_36x() { }
};

SC_MODULE(cl_a1_inv_40x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_40x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_40x)
  {
    SC_METHOD(a1_inv_40x_proc0);
  }

  ~cl_a1_inv_40x() { }
};


SC_MODULE(cl_a1_inv_44x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_44x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_44x)
  {
    SC_METHOD(a1_inv_44x_proc0);
  }

  ~cl_a1_inv_44x() { }
};

SC_MODULE(cl_a1_inv_48x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_48x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_48x)
  {
    SC_METHOD(a1_inv_48x_proc0);
  }

  ~cl_a1_inv_48x() { }
};

SC_MODULE(cl_a1_inv_4x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_4x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_4x)
  {
    SC_METHOD(a1_inv_4x_proc0);
  }

  ~cl_a1_inv_4x() { }
};

SC_MODULE(cl_a1_inv_56x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_56x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_56x)
  {
    SC_METHOD(a1_inv_56x_proc0);
  }

  ~cl_a1_inv_56x() { }
};


SC_MODULE(cl_a1_inv_64x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_64x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_64x)
  {
    SC_METHOD(a1_inv_64x_proc0);
  }

  ~cl_a1_inv_64x() { }
};

SC_MODULE(cl_a1_inv_6x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_6x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_6x)
  {
    SC_METHOD(a1_inv_6x_proc0);
  }

  ~cl_a1_inv_6x() { }
};

SC_MODULE(cl_a1_inv_8x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_inv_8x_proc0()
  {
    out.write(~(in.read()));
  }

  SC_CTOR(cl_a1_inv_8x)
  {
    SC_METHOD(a1_inv_8x_proc0);
  }

  ~cl_a1_inv_8x() { }
};

SC_MODULE(cl_a1_nand2_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_12x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_12x)
  {
    SC_METHOD(a1_nand2_12x_proc0);
  }

  ~cl_a1_nand2_12x() { }
};

SC_MODULE(cl_a1_nand2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_16x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_16x)
  {
    SC_METHOD(a1_nand2_16x_proc0);
  }

  ~cl_a1_nand2_16x() { }
};


SC_MODULE(cl_a1_nand2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_1x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_1x)
  {
    SC_METHOD(a1_nand2_1x_proc0);
  }

  ~cl_a1_nand2_1x() { }
};

SC_MODULE(cl_a1_nand2_20x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_20x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_20x)
  {
    SC_METHOD(a1_nand2_20x_proc0);
  }

  ~cl_a1_nand2_20x() { }
};

SC_MODULE(cl_a1_nand2_24x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_24x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_24x)
  {
    SC_METHOD(a1_nand2_24x_proc0);
  }

  ~cl_a1_nand2_24x() { }
};

SC_MODULE(cl_a1_nand2_28x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_28x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_28x)
  {
    SC_METHOD(a1_nand2_28x_proc0);
  }

  ~cl_a1_nand2_28x() { }
};

SC_MODULE(cl_a1_nand2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_2x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_2x)
  {
    SC_METHOD(a1_nand2_2x_proc0);
  }

  ~cl_a1_nand2_2x() { }
};

SC_MODULE(cl_a1_nand2_32x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_32x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_32x)
  {
    SC_METHOD(a1_nand2_32x_proc0);
  }

  ~cl_a1_nand2_32x() { }
};


SC_MODULE(cl_a1_nand2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_4x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_4x)
  {
    SC_METHOD(a1_nand2_4x_proc0);
  }

  ~cl_a1_nand2_4x() { }
};

SC_MODULE(cl_a1_nand2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_6x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_6x)
  {
    SC_METHOD(a1_nand2_6x_proc0);
  }

  ~cl_a1_nand2_6x() { }
};


SC_MODULE(cl_a1_nand2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand2_8x_proc0()
  {
    out.write(~(in0.read() & in1.read()));
  }

  SC_CTOR(cl_a1_nand2_8x)
  {
    SC_METHOD(a1_nand2_8x_proc0);
  }

  ~cl_a1_nand2_8x() { }
};

SC_MODULE(cl_a1_nand3_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_12x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_12x)
  {
    SC_METHOD(a1_nand3_12x_proc0);
  }

  ~cl_a1_nand3_12x() { }
};

SC_MODULE(cl_a1_nand3_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_16x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_16x)
  {
    SC_METHOD(a1_nand3_16x_proc0);
  }

  ~cl_a1_nand3_16x() { }
};


SC_MODULE(cl_a1_nand3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_1x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_1x)
  {
    SC_METHOD(a1_nand3_1x_proc0);
  }

  ~cl_a1_nand3_1x() { }
};

SC_MODULE(cl_a1_nand3_20x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_20x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_20x)
  {
    SC_METHOD(a1_nand3_20x_proc0);
  }

  ~cl_a1_nand3_20x() { }
};

SC_MODULE(cl_a1_nand3_24x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_24x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_24x)
  {
    SC_METHOD(a1_nand3_24x_proc0);
  }

  ~cl_a1_nand3_24x() { }
};

SC_MODULE(cl_a1_nand3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_2x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_2x)
  {
    SC_METHOD(a1_nand3_2x_proc0);
  }

  ~cl_a1_nand3_2x() { }
};


SC_MODULE(cl_a1_nand3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_4x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_4x)
  {
    SC_METHOD(a1_nand3_4x_proc0);
  }

  ~cl_a1_nand3_4x() { }
};


SC_MODULE(cl_a1_nand3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_6x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_6x)
  {
    SC_METHOD(a1_nand3_6x_proc0);
  }

  ~cl_a1_nand3_6x() { }
};

SC_MODULE(cl_a1_nand3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand3_8x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read()));
  }

  SC_CTOR(cl_a1_nand3_8x)
  {
    SC_METHOD(a1_nand3_8x_proc0);
  }

  ~cl_a1_nand3_8x() { }
};

SC_MODULE(cl_a1_nand4_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_12x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_12x)
  {
    SC_METHOD(a1_nand4_12x_proc0);
  }

  ~cl_a1_nand4_12x() { }
};

SC_MODULE(cl_a1_nand4_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_16x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_16x)
  {
    SC_METHOD(a1_nand4_16x_proc0);
  }

  ~cl_a1_nand4_16x() { }
};

SC_MODULE(cl_a1_nand4_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_1x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_1x)
  {
    SC_METHOD(a1_nand4_1x_proc0);
  }

  ~cl_a1_nand4_1x() { }
};

SC_MODULE(cl_a1_nand4_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_2x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_2x)
  {
    SC_METHOD(a1_nand4_2x_proc0);
  }

  ~cl_a1_nand4_2x() { }
};


SC_MODULE(cl_a1_nand4_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_4x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_4x)
  {
    SC_METHOD(a1_nand4_4x_proc0);
  }

  ~cl_a1_nand4_4x() { }
};

SC_MODULE(cl_a1_nand4_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_6x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_6x)
  {
    SC_METHOD(a1_nand4_6x_proc0);
  }

  ~cl_a1_nand4_6x() { }
};

SC_MODULE(cl_a1_nand4_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_out<bool> out;
  bool LIB;
  
  void a1_nand4_8x_proc0()
  {
    out.write(~(in0.read() & in1.read() & in2.read() & in3.read()));
  }

  SC_CTOR(cl_a1_nand4_8x)
  {
    SC_METHOD(a1_nand4_8x_proc0);
  }

  ~cl_a1_nand4_8x() { }
};

SC_MODULE(cl_a1_nor2_12x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_12x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_12x)
  {
    SC_METHOD(a1_nor2_12x_proc0);
  }

  ~cl_a1_nor2_12x() { }
};

SC_MODULE(cl_a1_nor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_16x)
  {
    SC_METHOD(a1_nor2_16x_proc0);
  }

  ~cl_a1_nor2_16x() { }
};


SC_MODULE(cl_a1_nor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_1x)
  {
    SC_METHOD(a1_nor2_1x_proc0);
  }

  ~cl_a1_nor2_1x() { }
};

SC_MODULE(cl_a1_nor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_2x)
  {
    SC_METHOD(a1_nor2_2x_proc0);
  }

  ~cl_a1_nor2_2x() { }
};

SC_MODULE(cl_a1_nor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_4x)
  {
    SC_METHOD(a1_nor2_4x_proc0);
  }

  ~cl_a1_nor2_4x() { }
};


SC_MODULE(cl_a1_nor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_6x)
  {
    SC_METHOD(a1_nor2_6x_proc0);
  }

  ~cl_a1_nor2_6x() { }
};


SC_MODULE(cl_a1_nor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_nor2_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor2_8x)
  {
    SC_METHOD(a1_nor2_8x_proc0);
  }

  ~cl_a1_nor2_8x() { }
};

SC_MODULE(cl_a1_nor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void cl_a1_nor3_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read() | in2.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor3_1x)
  {
    SC_METHOD(cl_a1_nor3_1x_proc0);
  }

  ~cl_a1_nor3_1x() { }
};

SC_MODULE(cl_a1_nor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void cl_a1_nor3_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read() | in2.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor3_2x)
  {
    SC_METHOD(cl_a1_nor3_2x_proc0);
  }

  ~cl_a1_nor3_2x() { }
};

SC_MODULE(cl_a1_nor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void cl_a1_nor3_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() | in1.read() | in2.read()));
    }
  }
 
  SC_CTOR(cl_a1_nor3_4x)
  {
    SC_METHOD(cl_a1_nor3_4x_proc0);
  }

  ~cl_a1_nor3_4x() { }
};

SC_MODULE(cl_a1_oai12_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_12x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_12x)
  {
    SC_METHOD(a1_oai12_12x_proc0);
  }

  ~cl_a1_oai12_12x(){ }
};

SC_MODULE(cl_a1_oai12_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_16x)
  {
    SC_METHOD(a1_oai12_16x_proc0);
  }

  ~cl_a1_oai12_16x(){ }
};

SC_MODULE(cl_a1_oai12_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_1x)
  {
    SC_METHOD(a1_oai12_1x_proc0);
  }

  ~cl_a1_oai12_1x(){ }
};

SC_MODULE(cl_a1_oai12_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_2x)
  {
    SC_METHOD(a1_oai12_2x_proc0);
  }

  ~cl_a1_oai12_2x(){ }
};

SC_MODULE(cl_a1_oai12_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_4x)
  {
    SC_METHOD(a1_oai12_4x_proc0);
  }

  ~cl_a1_oai12_4x(){ }
};

SC_MODULE(cl_a1_oai12_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai12_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai12_8x)
  {
    SC_METHOD(a1_oai12_8x_proc0);
  }

  ~cl_a1_oai12_8x(){ }
};

SC_MODULE(cl_a1_oai21_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_12x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_12x)
  {
    SC_METHOD(a1_oai21_12x_proc0);
  }

  ~cl_a1_oai21_12x(){ }
};

SC_MODULE(cl_a1_oai21_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_16x)
  {
    SC_METHOD(a1_oai21_16x_proc0);
  }

  ~cl_a1_oai21_16x(){ }
};


SC_MODULE(cl_a1_oai21_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_1x)
  {
    SC_METHOD(a1_oai21_1x_proc0);
  }

  ~cl_a1_oai21_1x(){ }
};

SC_MODULE(cl_a1_oai21_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_2x)
  {
    SC_METHOD(a1_oai21_2x_proc0);
  }

  ~cl_a1_oai21_2x(){ }
};

SC_MODULE(cl_a1_oai21_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_4x)
  {
    SC_METHOD(a1_oai21_4x_proc0);
  }

  ~cl_a1_oai21_4x(){ }
};

SC_MODULE(cl_a1_oai21_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai21_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~((in10.read() |  in00.read()) & in01.read() ));
    }
  }

  SC_CTOR(cl_a1_oai21_8x)
  {
    SC_METHOD(a1_oai21_8x_proc0);
  }

  ~cl_a1_oai21_8x(){ }
};

SC_MODULE(cl_a1_oai22_12x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_12x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_12x)
  {
    SC_METHOD(a1_oai22_12x_proc0);
  }

  ~cl_a1_oai22_12x(){ }
};


SC_MODULE(cl_a1_oai22_16x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_16x)
  {
    SC_METHOD(a1_oai22_16x_proc0);
  }

  ~cl_a1_oai22_16x(){ }
};


SC_MODULE(cl_a1_oai22_1x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_1x)
  {
    SC_METHOD(a1_oai22_1x_proc0);
  }

  ~cl_a1_oai22_1x(){ }
};

SC_MODULE(cl_a1_oai22_2x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_2x)
  {
    SC_METHOD(a1_oai22_2x_proc0);
  }

  ~cl_a1_oai22_2x(){ }
};

SC_MODULE(cl_a1_oai22_4x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_4x)
  {
    SC_METHOD(a1_oai22_4x_proc0);
  }

  ~cl_a1_oai22_4x(){ }
};

SC_MODULE(cl_a1_oai22_8x)
{
  sc_core::sc_in<bool> in10;
  sc_core::sc_in<bool> in00;
  sc_core::sc_in<bool> in01;
  sc_core::sc_in<bool> in11;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_oai22_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(( in10.read() | in11.read() ) & ( in00.read() | in01.read() )));
    }
  }

  SC_CTOR(cl_a1_oai22_8x)
  {
    SC_METHOD(a1_oai22_8x_proc0);
  }

  ~cl_a1_oai22_8x(){ }
};

SC_MODULE(cl_a1_xnor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_16x)
  {
    SC_METHOD(a1_xnor2_16x_proc0);
  }

  ~cl_a1_xnor2_16x(){ }
};

SC_MODULE(cl_a1_xnor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_1x)
  {
    SC_METHOD(a1_xnor2_1x_proc0);
  }

  ~cl_a1_xnor2_1x(){ }
};

SC_MODULE(cl_a1_xnor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_2x)
  {
    SC_METHOD(a1_xnor2_2x_proc0);
  }

  ~cl_a1_xnor2_2x(){ }
};

SC_MODULE(cl_a1_xnor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_4x)
  {
    SC_METHOD(a1_xnor2_4x_proc0);
  }

  ~cl_a1_xnor2_4x(){ }
};

SC_MODULE(cl_a1_xnor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_6x)
  {
    SC_METHOD(a1_xnor2_6x_proc0);
  }

  ~cl_a1_xnor2_6x(){ }
};

SC_MODULE(cl_a1_xnor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor2_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read()));
    }
  }

  SC_CTOR(cl_a1_xnor2_8x)
  {
    SC_METHOD(a1_xnor2_8x_proc0);
  }

  ~cl_a1_xnor2_8x(){ }
};

SC_MODULE(cl_a1_xnor3_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_16x)
  {
    SC_METHOD(a1_xnor3_16x_proc0);
  }

  ~cl_a1_xnor3_16x(){ }
};

SC_MODULE(cl_a1_xnor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_1x)
  {
    SC_METHOD(a1_xnor3_1x_proc0);
  }

  ~cl_a1_xnor3_1x(){ }
};


SC_MODULE(cl_a1_xnor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_2x)
  {
    SC_METHOD(a1_xnor3_2x_proc0);
  }

  ~cl_a1_xnor3_2x(){ }
};

SC_MODULE(cl_a1_xnor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_4x)
  {
    SC_METHOD(a1_xnor3_4x_proc0);
  }

  ~cl_a1_xnor3_4x(){ }
};

SC_MODULE(cl_a1_xnor3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_6x)
  {
    SC_METHOD(a1_xnor3_6x_proc0);
  }

  ~cl_a1_xnor3_6x(){ }
};

SC_MODULE(cl_a1_xnor3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xnor3_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(~(in0.read() ^ in1.read() ^ in2.read()));
    }
  }

  SC_CTOR(cl_a1_xnor3_8x)
  {
    SC_METHOD(a1_xnor3_8x_proc0);
  }

  ~cl_a1_xnor3_8x(){ }
};

SC_MODULE(cl_a1_xor2_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read());
    }
  }

  SC_CTOR(cl_a1_xor2_16x)
  {
    SC_METHOD(a1_xor2_16x_proc0);
  }

  ~cl_a1_xor2_16x(){ }
};

SC_MODULE(cl_a1_xor2_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor2_1x)
  {
    SC_METHOD(a1_xor2_1x_proc0);
  }

  ~cl_a1_xor2_1x(){ }
};


SC_MODULE(cl_a1_xor2_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor2_2x)
  {
    SC_METHOD(a1_xor2_2x_proc0);
  }

  ~cl_a1_xor2_2x(){ }
};


SC_MODULE(cl_a1_xor2_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor2_4x)
  {
    SC_METHOD(a1_xor2_4x_proc0);
  }

  ~cl_a1_xor2_4x(){ }
};

SC_MODULE(cl_a1_xor2_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor2_6x)
  {
    SC_METHOD(a1_xor2_6x_proc0);
  }

  ~cl_a1_xor2_6x(){ }
};

SC_MODULE(cl_a1_xor2_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor2_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read());
    }
  }

  SC_CTOR(cl_a1_xor2_8x)
  {
    SC_METHOD(a1_xor2_8x_proc0);
  }

  ~cl_a1_xor2_8x(){ }
};

SC_MODULE(cl_a1_xor3_16x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_16x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_16x)
  {
    SC_METHOD(a1_xor3_16x_proc0);
  }

  ~cl_a1_xor3_16x(){ }
};

SC_MODULE(cl_a1_xor3_1x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_1x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_1x)
  {
    SC_METHOD(a1_xor3_1x_proc0);
  }

  ~cl_a1_xor3_1x(){ }
};

SC_MODULE(cl_a1_xor3_2x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_2x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_2x)
  {
    SC_METHOD(a1_xor3_2x_proc0);
  }

  ~cl_a1_xor3_2x(){ }
};

SC_MODULE(cl_a1_xor3_4x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_4x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_4x)
  {
    SC_METHOD(a1_xor3_4x_proc0);
  }

  ~cl_a1_xor3_4x(){ }
};

SC_MODULE(cl_a1_xor3_6x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_6x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_6x)
  {
    SC_METHOD(a1_xor3_6x_proc0);
  }

  ~cl_a1_xor3_6x(){ }
};

SC_MODULE(cl_a1_xor3_8x)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_out<bool> out;
  bool LIB;

  void a1_xor3_8x_proc0()
  {
    if(LIB == true)
    {
      out.write(in0.read() ^ in1.read() ^ in2.read());
    }
  }

  SC_CTOR(cl_a1_xor3_8x)
  {
    SC_METHOD(a1_xor3_8x_proc0);
  }

  ~cl_a1_xor3_8x(){ }
};


SC_MODULE(cl_a1_muxprotect_2x)
{
  sc_core::sc_in<bool> d0;
  sc_core::sc_in<bool> d1;
  sc_core::sc_in<bool> d2;
  sc_core::sc_in<bool> d3;
  sc_core::sc_in<bool> scan_en;
  sc_core::sc_out<bool> e0;
  sc_core::sc_out<bool> e1;
  sc_core::sc_out<bool> e2;
  sc_core::sc_out<bool> e3;
  bool LIB;

  void a1_muxprotect_2x_proc0()
  {
    if(LIB == true)
    {
      e0.write((scan_en.read() | d0.read()));
      e1.write((~scan_en.read() & d1.read()));
      e2.write((~scan_en.read() & d2.read()));
      e3.write((~scan_en.read() & d3.read()));
    }
  }

  SC_CTOR(cl_a1_muxprotect_2x)
  {
    SC_METHOD(a1_muxprotect_2x_proc0);
  }

  ~cl_a1_muxprotect_2x(){ }
};


/*
module cl_a1_add64_8x (
cin,
in0,
in1,
out,
cout
);
input 	       cin;
input 	[63:0] in0;
input 	[63:0] in1;
output 	[63:0] out;
output 	       cout;

`ifdef LIB
  assign {cout, out[63:0]} = ({1'b0, in0[63:0]} + {1'b0, in1[63:0]} + {{64{1'b0}}, cin});
`endif

endmodule
*/

#endif






