#ifndef N2_FLOP_BANK_CUST_H
#define N2_FLOP_BANK_CUST_H

#include <systemc>

SC_MODULE(cl_u1_buf_32x)
{
  sc_core::sc_in<bool> in;
  sc_core::sc_out<bool>	out;

  void u1_buf_32x_proc0()
  {
    out.write(in.read());
  }
  
  SC_CTOR(cl_u1_buf_32x)
  { 
    SC_THREAD(u1_buf_32x_proc0);
    sensitive << in; 
  }
  ~cl_u1_buf_32x(){ }
};

SC_MODULE(cl_sc1_l1hdr_32x)
{
   sc_core::sc_in < bool > l2clk; 
   sc_core::sc_in < bool > se; 
   sc_core::sc_in < bool > pce;  
   sc_core::sc_in < bool > pce_ov; 
   sc_core::sc_in < bool > stop; 
   sc_core::sc_out < bool > l1clk;
   bool FORMAL_TOOL;
   bool SCAN_MODE;
   
   bool l1en;

   void sc1_l1hdr_32x_proc0()
   {
     if(FORMAL_TOOL == true)
     {
       l1en = (!(stop.read()) & ( pce.read() | pce_ov.read() ));
       l1clk.write((l2clk.read() & l1en) | se.read());
     }
   }

   void sc1_l1hdr_32x_proc1()
   {
     while(1)
     {
       wait();
       if(SCAN_MODE == true)
       {
         if (l2clk.read() == false) 
          l1en = (~(stop.read()) & (pce.read() | pce_ov.read()));
       }
     }
   }

   void sc1_l1hdr_32x_proc2()
   {
     if(SCAN_MODE == false)
     {
       l1en = (!(stop.read()) & ( pce.read() | pce_ov.read() ));
     }
   }
  
   void sc1_l1hdr_32x_proc3()
   {
     l1clk.write((l2clk.read() & l1en) | se.read());
   }  

   SC_CTOR(cl_sc1_l1hdr_32x)
   {
     SC_METHOD(sc1_l1hdr_32x_proc0);
     SC_METHOD(sc1_l1hdr_32x_proc3);
     SC_THREAD(sc1_l1hdr_32x_proc1);
     sensitive << l2clk << stop << pce << pce_ov;
     SC_CTHREAD(sc1_l1hdr_32x_proc2, l2clk.neg());
   }
   
   ~cl_sc1_l1hdr_32x(){ }
};

SC_MODULE(cl_sc1_msff_8x)
{
  sc_core::sc_in<bool> d;
  sc_core::sc_in<bool> l1clk;
  sc_core::sc_in<bool> si;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in<bool> soclk;
  sc_core::sc_out<bool> q;
  sc_core::sc_out<bool> so;
  
  bool l1;
  bool si_unused;
  bool siclk_unused;
  bool soclk_unused;
  bool FAST_FLUSH;
  bool SCAN_MODE;
  bool INITLATZERO;

  void cl_sc1_msff_8x_proc0()
  {
    if(SCAN_MODE == true && INITLATZERO == true)
    {
      l1 = false;
    }
  }

  void cl_sc1_msff_8x_proc1()
  {
    while(1)
    {
      wait();
      if(SCAN_MODE == true && FAST_FLUSH == true)
      {
        if(siclk.read() == true) q.write(false);
        else q.write(d.read());
      }
     }
   }

   void cl_sc1_msff_8x_proc2()
   {
    while(1)
    {
      wait();
      if(SCAN_MODE == true && FAST_FLUSH == false)
      {
        if(l1clk.read() == false && 
           siclk.read() == false) l1 = d.read();    
        else if(l1clk.read() == true && 
                siclk.read() == true) l1 = si.read(); 
        else if(l1clk.read() == false && 
                siclk.read() == true) l1 = false;  
        else if(l1clk.read() == true && 
                siclk.read() == false && 
                soclk.read() == false)  q.write(l1); 
        if(l1clk.read() == true && 
           siclk.read() == true && 
           soclk.read() == true) q.write(si.read());  
      
      }
     }
   }

   void cl_sc1_msff_8x_proc3()
   {
     if(SCAN_MODE == false && FAST_FLUSH == false)
      {
        si_unused = si.read();
        siclk_unused = siclk.read();
        soclk_unused = soclk.read();
      }
   }

   void cl_sc1_msff_8x_proc4()
   {
     while(1)
     {
       wait();
        if(siclk.read() == false && 
           soclk.read() == false) q.write(d.read());
        else q.write(false);
      }
   }

   SC_CTOR(cl_sc1_msff_8x)
   {
     SC_METHOD(cl_sc1_msff_8x_proc0);
     SC_METHOD(cl_sc1_msff_8x_proc3);
     SC_THREAD(cl_sc1_msff_8x_proc1);
     sensitive << l1clk.pos() << siclk.pos();
     SC_THREAD(cl_sc1_msff_8x_proc2);
     sensitive << l1clk << siclk << soclk << d << si;
     SC_THREAD(cl_sc1_msff_8x_proc4);
     sensitive << l1clk.pos();
   }

   ~cl_sc1_msff_8x(){ }
};


SC_MODULE(n2_flop_bank_cust)
{
  sc_core::sc_in<bool> l2clk;		
  sc_core::sc_in<bool> scan_in;
  sc_core::sc_in<bool> tcu_aclk;
  sc_core::sc_in<bool> tcu_bclk;
  sc_core::sc_in<bool> tcu_scan_en;
  sc_core::sc_in<bool> tcu_pce_ov;
  sc_core::sc_in<bool> local_stop;
  sc_core::sc_in< sc_dt::sc_bv<16> > data_in;
  
  sc_core::sc_out<bool> scan_out;
  sc_core::sc_out< sc_dt::sc_bv<16> > data_out;
  
  sc_core::sc_signal<bool> siclk;
  sc_core::sc_signal<bool> soclk;
  sc_core::sc_signal<bool> se;
  sc_core::sc_signal<bool> pce_ov;
  sc_core::sc_signal<bool> l1clk;
  sc_core::sc_signal<bool> datain_ff_scanin;
  sc_core::sc_signal<bool> datain_ff_scanout;
  sc_core::sc_signal<bool> true_sig;

  sc_dt::sc_bv<16> data_in_tmp;
  sc_dt::sc_bv<16> data_out_tmp;
 
  sc_core::sc_signal<bool> fdin0;
  sc_core::sc_signal<bool> fdin1;
  sc_core::sc_signal<bool> fdin2;
  sc_core::sc_signal<bool> fdin3;
  sc_core::sc_signal<bool> fdin4;
  sc_core::sc_signal<bool> fdin5;
  sc_core::sc_signal<bool> fdin6;
  sc_core::sc_signal<bool> fdin7;
  sc_core::sc_signal<bool> fdin8;
  sc_core::sc_signal<bool> fdin9;
  sc_core::sc_signal<bool> fdin10;
  sc_core::sc_signal<bool> fdin11;
  sc_core::sc_signal<bool> fdin12;
  sc_core::sc_signal<bool> fdin13;
  sc_core::sc_signal<bool> fdin14;

  sc_core::sc_signal<bool> fo0;
  sc_core::sc_signal<bool> fo1;
  sc_core::sc_signal<bool> fo2;
  sc_core::sc_signal<bool> fo3;
  sc_core::sc_signal<bool> fo4;
  sc_core::sc_signal<bool> fo5;
  sc_core::sc_signal<bool> fo6;
  sc_core::sc_signal<bool> fo7;
  sc_core::sc_signal<bool> fo8;
  sc_core::sc_signal<bool> fo9;
  sc_core::sc_signal<bool> fo10;
  sc_core::sc_signal<bool> fo11;
  sc_core::sc_signal<bool> fo12;
  sc_core::sc_signal<bool> fo13;
  sc_core::sc_signal<bool> fo14;
  sc_core::sc_signal<bool> fo15;

  sc_core::sc_signal<bool> dins0;
  sc_core::sc_signal<bool> dins1;
  sc_core::sc_signal<bool> dins2;
  sc_core::sc_signal<bool> dins3;
  sc_core::sc_signal<bool> dins4;
  sc_core::sc_signal<bool> dins5;
  sc_core::sc_signal<bool> dins6;
  sc_core::sc_signal<bool> dins7;
  sc_core::sc_signal<bool> dins8;
  sc_core::sc_signal<bool> dins9;
  sc_core::sc_signal<bool> dins10;
  sc_core::sc_signal<bool> dins11;
  sc_core::sc_signal<bool> dins12;
  sc_core::sc_signal<bool> dins13;
  sc_core::sc_signal<bool> dins14;
  sc_core::sc_signal<bool> dins15;

  sc_core::sc_signal<bool> dos0;
  sc_core::sc_signal<bool> dos1;
  sc_core::sc_signal<bool> dos2;
  sc_core::sc_signal<bool> dos3;
  sc_core::sc_signal<bool> dos4;
  sc_core::sc_signal<bool> dos5;
  sc_core::sc_signal<bool> dos6;
  sc_core::sc_signal<bool> dos7;
  sc_core::sc_signal<bool> dos8;
  sc_core::sc_signal<bool> dos9;
  sc_core::sc_signal<bool> dos10;
  sc_core::sc_signal<bool> dos11;
  sc_core::sc_signal<bool> dos12;
  sc_core::sc_signal<bool> dos13;
  sc_core::sc_signal<bool> dos14;
  sc_core::sc_signal<bool> dos15;

  bool din0;
  bool din1;
  bool din2;
  bool din3;
  bool din4;
  bool din5;
  bool din6;
  bool din7;
  bool din8;
  bool din9;
  bool din10;
  bool din11;
  bool din12;
  bool din13;
  bool din14;
  bool din15;
  
  bool do0;
  bool do1;
  bool do2;
  bool do3;
  bool do4;
  bool do5;
  bool do6;
  bool do7;
  bool do8;
  bool do9;
  bool do10;
  bool do11;
  bool do12;
  bool do13;
  bool do14;
  bool do15;

  void n2_flop_bank_cust_proc0()
  {
      se.write(tcu_scan_en.read());
      pce_ov.write(tcu_pce_ov.read());
      data_in_tmp = data_in.read();
      din0 = data_in_tmp[0] == "1" ? true : false;
      din1 = data_in_tmp[1] == "1" ? true : false;
      din2 = data_in_tmp[2] == "1" ? true : false;
      din3 = data_in_tmp[3] == "1" ? true : false;
      din4 = data_in_tmp[4] == "1" ? true : false;
      din5 = data_in_tmp[5] == "1" ? true : false;
      din6 = data_in_tmp[6] == "1" ? true : false;
      din7 = data_in_tmp[7] == "1" ? true : false;
      din8 = data_in_tmp[8] == "1" ? true : false;
      din9 = data_in_tmp[9] == "1" ? true : false;
      din10 = data_in_tmp[10] == "1" ? true : false;
      din11 = data_in_tmp[11] == "1" ? true : false;
      din12 = data_in_tmp[12] == "1" ? true : false;
      din13 = data_in_tmp[13] == "1" ? true : false;
      din14 = data_in_tmp[14] == "1" ? true : false;
      din15 = data_in_tmp[15] == "1" ? true : false;
      
      dins0.write(din0);
      dins1.write(din1);
      dins2.write(din2);
      dins3.write(din3);
      dins4.write(din4);
      dins5.write(din5);
      dins6.write(din6);
      dins7.write(din7);
      dins8.write(din8);
      dins9.write(din9);
      dins10.write(din10);
      dins11.write(din11);
      dins12.write(din12);
      dins13.write(din13);
      dins14.write(din14);
      dins15.write(din15);
      
      do0 = dos0.read();
      do1 = dos1.read();
      do2 = dos2.read();
      do3 = dos3.read();
      do4 = dos4.read();
      do5 = dos5.read();
      do6 = dos6.read();
      do7 = dos7.read();
      do8 = dos8.read();
      do9 = dos9.read();
      do10 = dos10.read();
      do11 = dos11.read();
      do12 = dos12.read();
      do13 = dos13.read();
      do14 = dos14.read();
      do15 = dos15.read();    
      
      data_out_tmp[0] = do0 == true ? "1" : "0";
      data_out_tmp[1] = do1 == true ? "1" : "0";
      data_out_tmp[2] = do2 == true ? "1" : "0";
      data_out_tmp[3] = do3 == true ? "1" : "0";
      data_out_tmp[4] = do4 == true ? "1" : "0";
      data_out_tmp[5] = do5 == true ? "1" : "0";
      data_out_tmp[6] = do6 == true ? "1" : "0";
      data_out_tmp[7] = do7 == true ? "1" : "0";
      data_out_tmp[8] = do8 == true ? "1" : "0";
      data_out_tmp[9] = do9 == true ? "1" : "0";
      data_out_tmp[10] = do10 == true ? "1" : "0";
      data_out_tmp[11] = do11 == true ? "1" : "0";
      data_out_tmp[12] = do13 == true ? "1" : "0";
      data_out_tmp[14] = do14 == true ? "1" : "0";
      data_out_tmp[15] = do15 == true ? "1" : "0";
      data_out.write(data_out_tmp);
  }
  
  cl_u1_buf_32x buf_0_;
  cl_u1_buf_32x buf_1_;
  cl_u1_buf_32x buf_2_;
  cl_u1_buf_32x buf_3_;
  cl_u1_buf_32x buf_4_;
  cl_u1_buf_32x buf_5_;
  cl_u1_buf_32x buf_6_;
  cl_u1_buf_32x buf_7_;
  cl_u1_buf_32x buf_8_;
  cl_u1_buf_32x buf_9_;
  cl_u1_buf_32x buf_10_;
  cl_u1_buf_32x buf_11_;
  cl_u1_buf_32x buf_12_;
  cl_u1_buf_32x buf_13_;
  cl_u1_buf_32x buf_14_;
  cl_u1_buf_32x buf_15_;
  
  cl_sc1_l1hdr_32x c_0;
  cl_sc1_msff_8x d0_0;
  cl_sc1_msff_8x d0_1;
  cl_sc1_msff_8x d0_2;
  cl_sc1_msff_8x d0_3;
  cl_sc1_msff_8x d0_4;
  cl_sc1_msff_8x d0_5;
  cl_sc1_msff_8x d0_6;
  cl_sc1_msff_8x d0_7;
  cl_sc1_msff_8x d0_8;
  cl_sc1_msff_8x d0_9;
  cl_sc1_msff_8x d0_10;
  cl_sc1_msff_8x d0_11;
  cl_sc1_msff_8x d0_12;
  cl_sc1_msff_8x d0_13;
  cl_sc1_msff_8x d0_14;
  cl_sc1_msff_8x d0_15;
  
  SC_CTOR(n2_flop_bank_cust):buf_0_("buf_0_"), buf_1_("buf_1_"),
                             buf_2_("buf_2_"), buf_3_("buf_3_"), 
                             buf_4_("buf_4_"), buf_5_("buf_5_"), 
                             buf_6_("buf_6_"), buf_7_("buf_7_"), 
                             buf_8_("buf_8_"), buf_9_("buf_9_"), 
                             buf_10_("buf_10_"), buf_11_("buf_11_"),
                             buf_12_("buf_12_"), buf_13_("buf_13_"),
                             buf_14_("buf_14_"), buf_15_("buf_15_"), 
                             c_0("c_0"), d0_0("d0_0"), d0_1("d0_1"), 
                             d0_2("d0_2"), d0_3("d0_3"), d0_4("d0_4"), 
                             d0_5("d0_5"), d0_6("d0_6"), d0_7("d0_7"), 
                             d0_8("d0_8"), d0_9("d0_9"), d0_10("d0_10"),
                             d0_11("d0_11"), d0_12("d0_12"), 
                             d0_13("d0_13"), d0_14("d0_14"), 
                             d0_15("d0_15")
  {
    buf_15_.in(fo15); 
    buf_15_.out(dos15);
    
    buf_14_.in(fo14);
    buf_14_.out(dos14);

    buf_13_.in(fo13);
    buf_13_.out(dos13);

    buf_12_.in(fo12);
    buf_12_.out(dos12);
    
    buf_11_.in(fo11); 
    buf_11_.out(dos11);
    
    buf_10_.in(fo10);
    buf_10_.out(dos10);
    
    buf_9_.in(fo9); 
    buf_9_.out(dos9);

    buf_8_.in(fo8);
    buf_8_.out(dos8);

    buf_7_.in(fo7);
    buf_7_.out(dos7);

    buf_6_.in(fo6); 
    buf_6_.out(dos6);
    
    buf_5_.in(fo5);
    buf_5_.out(dos5);

    buf_4_.in(fo4);
    buf_4_.out(dos4);

    buf_3_.in(fo3);
    buf_3_.out(dos3);

    buf_2_.in(fo2); 
    buf_2_.out(dos2);

    buf_1_.in(fo1);
    buf_1_.out(dos1);
    
    buf_0_.in(fo0); 
    buf_0_.out(dos0);
    
    c_0.l2clk(l2clk);
    c_0.pce(true_sig);
    c_0.l1clk(l1clk);
    c_0.se(se);
    c_0.pce_ov(pce_ov);
    c_0.stop(local_stop);
    /*c_0.FORMAL_TOOL = false;
    c_0.SCAN_MODE = true; */

    d0_0.l1clk(l1clk);
    d0_0.siclk(tcu_aclk);
    d0_0.soclk(tcu_bclk);
    d0_0.d(dins0);
    d0_0.q(fo0);
    d0_0.si(scan_in);
    d0_0.so(fdin0);
    /* d0_0.SCAN_MODE = true; */

    d0_1.l1clk(l1clk);
    d0_1.siclk(tcu_aclk);
    d0_1.soclk(tcu_bclk);
    d0_1.d(dins1);
    d0_1.q(fo1);
    d0_1.si(fdin0);
    d0_1.so(fdin1);
    /* d0_1.SCAN_MODE = true; */

    d0_2.l1clk(l1clk);
    d0_2.siclk(tcu_aclk);
    d0_2.soclk(tcu_bclk);
    d0_2.d(dins2);
    d0_2.q(fo2);
    d0_2.si(fdin1);
    d0_2.so(fdin2);
    /* d0_2.SCAN_MODE = true; */

    d0_3.l1clk(l1clk);
    d0_3.siclk(tcu_aclk);
    d0_3.soclk(tcu_bclk);
    d0_3.d(dins3);
    d0_3.q(fo3);
    d0_3.si(fdin2);
    d0_3.so(fdin3);
    /* d0_3.SCAN_MODE = true; */

    d0_4.l1clk(l1clk);
    d0_4.siclk(tcu_aclk);
    d0_4.soclk(tcu_bclk);
    d0_4.d(dins4);
    d0_4.q(fo4);
    d0_4.si(fdin3);
    d0_4.so(fdin4);

    d0_5.l1clk(l1clk);
    d0_5.siclk(tcu_aclk);
    d0_5.soclk(tcu_bclk);
    d0_5.d(dins5);
    d0_5.q(fo5);
    d0_5.si(fdin4);
    d0_5.so(fdin5);

    d0_6.l1clk(l1clk);
    d0_6.siclk(tcu_aclk);
    d0_6.soclk(tcu_bclk);
    d0_6.d(dins6);
    d0_6.q(fo6);
    d0_6.si(fdin5);
    d0_6.so(fdin6);

    d0_7.l1clk(l1clk);
    d0_7.siclk(tcu_aclk);
    d0_7.soclk(tcu_bclk);
    d0_7.d(dins7);
    d0_7.q(fo7);
    d0_7.si(fdin6);
    d0_7.so(fdin7);

    d0_8.l1clk(l1clk);
    d0_8.siclk(tcu_aclk);
    d0_8.soclk(tcu_bclk);
    d0_8.d(dins8);
    d0_8.q(fo8);
    d0_8.si(fdin7);
    d0_8.so(fdin8);

    d0_9.l1clk(l1clk);
    d0_9.siclk(tcu_aclk);
    d0_9.soclk(tcu_bclk);
    d0_9.d(dins9);
    d0_9.q(fo9);
    d0_9.si(fdin8);
    d0_9.so(fdin9);

    d0_10.l1clk(l1clk);
    d0_10.siclk(tcu_aclk);
    d0_10.soclk(tcu_bclk);
    d0_10.d(dins10);
    d0_10.q(fo10);
    d0_10.si(fdin9);
    d0_10.so(fdin10);

    d0_11.l1clk(l1clk);
    d0_11.siclk(tcu_aclk);
    d0_11.soclk(tcu_bclk);
    d0_11.d(dins11);
    d0_11.q(fo11);
    d0_11.si(fdin10);
    d0_11.so(fdin11);

    d0_12.l1clk(l1clk);
    d0_12.siclk(tcu_aclk);
    d0_12.soclk(tcu_bclk);
    d0_12.d(dins12);
    d0_12.q(fo12);
    d0_12.si(fdin11);
    d0_12.so(fdin12);

    d0_13.l1clk(l1clk);
    d0_13.siclk(tcu_aclk);
    d0_13.soclk(tcu_bclk);
    d0_13.d(dins13);
    d0_13.q(fo13);
    d0_13.si(fdin12);
    d0_13.so(fdin13);

    d0_14.l1clk(l1clk);
    d0_14.siclk(tcu_aclk);
    d0_14.soclk(tcu_bclk);
    d0_14.d(dins14);
    d0_14.q(fo14);
    d0_14.si(fdin13);
    d0_14.so(fdin14);

    d0_15.l1clk(l1clk);
    d0_15.siclk(tcu_aclk);
    d0_15.soclk(tcu_bclk);
    d0_15.d(dins15);
    d0_15.q(fo15);
    d0_15.si(fdin14);
    d0_15.so(scan_out);
    /*
    SC_THREAD(n2_flop_bank_cust_proc0);
    sensitive << l2clk.pos();
    */

    SC_METHOD(n2_flop_bank_cust_proc0);
    std::cout<<"Constructed ..."<<std::endl;
  }

  ~n2_flop_bank_cust() { std::cout<<"Destructed ..."<<std::endl; }

};

#endif

