#ifndef N2_STB_CM_64X45_ARRAY_H
#define N2_STB_CM_64X45_ARRAY_H

#include <systemc>

SC_MODULE(n2_stb_cm_64x45_array)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> cam_ldq ; /* quad-ld cam. */
  sc_core::sc_in<bool> tcu_array_wr_inhibit;
  sc_core::sc_in<bool> siclk;
  sc_core::sc_in< sc_dt::sc_bv<3> > cam_rw_ptr ; 
  /* wr pointer for single port. */
  sc_core::sc_in< sc_dt::sc_bv<3> > cam_rw_tid ; 
  /* thread id for rw. */
  sc_core::sc_in<bool> wptr_vld ; /* write pointer vld */
  sc_core::sc_in<bool> rptr_vld ; /* read pointer vld */
  sc_core::sc_in< sc_dt::sc_bv<45> > camwr_data ; 
  /* data for compare/write */
  sc_core::sc_in<bool> cam_vld ; /* cam is required. */
  sc_core::sc_in< sc_dt::sc_bv<3> > cam_cm_tid ; 
  /* thread id for cam operation.*/
  sc_core::sc_in< sc_dt::sc_bv<8> > cam_line_en; 
  /* mask for squashing cam */


  sc_core::sc_signal< sc_dt::sc_bv<6> > rw_addr;
  sc_core::sc_signal<bool> write_vld;
  sc_core::sc_signal<bool> read_vld;
  sc_core::sc_signal< sc_dt::sc_bv<8> > byte_overlap_mx;
  sc_core::sc_signal< sc_dt::sc_bv<8> > byte_match_mx;
  sc_core::sc_signal< sc_dt::sc_bv<8> > ptag_hit_mx;
  sc_core::sc_signal< sc_dt::sc_bv<8> > cam_hit;

  sc_core::sc_out< sc_dt::sc_bv<45> > stb_rdata; 
  /* rd data from CAM RAM. */
  sc_core::sc_out< bool> stb_ld_partial_raw ; 
  /* ld with partial raw. */
  sc_core::sc_out< sc_dt::sc_bv<3> > stb_cam_hit_ptr;
  sc_core::sc_out< bool> stb_cam_hit ;  /* any hit in stb */
  sc_core::sc_out< bool> stb_cam_mhit ;  /* multiple hits in stb */	
  unsigned int i;
  unsigned int l;

  sc_dt::sc_bv<45> stb_ramc[64];
  sc_dt::sc_bv<45> ramc_entry;
  sc_dt::sc_bv<37> cam_tag;
  sc_dt::sc_bv<8> cam_bmask;
  sc_dt::sc_bv<64> ptag_hit;
  sc_dt::sc_bv<64> byte_match;
  sc_dt::sc_bv<64> byte_overlap;
  sc_dt::sc_bv<1> tmp;
  sc_dt::sc_bv<1> tmp1;
  sc_dt::sc_bv<8> tmp2;
  sc_dt::sc_bv<4> nibble0;
  sc_dt::sc_bv<4> nibble1;

  void n2_stb_cm_64x45_array_init()
  {
    unsigned int i;
    for(i = 0; i < 64; i++) stb_ramc[i]="000000000000000000000000000000000000000000000";
  }

  void n2_stb_cm_64x45_array_proc0()
  {
    bool tmp0;
    bool tmp1;
    sc_dt::sc_bv<6> tmp2;
  
    tmp0 = wptr_vld.read() & !(tcu_array_wr_inhibit.read());
    tmp1 = rptr_vld.read() & !(tcu_array_wr_inhibit.read());
    tmp2 = (cam_rw_tid.read(), cam_rw_ptr.read());
    write_vld.write(tmp0);
    read_vld.write(tmp1);
    rw_addr.write(tmp2);
    /* std::cout<<name()<<" n2_stb_cm_64x45_array_proc0 "<<tmp0<<" "<<tmp1<<" "<<tmp2<<std::endl; */
  }


  void n2_stb_cm_64x45_array_proc1()
  {
   sc_dt::sc_bv<45> tmp = "00000000000000000000000000000000000000000000";
  
   while(1)
   {
     wait();
     if((clk.read() == true) & (write_vld.read() == true))
     {
       if(cam_vld.read() == true)
       { 
        stb_ramc[rw_addr.read().to_int()] = tmp;
        std::cout<<"dummy write"<<std::endl;
       }
       else
       {
         stb_ramc[rw_addr.read().to_int()] = camwr_data.read();
         std::cout<<"valid write"<<std::endl;
       }
     }
   }
 } 


 void n2_stb_cm_64x45_array_proc2()
 {
   while(1)
   {
     wait();
     if((write_vld.read() | !(read_vld.read()) == true))
     {
       std::cout<<"Concurrent CAM read/write disallowed ..."<<std::endl;
     }
     else
     {
       stb_rdata = stb_ramc[rw_addr.read().to_int()];
       std::cout<<"Data read out.."<<std::endl;
     }
   }
 }


 void n2_stb_cm_64x45_array_proc3()
 { 
   while(1)
   {
     wait();
     for(l = 0; l < 64; l++)
     {
       ramc_entry = stb_ramc[l];
       cam_tag = ramc_entry.range(44,8);
       cam_bmask = ramc_entry;
       if(cam_vld.read() == true) tmp[0] = "1";
       else tmp[0] = "0";
       ptag_hit[l] = (cam_tag.range(36,1) == camwr_data.read().range(44,9)) & 
                     (cam_tag[0] == camwr_data.read()[8]) & 
                     (!cam_ldq.read() | cam_ldq.read()) & cam_vld.read() & tmp[0]; 
       byte_match[l] = (cam_bmask.range(7,0) & camwr_data.read().range(7,0)).or_reduce() & tmp[0];
       byte_overlap[l] = (~(cam_bmask.range(7,0)) & camwr_data.read().range(7,0)).or_reduce() & tmp[0]; 
     }
     /* std::cout<<name()<<" n2_stb_cm_64x45_array_proc3"<<std::endl; */
   }
 }


 void n2_stb_cm_64x45_array_proc4()
 {
   while(1)
   {
     wait();
     ptag_hit = "0000000000000000000000000000000000000000000000000000000000000000";
     byte_match = "0000000000000000000000000000000000000000000000000000000000000000";
     byte_overlap = "0000000000000000000000000000000000000000000000000000000000000000";
   }
 }


 void n2_stb_cm_64x45_array_proc5()
 {
   sc_dt::sc_bv<8> tmp0;
   sc_dt::sc_bv<8> tmp1;
   sc_dt::sc_bv<8> tmp2;
   sc_dt::sc_bv<8> tmp3;
   sc_dt::sc_bv<8> tmp4;
   sc_dt::sc_bv<8> tmp5;
   sc_dt::sc_bv<8> tmp6;
   sc_dt::sc_bv<8> tmp7;
   sc_dt::sc_bv<8> tmp;
   tmp0 = cam_cm_tid.read() == 0 ? "00000001" : "00000000";
   tmp1 = cam_cm_tid.read() == 1 ? "00000001" : "00000000";
   tmp2 = cam_cm_tid.read() == 2 ? "00000001" : "00000000";
   tmp3 = cam_cm_tid.read() == 3 ? "00000001" : "00000000";
   tmp4 = cam_cm_tid.read() == 4 ? "00000001" : "00000000";
   tmp5 = cam_cm_tid.read() == 5 ? "00000001" : "00000000";
   tmp6 = cam_cm_tid.read() == 6 ? "00000001" : "00000000";
   tmp7 = cam_cm_tid.read() == 7 ? "00000001" : "00000000";
   tmp = (tmp0 & byte_overlap.range(7,0)) |
         (tmp1 & byte_overlap.range(15,8)) |
         (tmp2 & byte_overlap.range(23,16)) |  
         (tmp3 & byte_overlap.range(31,24)) |
         (tmp4 & byte_overlap.range(39,32)) |
         (tmp5 & byte_overlap.range(47,40)) |
         (tmp6 & byte_overlap.range(55,48)) |
         (tmp7 & byte_overlap.range(63,56));
   byte_overlap_mx.write(tmp);
 }

 void n2_stb_cm_64x45_array_proc6()
 {
   sc_dt::sc_bv<8> tmp0;
   sc_dt::sc_bv<8> tmp1;
   sc_dt::sc_bv<8> tmp2;
   sc_dt::sc_bv<8> tmp3;
   sc_dt::sc_bv<8> tmp4;
   sc_dt::sc_bv<8> tmp5;
   sc_dt::sc_bv<8> tmp6;
   sc_dt::sc_bv<8> tmp7;
   sc_dt::sc_bv<8> tmp;
   tmp0 = cam_cm_tid.read() == 0 ? "00000001" : "00000000";
   tmp1 = cam_cm_tid.read() == 1 ? "00000001" : "00000000";
   tmp2 = cam_cm_tid.read() == 2 ? "00000001" : "00000000";
   tmp3 = cam_cm_tid.read() == 3 ? "00000001" : "00000000";
   tmp4 = cam_cm_tid.read() == 4 ? "00000001" : "00000000";
   tmp5 = cam_cm_tid.read() == 5 ? "00000001" : "00000000";
   tmp6 = cam_cm_tid.read() == 6 ? "00000001" : "00000000";
   tmp7 = cam_cm_tid.read() == 7 ? "00000001" : "00000000";
   tmp = (tmp0 & byte_match.range(7,0)) |
         (tmp1 & byte_match.range(15,8)) |
         (tmp2 & byte_match.range(23,16)) |  
         (tmp3 & byte_match.range(31,24)) |
         (tmp4 & byte_match.range(39,32)) |
         (tmp5 & byte_match.range(47,40)) |
         (tmp6 & byte_match.range(55,48)) |
         (tmp7 & byte_match.range(63,56));
   byte_match_mx.write(tmp);
 }

 void n2_stb_cm_64x45_array_proc7()
 {
   sc_dt::sc_bv<8> tmp0;
   sc_dt::sc_bv<8> tmp1;
   sc_dt::sc_bv<8> tmp2;
   sc_dt::sc_bv<8> tmp3;
   sc_dt::sc_bv<8> tmp4;
   sc_dt::sc_bv<8> tmp5;
   sc_dt::sc_bv<8> tmp6;
   sc_dt::sc_bv<8> tmp7;
   sc_dt::sc_bv<8> tmp;
   tmp0 = cam_cm_tid.read() == 0 ? "00000001" : "00000000";
   tmp1 = cam_cm_tid.read() == 1 ? "00000001" : "00000000";
   tmp2 = cam_cm_tid.read() == 2 ? "00000001" : "00000000";
   tmp3 = cam_cm_tid.read() == 3 ? "00000001" : "00000000";
   tmp4 = cam_cm_tid.read() == 4 ? "00000001" : "00000000";
   tmp5 = cam_cm_tid.read() == 5 ? "00000001" : "00000000";
   tmp6 = cam_cm_tid.read() == 6 ? "00000001" : "00000000";
   tmp7 = cam_cm_tid.read() == 7 ? "00000001" : "00000000";
   tmp = (tmp0 & byte_match.range(7,0)) |
         (tmp1 & ptag_hit.range(15,8)) |
         (tmp2 & ptag_hit.range(23,16)) |  
         (tmp3 & ptag_hit.range(31,24)) |
         (tmp4 & ptag_hit.range(39,32)) |
         (tmp5 & ptag_hit.range(47,40)) |
         (tmp6 & ptag_hit.range(55,48)) |
         (tmp7 & ptag_hit.range(63,56));
   ptag_hit_mx.write(tmp);
 }

 void n2_stb_cm_64x45_array_proc8()
 {
   bool tmp;
   tmp = (ptag_hit_mx.read() & 
         byte_match_mx.read() & 
         byte_overlap_mx.read() &  
         cam_line_en.read()).or_reduce();
   stb_ld_partial_raw.write(tmp);
 }


 void n2_stb_cm_64x45_array_proc9()
 { 
   cam_hit.write(ptag_hit_mx.read() & 
                 byte_match_mx.read() & 
                 cam_line_en.read()); 
   stb_cam_hit.write(cam_hit.read().or_reduce());
 }
	

 void n2_stb_cm_64x45_array_proc10()
 { 
   sc_dt::sc_bv<3> tmp;
   sc_dt::sc_bv<8> tmp0;
   tmp0 = cam_hit.read();
   tmp[0] = tmp0[1] | tmp0[3] | tmp0[5] | tmp0[7] ;
   tmp[1] = tmp0[2] | tmp0[3] | tmp0[6] | tmp0[7] ;
   tmp[2] = tmp0[4] | tmp0[5] | tmp0[6] | tmp0[7] ;
   stb_cam_hit_ptr.write(tmp);
 }


 void n2_stb_cm_64x45_array_proc11()
 {
   bool tmp0;
   
   tmp2 = cam_hit.read();
   nibble0 = tmp2.range(3,0);
   nibble1 = tmp2.range(7,4);
   tmp1[0] = (tmp2[0] & tmp2[1]) | 
             (tmp2[2] & tmp2[3])  |
             (tmp2[4] & tmp2[5]) | 
             (tmp2[6] & tmp2[7])  |
             ((tmp2[0] | tmp2[1]) & 
              (tmp2[2] | tmp2[3])) |
             ((tmp2[4] | tmp2[5]) & 
              (tmp2[6] | tmp2[7]))  |
             (nibble0.or_reduce() and nibble1.or_reduce()) ; 
   tmp0 = tmp1[0] == "1 " ? true : false; 
   stb_cam_mhit.write(tmp0);
 }


 SC_CTOR(n2_stb_cm_64x45_array)
 {
   n2_stb_cm_64x45_array_init();
   SC_THREAD(n2_stb_cm_64x45_array_proc1);
   sensitive << clk << write_vld << rw_addr << camwr_data << cam_vld;
   SC_THREAD(n2_stb_cm_64x45_array_proc2);
   sensitive << clk << read_vld << rw_addr << write_vld;
   SC_CTHREAD(n2_stb_cm_64x45_array_proc3, clk.pos());
   SC_CTHREAD(n2_stb_cm_64x45_array_proc4, siclk.pos());
   SC_METHOD(n2_stb_cm_64x45_array_proc0);
   SC_METHOD(n2_stb_cm_64x45_array_proc5);
   SC_METHOD(n2_stb_cm_64x45_array_proc6);
   SC_METHOD(n2_stb_cm_64x45_array_proc7);
   SC_METHOD(n2_stb_cm_64x45_array_proc8);
   SC_METHOD(n2_stb_cm_64x45_array_proc9);
   SC_METHOD(n2_stb_cm_64x45_array_proc10);
   SC_METHOD(n2_stb_cm_64x45_array_proc11);
 }

 ~n2_stb_cm_64x45_array(){ }
};

#endif

