#ifndef PULSECOUNTER_H
#define PULSECOUNTER_H

#include <systemc>

const double time_period = 1.0E-9;

SC_MODULE(pulsecounter)
{
  sc_core::sc_in<bool> mclk;
  sc_core::sc_in<bool> sig;
  bool start;
  double frequency;
  double h_time_interval;
  double rpm;
  unsigned int count;
  
  
  void pulsecounter_proc0()
  {
    while(1)
    {
     wait();
     if(sig.read() == true)
     {
       if(start == false)
       {
         start = true;
         count += 1;
       }
       else if(start == true)
       {
         count += 1;
       }
     }
     else if(sig.read() == false)
     {
       if(start == true)
       {
         start = false;
         h_time_interval = (double)(time_period*count);
         frequency = 1.0/(2.0*h_time_interval);
         rpm = 60*frequency;
         std::cout<<std::scientific<<frequency<<" Hz "<<rpm<<" RPM"<<std::endl;
         h_time_interval = 0.0;
         count = 0;
       }
     }
    }
  }

  SC_CTOR(pulsecounter):start(false),
                        count(0),
                        frequency(0.0),
                        h_time_interval(0.0),
                        rpm(0.0)
  { 
    SC_CTHREAD(pulsecounter_proc0, mclk.pos());
  }
  ~pulsecounter(){ }
};

#endif

