#ifndef PWMSYSC_H
#define PWMSYSC_H

#include <systemc>

SC_MODULE(pwmtrstl)
{
  sc_core::sc_in<double> intriangle;
  sc_core::sc_in<double> refsigin;
  sc_core::sc_out<double> pwmout;
  double refval;
  double trival;
  double pwmval;


  void pwmtrstl_proc0()
  {
    while(1)
    {
      wait();
      refval = refsigin.read();
      trival = intriangle.read();
      pwmval = trival > refval ? 1.0 : 0.0;
      pwmout.write(pwmval);
    }
  }

  SC_CTOR(pwmtrstl):pwmval(0.0),
                     refval(0.0),
                     trival(0.0)
  {
    SC_THREAD(pwmtrstl_proc0);
    sensitive << refsigin << intriangle;
  }
  ~pwmtrstl(){ }
};

#endif

