#ifndef SIGANAL_H
#define SIGANAL_H

#include <systemc>

SC_MODULE(dff)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in0;
  sc_core::sc_out<bool> out0;

  void dff_proc0()
  {
    while(1)
    {
      wait();
      out0.write(in0.read());
    }
  }

  SC_CTOR(dff)
  {
    SC_THREAD(dff_proc0);
    sensitive << clk.pos();
  }

  ~dff(){ }
};

SC_MODULE(xorgate)
{
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;
  bool b0;
  bool b1;
  bool b2;

  void xorgate_proc0()
  {
    while(1)
    {
      wait();
      b0 = in0.read();
      b1 = in1.read();
      b2 = ((b0 & !b1) | (!b0 & b1));
      out0.write(b2);
      out1.write(b2);
    }
  }

  SC_CTOR(xorgate)
  {
    SC_THREAD(xorgate_proc0);
    sensitive << in0 << in1;
  }

  ~xorgate(){ }
};

SC_MODULE(siganal6x6)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_in<bool> in0;
  sc_core::sc_in<bool> in1;
  sc_core::sc_in<bool> in2;
  sc_core::sc_in<bool> in3;
  sc_core::sc_in<bool> in4;
  sc_core::sc_in<bool> in5;
  sc_core::sc_in<bool> in6;

  sc_core::sc_out<bool> out0;
  sc_core::sc_out<bool> out1;
  sc_core::sc_out<bool> out2;
  sc_core::sc_out<bool> out3;
  sc_core::sc_out<bool> out4;
  sc_core::sc_out<bool> out5;
  sc_core::sc_out<bool> out6;
  sc_core::sc_out<bool> out7;

  sc_core::sc_signal<bool> sig0;
  sc_core::sc_signal<bool> sig1;
  sc_core::sc_signal<bool> sig2;
  sc_core::sc_signal<bool> sig3;
  sc_core::sc_signal<bool> sig4;
  sc_core::sc_signal<bool> sig5;
  sc_core::sc_signal<bool> sig6;
  sc_core::sc_signal<bool> sig7;
  sc_core::sc_signal<bool> sig8;
  sc_core::sc_signal<bool> sig9;
  sc_core::sc_signal<bool> sig10;
  sc_core::sc_signal<bool> sig11;
  sc_core::sc_signal<bool> sig12;
  sc_core::sc_signal<bool> sig13;
  sc_core::sc_signal<bool> sig14;

  dff df0;
  dff df1;
  dff df2;
  dff df3;
  dff df4;
  dff df5;
  dff df6;

  xorgate xog0;
  xorgate xog1;
  xorgate xog2;
  xorgate xog3;
  xorgate xog4;
  xorgate xog5;
  xorgate xog6;
  xorgate xog7;

  SC_CTOR(siganal6x6):df0("df0"), df1("df1"), df2("df2"), df3("df3"),
                      df4("df4"), df5("df5"), df6("df6"), xog0("xog0"), 
                      xog1("xog1"), xog2("xog2"), xog3("xog3"), 
                      xog4("xog4"), xog5("xog5"), xog6("xog6"), 
                      xog7("xog7"), sig0("sig0"), sig1("sig1"),
                      sig2("sig2"), sig3("sig3"), sig4("sig4"), 
                      sig5("sig5"), sig6("sig6"), sig7("sig7"),
                      sig8("sig8"), sig9("sig9"), sig10("sig10"), 
                      sig11("sig11"),sig12("sig12"), sig13("sig13"), 
                      sig14("sig14")
  {
     df0.clk(clk);
     df0.in0(sig0);
     df0.out0(sig1);

     df1.clk(clk);
     df1.in0(sig2);
     df1.out0(sig3);

     df2.clk(clk);
     df2.in0(sig4);
     df2.out0(sig5);

     df3.clk(clk);
     df3.in0(sig6);
     df3.out0(sig7);

     df4.clk(clk);
     df4.in0(sig8);
     df4.out0(sig9);

     df5.clk(clk);
     df5.in0(sig10);
     df5.out0(sig11);

     df6.clk(clk);
     df6.in0(sig12);
     df6.out0(sig13);

     xog0.in0(in0);
     xog0.in1(sig14);
     xog0.out0(out0);
     xog0.out1(sig0);

     xog1.in0(in1);
     xog1.in1(sig1);
     xog1.out0(out1);
     xog1.out1(sig2);
     
     xog2.in0(in2);
     xog2.in1(sig3);
     xog2.out0(out2);
     xog2.out1(sig4);

     xog3.in0(in3);
     xog3.in1(sig5);
     xog3.out0(out3);
     xog3.out1(sig6);

     xog4.in0(in4);
     xog4.in1(sig7);
     xog4.out0(out4);
     xog4.out1(sig8);

     xog5.in0(in5);
     xog5.in1(sig9);
     xog5.out0(out5);
     xog5.out1(sig10);

     xog6.in0(in6);
     xog6.in1(sig11);
     xog6.out0(out6);
     xog6.out1(sig12);

     xog7.in0(sig1);
     xog7.in1(sig13);
     xog7.out0(out7);
     xog7.out1(sig14);
   }

   ~siganal6x6(){ }
};

#endif

