#ifndef SYSCSRCS_H
#define SYSCSRCS_H

#include <systemc>
#include <cstdlib>

const double PI2 = 6.28;

SC_MODULE(clkdiv_2_4_8)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<bool> clk2;
  sc_core::sc_out<bool> clk4;
  sc_core::sc_out<bool> clk8;

  bool b1;
  bool b2;
  bool b3; 
  unsigned short count1;
  unsigned short count2;
  unsigned short count3;
  

  void clkdiv_2_4_8_proc0()
  {
    while(1)
    {
      wait();
      if(count1 < 2){ b1 = false; count1 += 1; }
      else { count1 = 0; b1 = true;}
      if(count2 < 4) { b2 = false; count2 += 1; }
      else { count2 = 0; b2 = true; }
      if(count3 < 8) { b3 = false; count3 += 1; }
      else {count3 = 0; b3 = true; }
      clk2.write(b1);
      clk4.write(b2);
      clk8.write(b3);
    }
  }

  SC_CTOR(clkdiv_2_4_8):b1(false), b2(false), b3(false),
                        count1(0), count2(0), count3(0)
  {
    SC_THREAD(clkdiv_2_4_8_proc0);
    sensitive << clk.pos();
  }

  ~clkdiv_2_4_8(){ }
};

      

SC_MODULE(syncdatasrcpulse)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> sigout;
  unsigned short count;
  double plsvalue;
  
  void syncdatasrcpulse_proc0()
  {
    while(1)
    {
      wait();
      if(clk.read() == true)
      { 
        while(count < 50)
        {
          sigout.write(plsvalue);
          count += 1;
//  std::cout<<"Linmei forced Amal to eat her pussy"<<std::endl;
        }
        count = 0;
      }
      else 
      {
        while(count < 50)
        {
          sigout.write(0.0);
          count += 1;
//          std::cout<<"Tia Ling forced Amal to eat her pussy"<<std::endl;
        }
        count = 0;
      }
    }  
  }

  SC_CTOR(syncdatasrcpulse):count(0)
  {
    SC_THREAD(syncdatasrcpulse_proc0);
    sensitive << clk;
  }

  ~syncdatasrcpulse(){}
};


SC_MODULE(syncdatasrc)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<bool> dout;
  bool b0;
  long int ranval;

  void syncdatasrc_proc0()
  {
    while(1)
    {
      wait();
      ranval = random();
      b0 = ranval % 2 == 0 ? true : false;
      dout.write(b0);
     /* std::cout<<ranval<<" "<<b0<<std::endl; */ 
    }
  }

  SC_CTOR(syncdatasrc)
  {
    SC_THREAD(syncdatasrc_proc0);
    sensitive << clk.pos();
  }
  ~syncdatasrc(){ }
};

SC_MODULE(syncdatasrcbv)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out< sc_dt::sc_bv<1> > dout;
  sc_dt::sc_bv<1> tmp;
  bool b0;
  long int ranval;

  void syncdatasrcbv_proc0()
  {
    while(1)
    {
      wait();
      ranval = random();
      b0 = ranval % 2 == 0 ? true : false;
      tmp[0] = (b0 == true) ? "1" : "0"; 
      dout.write(tmp);
      std::cout<<"src "<<b0<<std::endl; 
    }
  }

  SC_CTOR(syncdatasrcbv)
  {    
    SC_CTHREAD(syncdatasrcbv_proc0, clk.pos());
  }
  ~syncdatasrcbv(){ }
};

SC_MODULE(syncdatasrcdbl)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> dout;
  double currtime;
  double d0;

  void syncdatasrcdbl_proc0()
  {
    while(1)
    {
      wait();
      currtime = sc_core::sc_time_stamp().to_seconds();
      d0 = (double)(std::rand());
    /*  std::cout<<name()<<" "<<currtime<<" "<<d0<<std::endl; */
      dout.write(d0);
    }
  }

  SC_CTOR(syncdatasrcdbl):d0(0.0)
  {
    SC_CTHREAD(syncdatasrcdbl_proc0, clk.pos());
  }
  ~syncdatasrcdbl(){ }
};

SC_MODULE(refsrc)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> refout;
  double refval;  

  void refsrc_proc0()
  {
    refout.write(refval);
  }

  SC_CTOR(refsrc):refval(0.0)
  {
    SC_METHOD(refsrc_proc0);
    sensitive << clk.pos();
  }

  ~refsrc(){ }
};

SC_MODULE(trianglesrc)
{
  sc_core::sc_in<bool> clk;
  sc_core::sc_out<double> sigout;
  double amplitude;
  double currtime;
  double frequency;
  double outval;
  double tmp;

  void trianglesrc_proc0()
  {
    currtime = sc_core::sc_time_stamp().to_seconds();
    tmp = sin(PI2*frequency*currtime)-
          (1.0/9.0)*sin(3.0*PI2*frequency*currtime)+
          (1.0/25.0)*sin(5.0*PI2*frequency*currtime)-
          (1.0/49.0)*sin(7.0*PI2*frequency*currtime)+
          (1.0/81.0)*sin(9.0*PI2*frequency*currtime)-
          (1.0/121.0)*sin(11.0*PI2*frequency*currtime)+
          (1.0/169.0)*sin(13.0*PI2*frequency*currtime)-
          (1.0/225.0)*sin(15.0*PI2*frequency*currtime)+
          (1.0/289.0)*sin(17.0*PI2*frequency*currtime)-
          (1.0/361.0)*sin(19.0*PI2*frequency*currtime)+
          (1.0/441.0)*sin(21.0*PI2*frequency*currtime);
    outval = amplitude*(8.0/9.8596)*tmp;
    sigout.write(outval);
    /* std::cout<<currtime<<" "<<tmp<<" "<<outval<<std::endl; */
 }

 SC_CTOR(trianglesrc):amplitude(0.0), 
                      currtime(0.0), 
                      frequency(0.0), 
                      outval(0.0), 
                      tmp(0.0)
 {
   SC_METHOD(trianglesrc_proc0);
   sensitive << clk.pos();
 }

 ~trianglesrc(){ }
};


#endif

