#include "ac_anal_l_p_fo_sdom.h"
#include "commonsrcs.h"
#include "gendatatrace.h"
#include <cstdlib>
#include <cstring>

int sc_main(int argc, char **argv)
{
  double amplitude;
  double frequency;

  if(argc < 3)
  {
    std::cout<<"Insufficient input parameters ..."<<std::endl;
    std::cout<<"usage ./sim <amplitude> <frequency>"<<std::endl;
    exit(0);
  }

  sca_tdf::sca_signal<double> sigin0;
  sca_tdf::sca_signal<double> sigout0;
  sca_tdf::sca_signal<double> sigin1;
  sca_tdf::sca_signal<double> sigout1;
  sca_tdf::sca_signal<double> sigout2;
 
  amplitude = strtod(argv[1], NULL);
  frequency = strtod(argv[2], NULL);
 
  lpo1sdom f1("f1"); 
  lpo2sdom f2("f2");
  lpo3sdom f3("f3");
  
  sinsrc sin_src("sin_src");
  tracedoublecombo trdbl("tr_nd");

  sin_src.sigout(sigin0);
  sin_src.amplitude = amplitude;
  sin_src.frequency = frequency;

  f1.sigin(sigin0);
  f1.sigout(sigout0);

  f2.sigin(sigout0);
  f2.sigout(sigout1);

  f3.sigin(sigout1);
  f3.sigout(sigout2);

  trdbl.in1(sigin0);
  trdbl.in2(sigout2); 

  sc_core::sc_start(100.0, sc_core::SC_MS);
  return 0;
}
  
