#include "addsub.h"
#include "systemc.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal<bool> insig0;
  sc_core::sc_signal<bool> insig1;
  sc_core::sc_signal<bool> insig2;
  sc_core::sc_signal<bool> insig3;
  sc_core::sc_signal<bool> insig4;
  sc_core::sc_signal<bool> insig5;
  sc_core::sc_signal<bool> insig6;
  sc_core::sc_signal<bool> insig7;
  sc_core::sc_signal<bool> modesig;

  sc_core::sc_signal<bool> outsig0;
  sc_core::sc_signal<bool> outsig1;
  sc_core::sc_signal<bool> outsig2;
  sc_core::sc_signal<bool> outsig3;
  sc_core::sc_signal<bool> carryout;

  bool b0;
  bool b1;
  bool b2;
  bool b3;
  bool b4;
  bool b5;
  bool b6;
  bool b7;
  bool modebit;

  addsub4bit add_sub_4_bit("add_sub_4_bit");
  sc_core::sc_trace_file *fp;
  fp = sc_create_vcd_trace_file("tr_addsub4bit");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  add_sub_4_bit.in0(insig0);
  add_sub_4_bit.in1(insig1);
  add_sub_4_bit.in2(insig2);
  add_sub_4_bit.in3(insig3);
  add_sub_4_bit.in4(insig4);
  add_sub_4_bit.in5(insig5);
  add_sub_4_bit.in6(insig6);
  add_sub_4_bit.in7(insig7);
  add_sub_4_bit.in8(modesig);

  add_sub_4_bit.out0(outsig0);
  add_sub_4_bit.out1(outsig1);
  add_sub_4_bit.out2(outsig2);
  add_sub_4_bit.out3(outsig3);
  add_sub_4_bit.out4(carryout);

  sc_core::sc_trace(fp, insig0, "in0");
  sc_core::sc_trace(fp, insig1, "in1");
  sc_core::sc_trace(fp, insig2, "in2");
  sc_core::sc_trace(fp, insig3, "in3");
  sc_core::sc_trace(fp, insig4, "in4");
  sc_core::sc_trace(fp, insig5, "in5");
  sc_core::sc_trace(fp, insig6, "in6");
  sc_core::sc_trace(fp, insig7, "in7");
  sc_core::sc_trace(fp, modesig, "mode");
  sc_core::sc_trace(fp, outsig0, "out0");
  sc_core::sc_trace(fp, outsig1, "out1");
  sc_core::sc_trace(fp, outsig2, "out2");
  sc_core::sc_trace(fp, outsig3, "out3");
  sc_core::sc_trace(fp, carryout, "carryout");

  b0 = false;
  b1 = false;
  b2 = false;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = false;
  b7 = false;
  modebit = false;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = false;
  b2 = true;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = true;
  b7 = false;
  modebit = false;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);
  
  b0 = true;
  b1 = true;
  b2 = true;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = true;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);
  
  b0 = false;
  b1 = true;
  b2 = false;
  b3 = true;
  b4 = false;
  b5 = true;
  b6 = true;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = true;
  b3 = true;
  b4 = false;
  b5 = false;
  b6 = true;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = true;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = true;
  b7 = true;
  modebit = false;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = false;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = false;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = true;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = true;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = false;
  b1 = true;
  b2 = false;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = false;
  b7 = true;
  modebit = false;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = false;
  b3 = false;
  b4 = true;
  b5 = false;
  b6 = true;
  b7 = true;
  modebit = false;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = false;
  b1 = false;
  b2 = false;
  b3 = false;
  b4 = false;
  b5 = false;
  b6 = false;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);

  b0 = true;
  b1 = true;
  b2 = false;
  b3 = false;
  b4 = true;
  b5 = true;
  b6 = false;
  b7 = true;
  modebit = true;

  insig0.write(b0);
  insig1.write(b1);
  insig2.write(b2);
  insig3.write(b3);
  insig4.write(b4);
  insig5.write(b5);
  insig6.write(b6);
  insig7.write(b7);
  modesig.write(modebit);

  sc_core::sc_start(4.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}

