#include "booth.h"

int sc_main(int argc, char **argv)
{
  sc_core::sc_signal< sc_dt::sc_bv<32> > multiplier_sig;
  sc_core::sc_signal< sc_dt::sc_bv<32> > multiplicand_sig;
  sc_core::sc_signal<bool> done_sig;
  sc_core::sc_signal<bool> enable_sig;
  sc_core::sc_signal< sc_dt::sc_bv<64> > product_sig;

  sc_dt::sc_bv<32> multiplier_value;
  sc_dt::sc_bv<32> multiplicand_value;
  bool enable_value;

  sc_core::sc_clock clk("clk", 2.0, sc_core::SC_NS, 0.5);
  booth booth_mult("booth_mult");
  sc_core::sc_trace_file *fp = sc_core::sc_create_vcd_trace_file("tr_booth");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  booth_mult.clk(clk);
  booth_mult.enable(enable_sig);
  booth_mult.multiplier(multiplier_sig);
  booth_mult.multiplicand(multiplicand_sig);
  booth_mult.done(done_sig);
  booth_mult.product(product_sig);

  sc_core::sc_trace(fp, clk, "clk");
  sc_core::sc_trace(fp, enable_sig, "enable");
  sc_core::sc_trace(fp, multiplier_sig, "multiplier");
  sc_core::sc_trace(fp, multiplicand_sig, "multiplicand");
  sc_core::sc_trace(fp, done_sig, "done");
  sc_core::sc_trace(fp, product_sig, "product");
  
  enable_value = true;
  multiplier_value = "00111100110000110101010110101011";
  multiplicand_value = "01111000100001110101110010100011";

  enable_sig.write(enable_value);
  multiplier_sig.write(multiplier_value);
  multiplicand_sig.write(multiplicand_value);

  sc_core::sc_start(400.0, sc_core::SC_NS);

  enable_value = false;
  multiplier_value = "1011010001001011111000010000111101";
  multiplicand_value = "01010001100010100111010110110011";

  enable_sig.write(enable_value);
  multiplier_sig.write(multiplier_value);
  multiplicand_sig.write(multiplicand_value);

  sc_core::sc_start(100.0, sc_core::SC_NS);

  enable_value = true;
  multiplier_value = "1011010001001011111000010000111101";
  multiplicand_value = "01010001100010100111010110110011";

  enable_sig.write(enable_value);
  multiplier_sig.write(multiplier_value);
  multiplicand_sig.write(multiplicand_value);

  sc_core::sc_start(300.0, sc_core::SC_NS);
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);  
  return 0;
}

