#include "testbv.h" 
#include <cstdlib>
#include <cstring>
#include "systemc.h"

/* TEST BENCH SYSTEMC EXAMPLE 5.5 - BIT VECTOR ONLY IO */

int sc_main(int argc, char **argv)
{
  /* Combinational logic – NO clocks allowed */
  /* Multiplexer input/output bit-vector channels */
  sc_core::sc_signal< sc_dt::sc_bv<8> > din;
  sc_core::sc_signal< sc_dt::sc_bv<8> > sel;
  sc_core::sc_signal< sc_dt::sc_bv<1> > out;
  /* Local bit vectors */
  sc_dt::sc_bv<8> dbv;
  sc_dt::sc_bv<8> selbv;
  /* Trace file pointer */
  sc_core::sc_trace_file *fp;
  /* Declare/define multiplexer */
  mux8 mux_8("mux_8");
  fp = sc_create_vcd_trace_file("tr_mux_8");
  fp->set_time_unit(1.0, sc_core::SC_NS);

  /* Connect input/output ports and channels */
  mux_8.in(din);
  mux_8.sel(sel);
  mux_8.out(out);
  /* Connect trace file and data channels */
  sc_trace(fp, din, "din");
  sc_trace(fp, sel, "sel");
  sc_trace(fp, out, "out");
  /* Generate new data and run simulation for 1 time step */
  dbv="10000000";
  selbv="10000000";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  /* Generate new data and run simulation for 1 time step */
  dbv="01000000";
  selbv="01000000";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  /* Print input bit vector, select bit vector and output
     bit vector to console */
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="01000000";
  selbv="00100000";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="00010000";
  selbv="00010000";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="00010000";
  selbv="00001000";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="00000100";
  selbv="00000100";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);  
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="00000010";
  selbv="00000010";
  din.write(dbv);
  sel.write(selbv);
  sc_start(1.0, sc_core::SC_NS);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  /* Generate new data and run simulation for 1 time step */
  dbv="00000001";
  selbv="00000001";
  din.write(dbv);
  sel.write(selbv);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<" Data ";
  std::cout<<din.read()<<" Select "<<sel.read()<<" Output ";
  std::cout<<out.read()<<std::endl;
  sc_start(1.0, sc_core::SC_NS);
  /* Stop simulation and close trace file */
  sc_core::sc_stop();
  sc_close_vcd_trace_file(fp);
  return 0;
}


