#include "n2_cl_u1.h"
#include <cstdlib>
#include <cstring>

/* TEST BENCH SYSTEMC EXAMPLE 5.2 */

int sc_main(int argc, char **argv)
{
  /* Combinational logic – NO clocks allowed */
  /* Input/output channels */
  sc_core::sc_signal<bool> sigin0;
  sc_core::sc_signal<bool> sigin1;
  sc_core::sc_signal<bool> sigin2;
  sc_core::sc_signal<bool> sigin3;
  sc_core::sc_signal<bool> sigout0;
  /* Declare trace file pointer */
  sc_core::sc_trace_file *fp;
  /* Declare/define NAND gate and VCD trace file */
  cl_u1_nand4_8x nand4("nand4");
  fp = sc_create_vcd_trace_file("tr_4_1_bit_nand");
  fp->set_time_unit(1.0, sc_core::SC_US);
  /* Connect module ports and channels */
  nand4.in0(sigin0);
  nand4.in1(sigin1);
  nand4.in2(sigin2);
  nand4.in3(sigin3);
  nand4.out(sigout0);
  nand4.LIB = true; /*Set environmanr variable */
  /* Connect trace file and channels */
  sc_trace(fp, sigin0, "nand4_in_0");
  sc_trace(fp, sigin1, "nand4_in_1");
  sc_trace(fp, sigin2, "nand4_in_2");
  sc_trace(fp, sigin3, "nand4_in_3");
  sc_trace(fp, sigout0, "nand4_out");
  /* Generate data and run single simulation step */
  sigin0.write(false);
  sigin1.write(true);
  sigin2.write(true);
  sigin3.write(false);
  sc_start(1.0,sc_core::SC_US);
  /* Print current simulation time and signal
     values on console */
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(true);
  sigin3.write(false);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(false);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(false);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(false);
  sigin1.write(true);
  sigin2.write(true);
  sigin3.write(true);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(true);
  sigin1.write(true);
  sigin2.write(true);
  sigin3.write(true);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(true);
  sigin1.write(false);
  sigin2.write(false);
  sigin3.write(true);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Change data and run simulation step */
  sigin0.write(true);
  sigin1.write(true);
  sigin2.write(false);
  sigin3.write(false);
  sc_start(1.0,sc_core::SC_US);
  std::cout<<sc_core::sc_time_stamp().to_seconds()<<"\t";
  std::cout<<sigin0.read()<<"\t"<<sigin1.read()<<"\t";
  std::cout<<sigin2.read()<<"\t"<<sigin3.read()<<"\t";
  std::cout<<sigout0.read()<<std::endl;
  /* Stop simulation, close trace file */
  sc_core::sc_stop();
  sc_core::sc_close_vcd_trace_file(fp);
  return 0;
}
